/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import opennlp.tools.chunker.ChunkSampleStream;
import opennlp.tools.chunker.Chunker;
import opennlp.tools.chunker.ChunkerFactory;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.formats.ResourceAsStreamFactory;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.InsufficientTrainingDataException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.Span;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ChunkerMETest {
    private Chunker chunker;
    private static final String[] toks1 = new String[]{"Rockwell", "said", "the", "agreement", "calls", "for", "it", "to", "supply", "200", "additional", "so-called", "shipsets", "for", "the", "planes", "."};
    private static final String[] tags1 = new String[]{"NNP", "VBD", "DT", "NN", "VBZ", "IN", "PRP", "TO", "VB", "CD", "JJ", "JJ", "NNS", "IN", "DT", "NNS", "."};
    private static final String[] expect1 = new String[]{"B-NP", "B-VP", "B-NP", "I-NP", "B-VP", "B-SBAR", "B-NP", "B-VP", "I-VP", "B-NP", "I-NP", "I-NP", "I-NP", "B-PP", "B-NP", "I-NP", "O"};

    @Test
    void downloadNonExistentModel() {
        Assertions.assertThrows(IOException.class, () -> {
            ChunkerME chunker = new ChunkerME("en");
            Object[] preds = chunker.chunk(toks1, tags1);
            Assertions.assertArrayEquals((Object[])expect1, (Object[])preds);
        });
    }

    @BeforeEach
    void startup() throws IOException {
        ResourceAsStreamFactory in = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/chunker/test.txt");
        ChunkSampleStream sampleStream = new ChunkSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)in, StandardCharsets.UTF_8));
        TrainingParameters params = new TrainingParameters();
        params.put("Iterations", 70);
        params.put("Cutoff", 1);
        ChunkerModel chunkerModel = ChunkerME.train((String)"eng", (ObjectStream)sampleStream, (TrainingParameters)params, (ChunkerFactory)new ChunkerFactory());
        this.chunker = new ChunkerME(chunkerModel);
    }

    @Test
    void testChunkAsArray() {
        Object[] preds = this.chunker.chunk(toks1, tags1);
        Assertions.assertArrayEquals((Object[])expect1, (Object[])preds);
    }

    @Test
    void testChunkAsSpan() {
        Span[] preds = this.chunker.chunkAsSpans(toks1, tags1);
        Assertions.assertEquals((int)10, (int)preds.length);
        Assertions.assertEquals((Object)new Span(0, 1, "NP"), (Object)preds[0]);
        Assertions.assertEquals((Object)new Span(1, 2, "VP"), (Object)preds[1]);
        Assertions.assertEquals((Object)new Span(2, 4, "NP"), (Object)preds[2]);
        Assertions.assertEquals((Object)new Span(4, 5, "VP"), (Object)preds[3]);
        Assertions.assertEquals((Object)new Span(5, 6, "SBAR"), (Object)preds[4]);
        Assertions.assertEquals((Object)new Span(6, 7, "NP"), (Object)preds[5]);
        Assertions.assertEquals((Object)new Span(7, 9, "VP"), (Object)preds[6]);
        Assertions.assertEquals((Object)new Span(9, 13, "NP"), (Object)preds[7]);
        Assertions.assertEquals((Object)new Span(13, 14, "PP"), (Object)preds[8]);
        Assertions.assertEquals((Object)new Span(14, 16, "NP"), (Object)preds[9]);
    }

    @Test
    void testTokenProbArray() {
        Sequence[] preds = this.chunker.topKSequences(toks1, tags1);
        Assertions.assertTrue((preds.length > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)expect1.length, (int)preds[0].getProbs().length);
        Assertions.assertEquals(Arrays.asList(expect1), (Object)preds[0].getOutcomes());
        Assertions.assertNotSame(Arrays.asList(expect1), (Object)preds[1].getOutcomes());
    }

    @Test
    void testTokenProbMinScore() {
        Sequence[] preds = this.chunker.topKSequences(toks1, tags1, -5.55);
        Assertions.assertEquals((int)4, (int)preds.length);
        Assertions.assertEquals((int)expect1.length, (int)preds[0].getProbs().length);
        Assertions.assertEquals(Arrays.asList(expect1), (Object)preds[0].getOutcomes());
        Assertions.assertNotSame(Arrays.asList(expect1), (Object)preds[1].getOutcomes());
    }

    @Test
    void testInsufficientData() {
        Assertions.assertThrows(InsufficientTrainingDataException.class, () -> {
            ResourceAsStreamFactory in = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/chunker/test-insufficient.txt");
            ChunkSampleStream sampleStream = new ChunkSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)in, StandardCharsets.UTF_8));
            TrainingParameters params = new TrainingParameters();
            params.put("Iterations", 70);
            params.put("Cutoff", 1);
            ChunkerME.train((String)"eng", (ObjectStream)sampleStream, (TrainingParameters)params, (ChunkerFactory)new ChunkerFactory());
        });
    }
}

