/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.IOException;
import java.nio.file.Path;
import opennlp.tools.AbstractModelLoaderTest;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ChunkerMEIT
extends AbstractModelLoaderTest {
    private static final String[] toks1 = new String[]{"Rockwell", "said", "the", "agreement", "calls", "for", "it", "to", "supply", "200", "additional", "so-called", "shipsets", "for", "the", "planes", "."};
    private static final String[] tags1 = new String[]{"NNP", "VBD", "DT", "NN", "VBZ", "IN", "PRP", "TO", "VB", "CD", "JJ", "JJ", "NNS", "IN", "DT", "NNS", "."};
    private static final String[] expect1 = new String[]{"B-NP", "B-VP", "B-NP", "I-NP", "B-VP", "B-SBAR", "B-NP", "B-VP", "I-VP", "B-NP", "I-NP", "I-NP", "I-NP", "B-PP", "B-NP", "I-NP", "O"};
    private static final String modelName = "en-chunker.bin";
    private static ChunkerME chunker;

    @BeforeAll
    public static void prepare() throws IOException {
        ChunkerMEIT.downloadVersion15Model(modelName);
        Path modelPath = OPENNLP_DIR.resolve(modelName);
        ChunkerModel model = new ChunkerModel(modelPath);
        chunker = new ChunkerME(model);
    }

    @Test
    void testChunk() {
        Object[] preds = chunker.chunk(toks1, tags1);
        Assertions.assertArrayEquals((Object[])expect1, (Object[])preds);
    }
}

