/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkSampleStream;
import opennlp.tools.chunker.ChunkerFactory;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.chunker.DefaultChunkerContextGenerator;
import opennlp.tools.chunker.DefaultChunkerSequenceValidator;
import opennlp.tools.chunker.DummyChunkerFactory;
import opennlp.tools.formats.ResourceAsStreamFactory;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChunkerFactoryTest {
    private static ObjectStream<ChunkSample> createSampleStream() throws IOException {
        ResourceAsStreamFactory in = new ResourceAsStreamFactory(ChunkerFactoryTest.class, "/opennlp/tools/chunker/test.txt");
        return new ChunkSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)in, StandardCharsets.UTF_8));
    }

    private static ChunkerModel trainModel(ModelType type, ChunkerFactory factory) throws IOException {
        return ChunkerME.train((String)"eng", ChunkerFactoryTest.createSampleStream(), (TrainingParameters)TrainingParameters.defaultParams(), (ChunkerFactory)factory);
    }

    @Test
    void testDefaultFactory() throws IOException {
        ChunkerModel model = ChunkerFactoryTest.trainModel(ModelType.MAXENT, new ChunkerFactory());
        ChunkerFactory factory = model.getFactory();
        Assertions.assertInstanceOf(DefaultChunkerContextGenerator.class, (Object)factory.getContextGenerator());
        Assertions.assertInstanceOf(DefaultChunkerSequenceValidator.class, (Object)factory.getSequenceValidator());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        model.serialize((OutputStream)out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ChunkerModel fromSerialized = new ChunkerModel((InputStream)in);
        factory = fromSerialized.getFactory();
        Assertions.assertInstanceOf(DefaultChunkerContextGenerator.class, (Object)factory.getContextGenerator());
        Assertions.assertInstanceOf(DefaultChunkerSequenceValidator.class, (Object)factory.getSequenceValidator());
    }

    @Test
    void testDummyFactory() throws IOException {
        ChunkerModel model = ChunkerFactoryTest.trainModel(ModelType.MAXENT, new DummyChunkerFactory());
        DummyChunkerFactory factory = (DummyChunkerFactory)model.getFactory();
        Assertions.assertInstanceOf(DummyChunkerFactory.DummyContextGenerator.class, (Object)factory.getContextGenerator());
        Assertions.assertInstanceOf(DummyChunkerFactory.DummySequenceValidator.class, factory.getSequenceValidator());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        model.serialize((OutputStream)out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ChunkerModel fromSerialized = new ChunkerModel((InputStream)in);
        factory = (DummyChunkerFactory)fromSerialized.getFactory();
        Assertions.assertInstanceOf(DefaultChunkerContextGenerator.class, (Object)factory.getContextGenerator());
        Assertions.assertInstanceOf(DefaultChunkerSequenceValidator.class, factory.getSequenceValidator());
        ChunkerME chunker = new ChunkerME(model);
        String[] toks1 = new String[]{"Rockwell", "said", "the", "agreement", "calls", "for", "it", "to", "supply", "200", "additional", "so-called", "shipsets", "for", "the", "planes", "."};
        String[] tags1 = new String[]{"NNP", "VBD", "DT", "NN", "VBZ", "IN", "PRP", "TO", "VB", "CD", "JJ", "JJ", "NNS", "IN", "DT", "NNS", "."};
        chunker.chunk(toks1, tags1);
    }
}

