/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import opennlp.tools.chunker.Chunker;
import opennlp.tools.chunker.ChunkerEvaluationMonitor;
import opennlp.tools.chunker.ChunkerEvaluator;
import opennlp.tools.chunker.DummyChunkSampleStream;
import opennlp.tools.chunker.DummyChunker;
import opennlp.tools.cmdline.chunker.ChunkEvaluationErrorListener;
import opennlp.tools.formats.ResourceAsStreamFactory;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.eval.FMeasure;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChunkerEvaluatorTest {
    private static final double DELTA = 1.0E-9;

    @Test
    void testEvaluator() throws IOException {
        ResourceAsStreamFactory inPredicted = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/chunker/output.txt");
        ResourceAsStreamFactory inExpected = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/chunker/output.txt");
        DummyChunkSampleStream predictedSample = new DummyChunkSampleStream((ObjectStream<String>)new PlainTextByLineStream((InputStreamFactory)inPredicted, StandardCharsets.UTF_8), true);
        DummyChunkSampleStream expectedSample = new DummyChunkSampleStream((ObjectStream<String>)new PlainTextByLineStream((InputStreamFactory)inExpected, StandardCharsets.UTF_8), false);
        DummyChunker dummyChunker = new DummyChunker(predictedSample);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ChunkEvaluationErrorListener listener = new ChunkEvaluationErrorListener((OutputStream)stream);
        ChunkerEvaluator evaluator = new ChunkerEvaluator((Chunker)dummyChunker, new ChunkerEvaluationMonitor[]{listener});
        evaluator.evaluate((ObjectStream)expectedSample);
        FMeasure fm = evaluator.getFMeasure();
        Assertions.assertEquals((double)0.8, (double)fm.getPrecisionScore(), (double)1.0E-9);
        Assertions.assertEquals((double)0.875, (double)fm.getRecallScore(), (double)1.0E-9);
        Assertions.assertNotSame((Object)0, (Object)((Object)stream).toString().length());
    }

    @Test
    void testEvaluatorNoError() throws IOException {
        ResourceAsStreamFactory inPredicted = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/chunker/output.txt");
        ResourceAsStreamFactory inExpected = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/chunker/output.txt");
        DummyChunkSampleStream predictedSample = new DummyChunkSampleStream((ObjectStream<String>)new PlainTextByLineStream((InputStreamFactory)inPredicted, StandardCharsets.UTF_8), true);
        DummyChunkSampleStream expectedSample = new DummyChunkSampleStream((ObjectStream<String>)new PlainTextByLineStream((InputStreamFactory)inExpected, StandardCharsets.UTF_8), true);
        DummyChunker dummyChunker = new DummyChunker(predictedSample);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ChunkEvaluationErrorListener listener = new ChunkEvaluationErrorListener((OutputStream)stream);
        ChunkerEvaluator evaluator = new ChunkerEvaluator((Chunker)dummyChunker, new ChunkerEvaluationMonitor[]{listener});
        evaluator.evaluate((ObjectStream)expectedSample);
        FMeasure fm = evaluator.getFMeasure();
        Assertions.assertEquals((double)1.0, (double)fm.getPrecisionScore(), (double)1.0E-9);
        Assertions.assertEquals((double)1.0, (double)fm.getRecallScore(), (double)1.0E-9);
        Assertions.assertEquals((int)0, (int)((Object)stream).toString().length());
    }
}

