/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import opennlp.tools.chunker.Chunker;
import opennlp.tools.chunker.ChunkerEvaluationMonitor;
import opennlp.tools.chunker.ChunkerEvaluator;
import opennlp.tools.chunker.DummyChunkSampleStream;
import opennlp.tools.chunker.DummyChunker;
import opennlp.tools.cmdline.chunker.ChunkerDetailedFMeasureListener;
import opennlp.tools.formats.ResourceAsStreamFactory;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChunkerDetailedFMeasureListenerTest {
    @Test
    void testEvaluator() throws IOException {
        ResourceAsStreamFactory inPredicted = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/chunker/output.txt");
        ResourceAsStreamFactory inExpected = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/chunker/output.txt");
        ResourceAsStreamFactory detailedOutputStream = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/chunker/detailedOutput.txt");
        DummyChunkSampleStream predictedSample = new DummyChunkSampleStream((ObjectStream<String>)new PlainTextByLineStream((InputStreamFactory)inPredicted, StandardCharsets.UTF_8), true);
        DummyChunkSampleStream expectedSample = new DummyChunkSampleStream((ObjectStream<String>)new PlainTextByLineStream((InputStreamFactory)inExpected, StandardCharsets.UTF_8), false);
        DummyChunker dummyChunker = new DummyChunker(predictedSample);
        ChunkerDetailedFMeasureListener listener = new ChunkerDetailedFMeasureListener();
        ChunkerEvaluator evaluator = new ChunkerEvaluator((Chunker)dummyChunker, new ChunkerEvaluationMonitor[]{listener});
        evaluator.evaluate((ObjectStream)expectedSample);
        StringBuilder expected = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(detailedOutputStream.createInputStream(), StandardCharsets.UTF_8));
        String line = reader.readLine();
        while (line != null) {
            expected.append(line);
            expected.append("\n");
            line = reader.readLine();
        }
        Assertions.assertEquals((Object)expected.toString().trim(), (Object)listener.createReport(Locale.ENGLISH).trim());
    }
}

