/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.DummyChunkSampleStream;
import opennlp.tools.formats.ResourceAsStreamFactory;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChunkSampleTest {
    private static String[] createSentence() {
        return new String[]{"Forecasts", "for", "the", "trade", "figures", "range", "widely", ",", "Forecasts", "for", "the", "trade", "figures", "range", "widely", "."};
    }

    private static String[] createTags() {
        return new String[]{"NNS", "IN", "DT", "NN", "NNS", "VBP", "RB", ",", "NNS", "IN", "DT", "NN", "NNS", "VBP", "RB", "."};
    }

    private static String[] createChunks() {
        return new String[]{"B-NP", "B-PP", "B-NP", "I-NP", "I-NP", "B-VP", "B-ADVP", "O", "B-NP", "B-PP", "B-NP", "I-NP", "I-NP", "B-VP", "B-ADVP", "O"};
    }

    public static ChunkSample createGoldSample() {
        return new ChunkSample(ChunkSampleTest.createSentence(), ChunkSampleTest.createTags(), ChunkSampleTest.createChunks());
    }

    public static ChunkSample createPredSample() {
        String[] chunks = ChunkSampleTest.createChunks();
        chunks[5] = "B-NP";
        return new ChunkSample(ChunkSampleTest.createSentence(), ChunkSampleTest.createTags(), chunks);
    }

    @Test
    void testChunkSampleSerDe() throws IOException {
        ChunkSample chunkSample = ChunkSampleTest.createGoldSample();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteArrayOutputStream);
        out.writeObject(chunkSample);
        out.flush();
        byte[] bytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        ObjectInputStream objectInput = new ObjectInputStream(byteArrayInputStream);
        ChunkSample deSerializedChunkSample = null;
        try {
            deSerializedChunkSample = (ChunkSample)objectInput.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Assertions.assertNotNull((Object)deSerializedChunkSample);
        Assertions.assertArrayEquals((Object[])chunkSample.getPhrasesAsSpanList(), (Object[])deSerializedChunkSample.getPhrasesAsSpanList());
        Assertions.assertArrayEquals((Object[])chunkSample.getPreds(), (Object[])deSerializedChunkSample.getPreds());
        Assertions.assertArrayEquals((Object[])chunkSample.getTags(), (Object[])deSerializedChunkSample.getTags());
        Assertions.assertArrayEquals((Object[])chunkSample.getSentence(), (Object[])deSerializedChunkSample.getSentence());
        Assertions.assertEquals((Object)chunkSample, (Object)deSerializedChunkSample);
    }

    @Test
    void testParameterValidation() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ChunkSample(new String[]{""}, new String[]{""}, new String[]{"test", "one element to much"}));
    }

    @Test
    void testRetrievingContent() {
        ChunkSample sample = new ChunkSample(ChunkSampleTest.createSentence(), ChunkSampleTest.createTags(), ChunkSampleTest.createChunks());
        Assertions.assertArrayEquals((Object[])ChunkSampleTest.createSentence(), (Object[])sample.getSentence());
        Assertions.assertArrayEquals((Object[])ChunkSampleTest.createTags(), (Object[])sample.getTags());
        Assertions.assertArrayEquals((Object[])ChunkSampleTest.createChunks(), (Object[])sample.getPreds());
    }

    @Test
    void testToString() throws IOException {
        ChunkSample sample = new ChunkSample(ChunkSampleTest.createSentence(), ChunkSampleTest.createTags(), ChunkSampleTest.createChunks());
        String[] sentence = ChunkSampleTest.createSentence();
        String[] tags = ChunkSampleTest.createTags();
        String[] chunks = ChunkSampleTest.createChunks();
        StringReader sr = new StringReader(sample.toString());
        BufferedReader reader = new BufferedReader(sr);
        for (int i = 0; i < sentence.length; ++i) {
            String line = reader.readLine();
            String[] parts = line.split("\\s+");
            Assertions.assertEquals((int)3, (int)parts.length);
            Assertions.assertEquals((Object)sentence[i], (Object)parts[0]);
            Assertions.assertEquals((Object)tags[i], (Object)parts[1]);
            Assertions.assertEquals((Object)chunks[i], (Object)parts[2]);
        }
    }

    @Test
    void testNicePrint() {
        ChunkSample sample = new ChunkSample(ChunkSampleTest.createSentence(), ChunkSampleTest.createTags(), ChunkSampleTest.createChunks());
        Assertions.assertEquals((Object)" [NP Forecasts_NNS ] [PP for_IN ] [NP the_DT trade_NN figures_NNS ] [VP range_VBP ] [ADVP widely_RB ] ,_, [NP Forecasts_NNS ] [PP for_IN ] [NP the_DT trade_NN figures_NNS ] [VP range_VBP ] [ADVP widely_RB ] ._.", (Object)sample.nicePrint());
    }

    @Test
    void testAsSpan() {
        ChunkSample sample = new ChunkSample(ChunkSampleTest.createSentence(), ChunkSampleTest.createTags(), ChunkSampleTest.createChunks());
        Span[] spans = sample.getPhrasesAsSpanList();
        Assertions.assertEquals((int)10, (int)spans.length);
        Assertions.assertEquals((Object)new Span(0, 1, "NP"), (Object)spans[0]);
        Assertions.assertEquals((Object)new Span(1, 2, "PP"), (Object)spans[1]);
        Assertions.assertEquals((Object)new Span(2, 5, "NP"), (Object)spans[2]);
        Assertions.assertEquals((Object)new Span(5, 6, "VP"), (Object)spans[3]);
        Assertions.assertEquals((Object)new Span(6, 7, "ADVP"), (Object)spans[4]);
        Assertions.assertEquals((Object)new Span(8, 9, "NP"), (Object)spans[5]);
        Assertions.assertEquals((Object)new Span(9, 10, "PP"), (Object)spans[6]);
        Assertions.assertEquals((Object)new Span(10, 13, "NP"), (Object)spans[7]);
        Assertions.assertEquals((Object)new Span(13, 14, "VP"), (Object)spans[8]);
        Assertions.assertEquals((Object)new Span(14, 15, "ADVP"), (Object)spans[9]);
    }

    @Test
    void testPhraseAsSpan() {
        Span[] spans = ChunkSample.phrasesAsSpanList((String[])ChunkSampleTest.createSentence(), (String[])ChunkSampleTest.createTags(), (String[])ChunkSampleTest.createChunks());
        Assertions.assertEquals((int)10, (int)spans.length);
        Assertions.assertEquals((Object)new Span(0, 1, "NP"), (Object)spans[0]);
        Assertions.assertEquals((Object)new Span(1, 2, "PP"), (Object)spans[1]);
        Assertions.assertEquals((Object)new Span(2, 5, "NP"), (Object)spans[2]);
        Assertions.assertEquals((Object)new Span(5, 6, "VP"), (Object)spans[3]);
        Assertions.assertEquals((Object)new Span(6, 7, "ADVP"), (Object)spans[4]);
        Assertions.assertEquals((Object)new Span(8, 9, "NP"), (Object)spans[5]);
        Assertions.assertEquals((Object)new Span(9, 10, "PP"), (Object)spans[6]);
        Assertions.assertEquals((Object)new Span(10, 13, "NP"), (Object)spans[7]);
        Assertions.assertEquals((Object)new Span(13, 14, "VP"), (Object)spans[8]);
        Assertions.assertEquals((Object)new Span(14, 15, "ADVP"), (Object)spans[9]);
    }

    @Test
    void testRegions() throws IOException {
        ResourceAsStreamFactory in = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/chunker/output.txt");
        DummyChunkSampleStream predictedSample = new DummyChunkSampleStream((ObjectStream<String>)new PlainTextByLineStream((InputStreamFactory)in, StandardCharsets.UTF_8), false);
        ChunkSample cs1 = predictedSample.read();
        String[] g1 = Span.spansToStrings((Span[])cs1.getPhrasesAsSpanList(), (String[])cs1.getSentence());
        Assertions.assertEquals((int)15, (int)g1.length);
        ChunkSample cs2 = predictedSample.read();
        String[] g2 = Span.spansToStrings((Span[])cs2.getPhrasesAsSpanList(), (String[])cs2.getSentence());
        Assertions.assertEquals((int)10, (int)g2.length);
        ChunkSample cs3 = predictedSample.read();
        String[] g3 = Span.spansToStrings((Span[])cs3.getPhrasesAsSpanList(), (String[])cs3.getSentence());
        Assertions.assertEquals((int)7, (int)g3.length);
        Assertions.assertEquals((Object)"United", (Object)g3[0]);
        Assertions.assertEquals((Object)"'s directors", (Object)g3[1]);
        Assertions.assertEquals((Object)"voted", (Object)g3[2]);
        Assertions.assertEquals((Object)"themselves", (Object)g3[3]);
        Assertions.assertEquals((Object)"their spouses", (Object)g3[4]);
        Assertions.assertEquals((Object)"lifetime access", (Object)g3[5]);
        Assertions.assertEquals((Object)"to", (Object)g3[6]);
        predictedSample.close();
    }

    @Test
    void testInvalidPhraseAsSpan1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ChunkSample.phrasesAsSpanList((String[])new String[2], (String[])new String[1], (String[])new String[1]));
    }

    @Test
    void testInvalidPhraseAsSpan2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ChunkSample.phrasesAsSpanList((String[])new String[1], (String[])new String[2], (String[])new String[1]));
    }

    @Test
    void testInvalidPhraseAsSpan3() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ChunkSample.phrasesAsSpanList((String[])new String[1], (String[])new String[1], (String[])new String[2]));
    }

    @Test
    void testInvalidChunkSampleArray() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ChunkSample(new String[1], new String[1], new String[2]));
    }

    @Test
    void testInvalidChunkSampleList() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ChunkSample(Arrays.asList(new String[1]), Arrays.asList(new String[1]), Arrays.asList(new String[2])));
    }

    @Test
    void testEquals() {
        Assertions.assertNotSame((Object)ChunkSampleTest.createGoldSample(), (Object)ChunkSampleTest.createGoldSample());
        Assertions.assertEquals((Object)ChunkSampleTest.createGoldSample(), (Object)ChunkSampleTest.createGoldSample());
        Assertions.assertNotEquals((Object)ChunkSampleTest.createPredSample(), (Object)ChunkSampleTest.createGoldSample());
        Assertions.assertNotEquals((Object)new Object(), (Object)ChunkSampleTest.createPredSample());
    }
}

