/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkSampleStream;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MockInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChunkSampleStreamTest {
    @Test
    void testReadingEvents() throws IOException {
        String sample = "word11 tag11 pred11\nword12 tag12 pred12\nword13 tag13 pred13\n\nword21 tag21 pred21\nword22 tag22 pred22\nword23 tag23 pred23\n";
        PlainTextByLineStream stringStream = new PlainTextByLineStream((InputStreamFactory)new MockInputStreamFactory(sample), StandardCharsets.UTF_8);
        ChunkSampleStream chunkStream = new ChunkSampleStream((ObjectStream)stringStream);
        ChunkSample firstSample = (ChunkSample)chunkStream.read();
        Assertions.assertEquals((Object)"word11", (Object)firstSample.getSentence()[0]);
        Assertions.assertEquals((Object)"tag11", (Object)firstSample.getTags()[0]);
        Assertions.assertEquals((Object)"pred11", (Object)firstSample.getPreds()[0]);
        Assertions.assertEquals((Object)"word12", (Object)firstSample.getSentence()[1]);
        Assertions.assertEquals((Object)"tag12", (Object)firstSample.getTags()[1]);
        Assertions.assertEquals((Object)"pred12", (Object)firstSample.getPreds()[1]);
        Assertions.assertEquals((Object)"word13", (Object)firstSample.getSentence()[2]);
        Assertions.assertEquals((Object)"tag13", (Object)firstSample.getTags()[2]);
        Assertions.assertEquals((Object)"pred13", (Object)firstSample.getPreds()[2]);
        ChunkSample secondSample = (ChunkSample)chunkStream.read();
        Assertions.assertEquals((Object)"word21", (Object)secondSample.getSentence()[0]);
        Assertions.assertEquals((Object)"tag21", (Object)secondSample.getTags()[0]);
        Assertions.assertEquals((Object)"pred21", (Object)secondSample.getPreds()[0]);
        Assertions.assertEquals((Object)"word22", (Object)secondSample.getSentence()[1]);
        Assertions.assertEquals((Object)"tag22", (Object)secondSample.getTags()[1]);
        Assertions.assertEquals((Object)"pred22", (Object)secondSample.getPreds()[1]);
        Assertions.assertEquals((Object)"word23", (Object)secondSample.getSentence()[2]);
        Assertions.assertEquals((Object)"tag23", (Object)secondSample.getTags()[2]);
        Assertions.assertEquals((Object)"pred23", (Object)secondSample.getPreds()[2]);
        Assertions.assertNull((Object)chunkStream.read());
        chunkStream.close();
    }
}

