/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools;

import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.util.Optional;
import javax.net.ssl.HttpsURLConnection;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

@Retention(value=RetentionPolicy.RUNTIME)
@ExtendWith(value={CDNAvailableCondition.class})
public @interface EnabledWhenCDNAvailable {
    public static final int TIMEOUT_MS = 2000;

    public String hostname();

    public static class CDNAvailableCondition
    implements ExecutionCondition {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
            Optional optional = AnnotationUtils.findAnnotation((Optional)context.getElement(), EnabledWhenCDNAvailable.class);
            if (!optional.isPresent()) return ConditionEvaluationResult.enabled((String)"Nothing annotated with EnabledWhenCDNAvailable.");
            EnabledWhenCDNAvailable annotation = (EnabledWhenCDNAvailable)optional.get();
            String host = annotation.hostname();
            try (Socket socket = new Socket();){
                socket.connect(new InetSocketAddress(host, 443), 2000);
                URL url = new URL("https://" + host);
                HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
                connection.setConnectTimeout(2000);
                connection.setReadTimeout(2000);
                int statusCode = connection.getResponseCode();
                if (statusCode >= 200 && statusCode < 300) {
                    ConditionEvaluationResult conditionEvaluationResult = ConditionEvaluationResult.enabled((String)("Resource (CDN) reachable with status code: " + statusCode));
                    return conditionEvaluationResult;
                }
                ConditionEvaluationResult conditionEvaluationResult = ConditionEvaluationResult.disabled((String)("Resource (CDN) reachable, but HTTP status code: " + statusCode));
                return conditionEvaluationResult;
            }
            catch (IOException e) {
                return ConditionEvaluationResult.disabled((String)"Resource (CDN) unreachable.");
            }
        }
    }
}

