/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModelLoaderTest {
    private static final Logger logger = LoggerFactory.getLogger(AbstractModelLoaderTest.class);
    private static final String BASE_URL_MODELS_V15 = System.getProperty("opennlp.model.v15.base.url", "https://opennlp.sourceforge.net/models-1.5/");
    private static final String BASE_URL_MODELS_V183 = System.getProperty("opennlp.model.v183.base.url", "https://dlcdn.apache.org/opennlp/models/langdetect/1.8.3/");
    protected static final Path OPENNLP_DIR = Paths.get(System.getProperty("OPENNLP_DOWNLOAD_HOME", System.getProperty("user.home")), new String[0]).resolve(".opennlp");
    protected static final String VER = "1.3-2.5.4";
    protected static final String BIN = ".bin";
    protected static List<String> SUPPORTED_LANG_CODES = List.of("af", "en", "fr", "de", "it", "nl", "bg", "ca", "cs", "da", "el", "es", "et", "eu", "fa", "fi", "ga", "hr", "hy", "id", "is", "ka", "kk", "ko", "lv", "no", "pl", "pt", "ro", "ru", "sk", "sl", "sr", "sv", "tr", "uk");

    protected static void downloadVersion15Model(String modelName) throws IOException {
        AbstractModelLoaderTest.downloadModel(new URL(BASE_URL_MODELS_V15 + modelName));
    }

    protected static void downloadVersion183Model(String modelName) throws IOException {
        AbstractModelLoaderTest.downloadModel(new URL(BASE_URL_MODELS_V183 + modelName));
    }

    private static void downloadModel(URL url) throws IOException {
        if (!Files.isDirectory(OPENNLP_DIR, new LinkOption[0])) {
            OPENNLP_DIR.toFile().mkdir();
        }
        String filename = url.toString().substring(url.toString().lastIndexOf("/") + 1);
        Path localFile = Paths.get(OPENNLP_DIR.toString(), filename);
        if (!Files.exists(localFile, new LinkOption[0])) {
            logger.debug("Downloading model from {} to {}.", (Object)url, (Object)localFile);
            try (BufferedInputStream in = new BufferedInputStream(url.openStream());){
                Files.copy(in, localFile, StandardCopyOption.REPLACE_EXISTING);
            }
            logger.debug("Download complete.");
        }
    }
}

