/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.xmlstore.simple;

import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;
import org.apache.openjpa.xmlstore.simple.AllFieldTypes;
import org.apache.openjpa.xmlstore.simple.Place;

public class TestPersistence
extends AbstractPersistenceTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateEntityManager() {
        OpenJPAEntityManagerFactorySPI emf = this.createNamedEMF("xmlstore-simple", new Object[0]);
        try {
            OpenJPAEntityManagerSPI em = emf.createEntityManager();
            EntityTransaction t = em.getTransaction();
            TestPersistence.assertNotNull((Object)t);
            t.begin();
            t.setRollbackOnly();
            t.rollback();
            TestPersistence.assertTrue((boolean)(em instanceof OpenJPAEntityManager));
            OpenJPAEntityManager ojem = (OpenJPAEntityManager)em;
            ojem.getFetchPlan().setMaxFetchDepth(1);
            TestPersistence.assertEquals((int)1, (int)ojem.getFetchPlan().getMaxFetchDepth());
            em.close();
        }
        finally {
            this.closeEMF((EntityManagerFactory)emf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQuery() {
        OpenJPAEntityManagerFactorySPI emf = this.createNamedEMF("xmlstore-simple", CLEAR_TABLES, AllFieldTypes.class);
        try {
            OpenJPAEntityManagerSPI em = emf.createEntityManager();
            em.getTransaction().begin();
            AllFieldTypes aft = new AllFieldTypes();
            aft.setStringField("foo");
            aft.setIntField(10);
            em.persist((Object)aft);
            em.getTransaction().commit();
            em.close();
            em = emf.createEntityManager();
            em.getTransaction().begin();
            TestPersistence.assertEquals((int)1, (int)em.createQuery("select x from AllFieldTypes x where x.stringField = 'foo'").getResultList().size());
            TestPersistence.assertEquals((int)0, (int)em.createQuery("select x from AllFieldTypes x where x.stringField = 'bar'").getResultList().size());
            TestPersistence.assertEquals((int)1, (int)em.createQuery("select x from AllFieldTypes x where x.intField >= 10").getResultList().size());
            em.getTransaction().rollback();
            em.close();
        }
        finally {
            this.closeEMF((EntityManagerFactory)emf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNewDeleteNew() {
        OpenJPAEntityManagerFactorySPI emf = this.createNamedEMF("xmlstore-simple", CLEAR_TABLES, Place.class);
        try {
            OpenJPAEntityManagerSPI em = emf.createEntityManager();
            Place place = new Place();
            place.setLocation("Lexington");
            TestPersistence.assertFalse((boolean)em.contains((Object)place));
            em.getTransaction().begin();
            em.persist((Object)place);
            em.getTransaction().commit();
            TestPersistence.assertTrue((boolean)em.contains((Object)place));
            place = (Place)em.find(Place.class, (Object)"Lexington");
            TestPersistence.assertNotNull((Object)place);
            TestPersistence.assertEquals((String)"Lexington", (String)place.getLocation());
            em.getTransaction().begin();
            em.remove((Object)place);
            em.getTransaction().commit();
            TestPersistence.assertFalse((boolean)em.contains((Object)place));
            place = new Place();
            place.setLocation("Lexington");
            TestPersistence.assertFalse((boolean)em.contains((Object)place));
            em.getTransaction().begin();
            em.persist((Object)place);
            em.getTransaction().commit();
            TestPersistence.assertTrue((boolean)em.contains((Object)place));
            place = (Place)em.find(Place.class, (Object)"Lexington");
            TestPersistence.assertNotNull((Object)place);
            TestPersistence.assertEquals((String)"Lexington", (String)place.getLocation());
            em.close();
        }
        finally {
            this.closeEMF((EntityManagerFactory)emf);
        }
    }
}

