/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.openjpa.jdbc.sql.SybaseDictionary;
import org.apache.openjpa.lib.jdbc.AbstractJDBCListener;
import org.apache.openjpa.lib.jdbc.JDBCEvent;

public class FilteringJDBCListener
extends AbstractJDBCListener {
    private Set<String> _ignoredSQL = new HashSet<String>();
    private List<String> _sqlStatements;

    public FilteringJDBCListener(List<String> sql) {
        this._sqlStatements = sql;
        this._ignoredSQL.add(SybaseDictionary.NUMERIC_TRUNCATION_OFF_SQL);
        this._ignoredSQL.add(SybaseDictionary.RIGHT_TRUNCATION_ON_SQL);
    }

    public void beforeExecuteStatement(JDBCEvent event) {
        String sql = event.getSQL();
        if (sql != null && this._sqlStatements != null && !this._ignoredSQL.contains(sql)) {
            this._sqlStatements.add(sql);
        }
    }

    public void clear() {
        this._sqlStatements.clear();
    }

    public List<String> getCopy() {
        return new ArrayList<String>(this._sqlStatements);
    }
}

