/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.apache.openjpa.persistence.test.CombinationGenerator;

public class CombinatorialTestHelper {
    private CombinationGenerator geneartor;
    private List<String> propertyKeys;
    private List currentOption = null;
    private BitSet runtimeKeys = new BitSet();
    private List[] combos = null;
    private int cursor = 0;

    public CombinatorialTestHelper() {
        this.geneartor = new CombinationGenerator();
        this.propertyKeys = new ArrayList<String>();
        this.runtimeKeys = new BitSet();
    }

    Object[] setCombinatorialOption(Object[] props) {
        if (this.propertyKeys.isEmpty() || this.propertyKeys.size() == this.runtimeKeys.cardinality()) {
            return props;
        }
        if (this.combos == null) {
            this.combos = this.geneartor.generate();
            this.cursor = 0;
        }
        Object[] options = new Object[2 * (this.propertyKeys.size() - this.runtimeKeys.cardinality())];
        this.currentOption = this.combos[this.cursor++];
        int k = 0;
        for (int i = 0; i < this.propertyKeys.size(); ++i) {
            if (this.runtimeKeys.get(i)) continue;
            options[k++] = this.propertyKeys.get(i);
            options[k++] = this.currentOption.get(i);
        }
        if (props == null || props.length == 0) {
            return options;
        }
        Object[] newProps = new Object[props.length + options.length];
        System.arraycopy(props, 0, newProps, 0, props.length);
        System.arraycopy(options, 0, newProps, props.length, options.length);
        return newProps;
    }

    public void addOption(String property, Object[] options) {
        this.addOption(property, options, false);
    }

    public void addOption(String property, List options) {
        this.addOption(property, options, false);
    }

    public void addOption(String property, Object[] options, boolean runtime) {
        this.addOption(property, Arrays.asList(options), runtime);
    }

    public void addOption(String property, List options, boolean runtime) {
        if (this.geneartor == null) {
            this.geneartor = new CombinationGenerator();
        }
        if (this.propertyKeys == null) {
            this.propertyKeys = new ArrayList<String>();
        }
        if (!this.propertyKeys.contains(property)) {
            this.geneartor.addDimension(options);
            this.propertyKeys.add(property);
            if (runtime) {
                this.runtimeKeys.set(this.propertyKeys.size() - 1);
            }
        }
    }

    public Object getOption(String key) {
        int index = this.propertyKeys.indexOf(key);
        if (index == -1) {
            throw new IllegalArgumentException("Unknown option " + key);
        }
        return this.currentOption.get(index);
    }

    public String getOptionAsString(String key) {
        return this.getOption(key).toString();
    }

    public List getOptions() {
        return this.currentOption;
    }

    public String getOptionsAsString() {
        String key;
        int i;
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < this.propertyKeys.size(); ++i) {
            key = this.propertyKeys.get(i);
            if (this.runtimeKeys.get(i)) continue;
            buf.append(key + " : " + this.getOption(key)).append("\r\n");
        }
        for (i = 0; i < this.propertyKeys.size(); ++i) {
            key = this.propertyKeys.get(i);
            if (!this.runtimeKeys.get(i)) continue;
            buf.append("* " + key + " : " + this.getOption(key)).append("\r\n");
        }
        return buf.toString();
    }

    public boolean hasMoreCombination() {
        return this.cursor < this.combos.length;
    }

    public int getCombinationSize() {
        return this.geneartor == null ? 0 : this.geneartor.getSize();
    }
}

