/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.util.ArrayList;
import java.util.Map;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.PluralJoin;
import javax.persistence.criteria.SetJoin;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.Type;
import org.apache.openjpa.kernel.exps.AbstractExpressionBuilder;
import org.apache.openjpa.kernel.exps.Expression;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.Subquery;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.criteria.AliasContext;
import org.apache.openjpa.persistence.criteria.CriteriaQueryImpl;
import org.apache.openjpa.persistence.criteria.ExpressionImpl;
import org.apache.openjpa.persistence.criteria.Expressions;
import org.apache.openjpa.persistence.criteria.FromImpl;
import org.apache.openjpa.persistence.criteria.PathImpl;
import org.apache.openjpa.persistence.criteria.RootImpl;
import org.apache.openjpa.persistence.criteria.SubqueryImpl;
import org.apache.openjpa.persistence.meta.AbstractManagedType;
import org.apache.openjpa.persistence.meta.Members;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Joins {
    Joins() {
    }

    static Join clone(Join join) {
        ArrayList<Members.Member> members = new ArrayList<Members.Member>();
        ArrayList<JoinType> jts = new ArrayList<JoinType>();
        FromImpl root = Joins.getMembers((PathImpl)join, members, jts);
        Members.Member member = (Members.Member)members.get(0);
        JoinType jt = (JoinType)jts.get(0);
        Join<?, ?> join1 = Joins.makeJoin(root, member, jt);
        for (int i = 1; i < members.size(); ++i) {
            join1 = Joins.makeJoin((FromImpl)join1, (Members.Member)members.get(i), (JoinType)jts.get(i));
        }
        return join1;
    }

    static Join<?, ?> makeJoin(FromImpl<?, ?> from, Members.Member member, JoinType jt) {
        if (member instanceof Members.SingularAttributeImpl) {
            return new SingularJoin(from, (Members.SingularAttributeImpl)member, jt);
        }
        if (member instanceof Members.CollectionAttributeImpl) {
            return new Collection(from, (Members.CollectionAttributeImpl)member, jt);
        }
        if (member instanceof Members.ListAttributeImpl) {
            return new List(from, (Members.ListAttributeImpl)member, jt);
        }
        if (member instanceof Members.SetAttributeImpl) {
            return new Set(from, (Members.SetAttributeImpl)member, jt);
        }
        if (member instanceof Members.MapAttributeImpl) {
            return new Map(from, (Members.MapAttributeImpl)member, jt);
        }
        return null;
    }

    static FromImpl getMembers(PathImpl join, java.util.List<Members.Member> members, java.util.List<JoinType> jts) {
        PathImpl parent = (PathImpl)join.getParentPath();
        Members.Member member = join.getMember();
        JoinType jt = ((Join)join).getJoinType();
        FromImpl from = null;
        if (parent instanceof RootImpl) {
            members.add(member);
            jts.add(jt);
            return (FromImpl)parent;
        }
        from = Joins.getMembers(parent, members, jts);
        members.add(member);
        jts.add(jt);
        return from;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KeyJoin<K, V>
    extends Set<java.util.Map<K, V>, K> {
        public KeyJoin(FromImpl<?, java.util.Map<K, V>> parent, Members.KeyAttributeImpl<? super java.util.Map<K, V>, K> member, JoinType jt) {
            super(parent, member, jt);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> c) {
            return factory.getKey(this.getParent().toValue(factory, c));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapEntry<K, V>
    extends ExpressionImpl<Map.Entry<K, V>> {
        private final Map<?, K, V> map;

        public MapEntry(Map<?, K, V> joinMap) {
            super(((MapAttribute)joinMap.getAttribute()).getJavaType());
            this.map = joinMap;
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> c) {
            Value val = c.getRegisteredVariable(this.map);
            org.apache.openjpa.kernel.exps.Path path = factory.newPath(val);
            org.apache.openjpa.kernel.exps.Path var = factory.newPath(val);
            return factory.mapEntry((Value)path, (Value)var);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            StringBuilder buffer = new StringBuilder("ENTRY(");
            Value var = q.getRegisteredVariable(this.map);
            buffer.append(var != null ? var.getName() : this.map.asValue(q)).append(")");
            return buffer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapKey<Z, K>
    extends PathImpl<Z, K> {
        private final Map<?, K, ?> map;
        private final Members.MapAttributeImpl<Z, K, ?> attr;

        public MapKey(Map<Z, K, ?> joinMap) {
            super(((MapAttribute)joinMap.getAttribute()).getKeyJavaType());
            this.attr = (Members.MapAttributeImpl)joinMap.getAttribute();
            this.map = joinMap;
        }

        @Override
        public Type<?> getType() {
            return this.attr.getKeyType();
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> c) {
            Value val = c.getRegisteredVariable(this.map);
            org.apache.openjpa.kernel.exps.Path path = factory.newPath(val);
            return factory.getKey((Value)path);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            StringBuilder buffer = new StringBuilder("KEY(");
            Value var = q.getRegisteredVariable(this.map);
            buffer.append(var != null ? var.getName() : this.map.asValue(q)).append(")");
            return buffer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Map<Z, K, V>
    extends AbstractCollection<Z, java.util.Map<K, V>, V>
    implements MapJoin<Z, K, V> {
        private KeyJoin<K, V> _keyJoin;

        public Map(FromImpl<?, Z> parent, Members.MapAttributeImpl<? super Z, K, V> member, JoinType jt) {
            super(parent, member, jt);
        }

        @Override
        public MapAttribute<? super Z, K, V> getModel() {
            return (MapAttribute)this._member;
        }

        public Join<java.util.Map<K, V>, K> joinKey() {
            return this.joinKey(JoinType.INNER);
        }

        public Join<java.util.Map<K, V>, K> joinKey(JoinType jt) {
            AbstractManagedType pseudoOwner = (AbstractManagedType)this._member.owner.model.getType(this.getModel().getJavaType());
            Members.KeyAttributeImpl keyAttr = new Members.KeyAttributeImpl(pseudoOwner, this._member.fmd);
            this._keyJoin = new KeyJoin(this, keyAttr, jt);
            return this._keyJoin;
        }

        public javax.persistence.criteria.Expression<Map.Entry<K, V>> entry() {
            return new MapEntry(this);
        }

        public Path<K> key() {
            return new MapKey(this);
        }

        public Path<V> value() {
            return this;
        }

        @Override
        public Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> c) {
            return this._keyJoin == null ? super.toKernelExpression(factory, c) : this._keyJoin.toKernelExpression(factory, c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class List<Z, E>
    extends AbstractCollection<Z, java.util.List<E>, E>
    implements ListJoin<Z, E> {
        public List(FromImpl<?, Z> parent, Members.ListAttributeImpl<? super Z, E> member, JoinType jt) {
            super(parent, member, jt);
        }

        public ListAttribute<? super Z, E> getModel() {
            return (ListAttribute)this._member;
        }

        public javax.persistence.criteria.Expression<Integer> index() {
            return new Expressions.Index(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Set<Z, E>
    extends AbstractCollection<Z, java.util.Set<E>, E>
    implements SetJoin<Z, E> {
        public Set(FromImpl<?, Z> parent, Members.SetAttributeImpl<? super Z, E> member, JoinType jt) {
            super(parent, member, jt);
        }

        public SetAttribute<? super Z, E> getModel() {
            return (SetAttribute)this._member;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Collection<Z, E>
    extends AbstractCollection<Z, java.util.Collection<E>, E>
    implements CollectionJoin<Z, E> {
        public Collection(FromImpl<?, Z> parent, Members.CollectionAttributeImpl<? super Z, E> member, JoinType jt) {
            super(parent, member, jt);
        }

        public CollectionAttribute<? super Z, E> getModel() {
            return (CollectionAttribute)this._member;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractCollection<Z, C, E>
    extends FromImpl<Z, E>
    implements PluralJoin<Z, C, E> {
        private final JoinType joinType;
        private boolean allowNull = false;

        public AbstractCollection(FromImpl<?, Z> from, Members.PluralAttributeImpl<? super Z, C, E> member, JoinType jt) {
            super(from, member, member.getBindableJavaType());
            this.joinType = jt;
            this.allowNull = this.joinType != JoinType.INNER;
        }

        public final JoinType getJoinType() {
            return this.joinType;
        }

        public final FromImpl<?, Z> getParent() {
            return (FromImpl)this._parent;
        }

        public Attribute<? super Z, E> getAttribute() {
            return this._member;
        }

        public PluralAttribute<? super Z, C, E> getModel() {
            return (PluralAttribute)this._member.getType();
        }

        public ClassMetaData getMemberClassMetaData() {
            return this._member.fmd.isElementCollection() ? this._member.fmd.getElement().getEmbeddedMetaData() : this._member.fmd.getElement().getDeclaredTypeMetaData();
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> c) {
            org.apache.openjpa.kernel.exps.Path path = null;
            SubqueryImpl<?> subquery = c.getDelegator();
            PathImpl<?, ?> parent = this.getInnermostParentPath();
            Value var = c.getRegisteredVariable(this);
            if (var != null) {
                path = factory.newPath(var);
            } else if (parent.inSubquery(subquery)) {
                Subquery subQ = subquery.getSubQ();
                path = factory.newPath((Value)subQ);
                path.setMetaData(subQ.getMetaData());
                path.setSchemaAlias(c.getAlias(this));
            } else {
                path = (org.apache.openjpa.kernel.exps.Path)this._parent.toValue(factory, c);
                path.get(this._member.fmd, this.allowNull);
            }
            return path;
        }

        @Override
        public Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> c) {
            ClassMetaData meta = this.getMemberClassMetaData();
            org.apache.openjpa.kernel.exps.Path path = null;
            SubqueryImpl<?> subquery = c.getDelegator();
            Expression filter = null;
            java.util.Set<Join<?, ?>> corrJoins = null;
            boolean bind = true;
            Expression join = null;
            PathImpl<?, ?> corrJoin = this.getCorrelatedJoin(this);
            PathImpl<?, ?> corrRoot = this.getCorrelatedRoot(subquery);
            PathImpl<?, ?> correlatedParentPath = null;
            if (!this.isCorrelated()) {
                Class type;
                Value var;
                if (subquery != null) {
                    corrJoins = subquery.getCorrelatedJoins();
                    Subquery subQ = subquery.getSubQ();
                    path = factory.newPath((Value)subQ);
                    if ((corrJoin != null || corrRoot != null) && this._parent.getCorrelatedPath() != null) {
                        subQ.setSubqAlias(c.getAlias(this));
                        path = factory.newPath((Value)subQ);
                        correlatedParentPath = this._parent.getCorrelatedPath();
                        bind = false;
                    } else {
                        if (c.isRegistered(this._parent)) {
                            var = c.getRegisteredVariable(this._parent);
                            path = factory.newPath(var);
                        } else {
                            path = factory.newPath((Value)subQ);
                        }
                        path.setMetaData(meta);
                        path.get(this._member.fmd, false);
                        path.setSchemaAlias(c.getAlias(this._parent));
                    }
                } else if (c.isRegistered(this._parent)) {
                    Value var2 = c.getRegisteredVariable(this._parent);
                    path = factory.newPath(var2);
                    path.setMetaData(meta);
                    path.get(this._member.fmd, false);
                } else {
                    path = (org.apache.openjpa.kernel.exps.Path)this.toValue(factory, c);
                }
                Class clazz = type = meta == null ? AbstractExpressionBuilder.TYPE_OBJECT : meta.getDescribedType();
                if (bind) {
                    var = factory.newBoundVariable(c.getAlias(this), type);
                    join = factory.bindVariable(var, (Value)path);
                    c.registerVariable(this, var, (Value)path);
                }
            }
            if (this.getJoins() != null) {
                for (Join join1 : this.getJoins()) {
                    filter = Expressions.and(factory, ((FromImpl)join1).toKernelExpression(factory, c), filter);
                }
            }
            Expression expr = Expressions.and(factory, join, filter);
            if (correlatedParentPath == null) {
                return expr;
            }
            org.apache.openjpa.kernel.exps.Path parentPath = null;
            if (!corrJoins.isEmpty() && corrJoins.contains(this._parent)) {
                Value var = this.getVariableForCorrPath(subquery, correlatedParentPath);
                parentPath = factory.newPath(var);
            } else {
                parentPath = (org.apache.openjpa.kernel.exps.Path)correlatedParentPath.toValue(factory, c);
            }
            parentPath.get(this._member.fmd, this.allowNull);
            parentPath.setSchemaAlias(c.getAlias(correlatedParentPath));
            if (c.ctx().getParent() != null && c.ctx().getVariable(parentPath.getSchemaAlias()) == null) {
                parentPath.setSubqueryContext(c.ctx(), parentPath.getSchemaAlias());
            }
            path.setSchemaAlias(c.getAlias(correlatedParentPath));
            path.setMetaData(meta);
            Class type = meta == null ? AbstractExpressionBuilder.TYPE_OBJECT : meta.getDescribedType();
            Value var = factory.newBoundVariable(c.getAlias(this), type);
            join = factory.bindVariable(var, (Value)parentPath);
            if (this._member.fmd.getDeclaredTypeCode() == 13) {
                c.registerVariable(this, var, (Value)parentPath);
            }
            filter = this._member.fmd.isElementCollection() ? Expressions.and(factory, join, filter) : factory.equal((Value)parentPath, (Value)path);
            return Expressions.and(factory, expr, filter);
        }

        private Value getVariableForCorrPath(SubqueryImpl<?> subquery, PathImpl<?, ?> path) {
            AbstractQuery<?> parent = subquery.getParent();
            if (parent instanceof CriteriaQueryImpl) {
                return ((CriteriaQueryImpl)parent).getRegisteredVariable(path);
            }
            Value var = ((SubqueryImpl)parent).getDelegate().getRegisteredVariable(path);
            if (var != null) {
                return var;
            }
            return this.getVariableForCorrPath((SubqueryImpl)parent, path);
        }

        @Override
        public StringBuilder asVariable(AliasContext q) {
            return new StringBuilder(" " + this.joinType + " JOIN ").append((CharSequence)super.asVariable(q));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SingularJoin<Z, X>
    extends FromImpl<Z, X>
    implements Join<Z, X> {
        private final JoinType joinType;
        private boolean allowNull = false;

        public SingularJoin(FromImpl<?, Z> from, Members.SingularAttributeImpl<? super Z, X> member, JoinType jt) {
            super(from, member, member.getJavaType());
            this.joinType = jt;
            this.allowNull = this.joinType != JoinType.INNER;
        }

        public JoinType getJoinType() {
            return this.joinType;
        }

        public FromImpl<?, Z> getParent() {
            return (FromImpl)this._parent;
        }

        @Override
        public Members.Member<? extends Z, X> getMember() {
            return this._member;
        }

        public Attribute<? super Z, ?> getAttribute() {
            return this._member;
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> c) {
            ClassMetaData meta = this._member.fmd.getDeclaredTypeMetaData();
            org.apache.openjpa.kernel.exps.Path path = null;
            SubqueryImpl<?> subquery = c.getDelegator();
            PathImpl<?, ?> parent = this.getInnermostParentPath();
            Value val = c.getRegisteredValue(this);
            if (val != null) {
                return val;
            }
            if (parent.inSubquery(subquery)) {
                Subquery subQ = subquery.getSubQ();
                path = factory.newPath((Value)subQ);
                path.setMetaData(subQ.getMetaData());
                path.setSchemaAlias(c.getAlias(this));
                path.get(this._member.fmd, this.allowNull);
            } else {
                path = (org.apache.openjpa.kernel.exps.Path)this._parent.toValue(factory, c);
                path.get(this._member.fmd, this.allowNull);
                path.setMetaData(meta);
                path.setImplicitType(meta.getDescribedType());
            }
            return path;
        }

        @Override
        public Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> c) {
            ClassMetaData meta = this._member.fmd.getDeclaredTypeMetaData();
            org.apache.openjpa.kernel.exps.Path path = null;
            SubqueryImpl<?> subquery = c.getDelegator();
            PathImpl<?, ?> parent = this.getInnermostParentPath();
            Expression filter = null;
            PathImpl<?, ?> correlatedParentPath = null;
            boolean bind = true;
            java.util.Set<Join<?, ?>> corrJoins = null;
            Expression join = null;
            if (!this.isCorrelated()) {
                Value var;
                if (subquery != null) {
                    corrJoins = subquery.getCorrelatedJoins();
                    Subquery subQ = subquery.getSubQ();
                    if (!corrJoins.isEmpty() && corrJoins.contains(this._parent) || corrJoins.isEmpty() && parent.inSubquery(subquery) && this._parent.getCorrelatedPath() != null) {
                        path = factory.newPath((Value)subQ);
                        correlatedParentPath = this._parent.getCorrelatedPath();
                        bind = false;
                    } else {
                        if (c.isRegistered(this._parent)) {
                            var = c.getRegisteredVariable(this._parent);
                            path = factory.newPath(var);
                        } else {
                            path = factory.newPath((Value)subQ);
                        }
                        path.setMetaData(meta);
                        path.get(this._member.fmd, false);
                        path.setSchemaAlias(c.getAlias(this._parent));
                    }
                } else if (c.isRegistered(this._parent)) {
                    Value var2 = c.getRegisteredVariable(this._parent);
                    path = factory.newPath(var2);
                    path.setMetaData(meta);
                    path.get(this._member.fmd, false);
                } else {
                    path = (org.apache.openjpa.kernel.exps.Path)this.toValue(factory, c);
                }
                Class type = meta == null ? AbstractExpressionBuilder.TYPE_OBJECT : meta.getDescribedType();
                var = null;
                if (bind) {
                    var = factory.newBoundVariable(c.getAlias(this), type);
                    join = factory.bindVariable(var, (Value)path);
                    c.registerVariable(this, var, (Value)path);
                }
                if (!this._member.fmd.isTypePC()) {
                    this.setImplicitContainsTypes((Value)path, var, 1);
                    join = factory.contains((Value)path, var);
                }
            }
            if (this.getJoins() != null) {
                for (Join join1 : this.getJoins()) {
                    filter = Expressions.and(factory, ((FromImpl)join1).toKernelExpression(factory, c), filter);
                }
            }
            Expression expr = Expressions.and(factory, join, filter);
            if (correlatedParentPath == null) {
                return expr;
            }
            org.apache.openjpa.kernel.exps.Path parentPath = null;
            if (corrJoins != null && corrJoins.contains(this._parent)) {
                Value var = this.getVariableForCorrPath(subquery, correlatedParentPath);
                parentPath = factory.newPath(var);
            } else {
                parentPath = (org.apache.openjpa.kernel.exps.Path)correlatedParentPath.toValue(factory, c);
            }
            parentPath.get(this._member.fmd, this.allowNull);
            parentPath.setSchemaAlias(c.getAlias(correlatedParentPath));
            if (c.ctx().getParent() != null && c.ctx().getVariable(parentPath.getSchemaAlias()) == null) {
                parentPath.setSubqueryContext(c.ctx(), parentPath.getSchemaAlias());
            }
            path.setMetaData(meta);
            filter = factory.equal((Value)parentPath, (Value)path);
            return Expressions.and(factory, expr, filter);
        }

        private Value getVariableForCorrPath(SubqueryImpl<?> subquery, PathImpl<?, ?> path) {
            AbstractQuery<?> parent = subquery.getParent();
            if (parent instanceof CriteriaQueryImpl) {
                return ((CriteriaQueryImpl)parent).getRegisteredVariable(path);
            }
            Value var = ((SubqueryImpl)parent).getDelegate().getRegisteredVariable(path);
            if (var != null) {
                return var;
            }
            return this.getVariableForCorrPath((SubqueryImpl)parent, path);
        }

        public void setImplicitContainsTypes(Value val1, Value val2, int op) {
            FieldMetaData fmd;
            if (val1.getType() == AbstractExpressionBuilder.TYPE_OBJECT) {
                if (op == 1) {
                    val1.setImplicitType(Collection.class);
                } else {
                    val1.setImplicitType(Map.class);
                }
            }
            if (val2.getType() == AbstractExpressionBuilder.TYPE_OBJECT && val1 instanceof Path && (fmd = ((org.apache.openjpa.kernel.exps.Path)val1).last()) != null) {
                if (op == 1 || op == 3) {
                    val2.setImplicitType(fmd.getElement().getDeclaredType());
                    ClassMetaData meta = fmd.getElement().getDeclaredTypeMetaData();
                    if (meta != null) {
                        val2.setMetaData(meta);
                    }
                } else {
                    val2.setImplicitType(fmd.getKey().getDeclaredType());
                    ClassMetaData meta = fmd.getKey().getDeclaredTypeMetaData();
                    if (meta != null) {
                        val2.setMetaData(meta);
                    }
                }
            }
        }

        @Override
        public StringBuilder asVariable(AliasContext q) {
            return new StringBuilder(" " + this.joinType + " JOIN ").append((CharSequence)super.asVariable(q));
        }
    }
}

