/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import org.apache.openjpa.datacache.CacheStatistics;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.datacache.DelegatingDataCache;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.EntityManagerFactoryImpl;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.persistence.StoreCache;

public class StoreCacheImpl
implements StoreCache {
    private final MetaDataRepository _repos;
    private final DelegatingDataCache _cache;

    public StoreCacheImpl(EntityManagerFactoryImpl emf, DataCache cache) {
        this._repos = emf.getConfiguration().getMetaDataRepositoryInstance();
        this._cache = new DelegatingDataCache(cache, PersistenceExceptions.TRANSLATOR);
    }

    public DataCache getDelegate() {
        return this._cache.getDelegate();
    }

    public boolean contains(Class cls, Object oid) {
        return this._cache.getDelegate() != null && this._cache.contains(JPAFacadeHelper.toOpenJPAObjectId(this.getMetaData(cls), oid));
    }

    public boolean containsAll(Class cls, Object ... oids) {
        return this.containsAll(cls, Arrays.asList(oids));
    }

    public boolean containsAll(Class cls, Collection oids) {
        if (this._cache.getDelegate() == null) {
            return oids.isEmpty();
        }
        BitSet set = this._cache.containsAll(JPAFacadeHelper.toOpenJPAObjectIds(this.getMetaData(cls), oids));
        for (int i = 0; i < oids.size(); ++i) {
            if (set.get(i)) continue;
            return false;
        }
        return true;
    }

    public void pin(Class cls, Object oid) {
        if (this._cache.getDelegate() != null) {
            this._cache.pin(JPAFacadeHelper.toOpenJPAObjectId(this.getMetaData(cls), oid));
        }
    }

    public void pinAll(Class cls, Object ... oids) {
        this.pinAll(cls, Arrays.asList(oids));
    }

    public void pinAll(Class cls, Collection oids) {
        if (this._cache.getDelegate() != null) {
            this._cache.pinAll(JPAFacadeHelper.toOpenJPAObjectIds(this.getMetaData(cls), oids));
        }
    }

    public void unpin(Class cls, Object oid) {
        if (this._cache.getDelegate() != null) {
            this._cache.unpin(JPAFacadeHelper.toOpenJPAObjectId(this.getMetaData(cls), oid));
        }
    }

    public void unpinAll(Class cls, Object ... oids) {
        this.unpinAll(cls, Arrays.asList(oids));
    }

    public void unpinAll(Class cls, Collection oids) {
        if (this._cache.getDelegate() != null) {
            this._cache.unpinAll(JPAFacadeHelper.toOpenJPAObjectIds(this.getMetaData(cls), oids));
        }
    }

    public void evict(Class cls, Object oid) {
        if (this._cache.getDelegate() != null) {
            this._cache.remove(JPAFacadeHelper.toOpenJPAObjectId(this.getMetaData(cls), oid));
        }
    }

    public void evictAll(Class cls, Object ... oids) {
        this.evictAll(cls, Arrays.asList(oids));
    }

    public void evictAll(Class cls, Collection oids) {
        if (this._cache.getDelegate() != null) {
            this._cache.removeAll(JPAFacadeHelper.toOpenJPAObjectIds(this.getMetaData(cls), oids));
        }
    }

    public void evictAll() {
        this._cache.clear();
    }

    public CacheStatistics getStatistics() {
        return this._cache == null ? null : this._cache.getStatistics();
    }

    private ClassMetaData getMetaData(Class cls) {
        try {
            return this._repos.getMetaData(cls, null, true);
        }
        catch (RuntimeException re) {
            throw PersistenceExceptions.toPersistenceException(re);
        }
    }

    public int hashCode() {
        return this._cache.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof StoreCacheImpl)) {
            return false;
        }
        return this._cache.equals((Object)((StoreCacheImpl)other)._cache);
    }

    public void evict(Class cls) {
        if (this.getMetaData(cls) != null) {
            this._cache.removeAll(cls, true);
        }
    }
}

