/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.util.Collections;
import javax.persistence.Query;
import org.apache.openjpa.datacache.DelegatingQueryCache;
import org.apache.openjpa.datacache.QueryCache;
import org.apache.openjpa.datacache.QueryKey;
import org.apache.openjpa.datacache.TypesChangedEvent;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.persistence.QueryResultCache;

public class QueryResultCacheImpl
implements QueryResultCache {
    private final DelegatingQueryCache _cache;

    public QueryResultCacheImpl(QueryCache cache) {
        this._cache = new DelegatingQueryCache(cache, PersistenceExceptions.TRANSLATOR);
    }

    public QueryCache getDelegate() {
        return this._cache.getDelegate();
    }

    public void pin(Query q) {
        if (this._cache.getDelegate() != null) {
            this._cache.pin(this.toQueryKey(q));
        }
    }

    public void unpin(Query q) {
        if (this._cache.getDelegate() != null) {
            this._cache.unpin(this.toQueryKey(q));
        }
    }

    public void evict(Query q) {
        if (this._cache.getDelegate() != null) {
            this._cache.remove(this.toQueryKey(q));
        }
    }

    public void evictAll() {
        this._cache.clear();
    }

    public void evictAll(Class cls) {
        this._cache.onTypesChanged(new TypesChangedEvent((Object)this, Collections.singleton(cls)));
    }

    private QueryKey toQueryKey(Query q) {
        QueryImpl impl = (QueryImpl)q;
        if (impl.hasPositionalParameters()) {
            return QueryKey.newInstance((org.apache.openjpa.kernel.Query)impl.getDelegate(), (Object[])impl.getPositionalParameters());
        }
        return QueryKey.newInstance((org.apache.openjpa.kernel.Query)impl.getDelegate(), impl.getNamedParameters());
    }

    public int hashCode() {
        return this._cache.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof QueryResultCacheImpl)) {
            return false;
        }
        return this._cache.equals((Object)((QueryResultCacheImpl)other)._cache);
    }
}

