/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.enhance.PCClassFileTransformer;
import org.apache.openjpa.enhance.PCEnhancerAgent;
import org.apache.openjpa.kernel.AbstractBrokerFactory;
import org.apache.openjpa.kernel.Bootstrap;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistenceUtil;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.persistence.PersistenceProductDerivation;
import org.apache.openjpa.persistence.osgi.BundleUtils;
import org.apache.openjpa.persistence.validation.ValidationUtils;
import org.apache.openjpa.util.ClassResolver;

public class PersistenceProviderImpl
implements PersistenceProvider,
ProviderUtil {
    static final String CLASS_TRANSFORMER_OPTIONS = "ClassTransformerOptions";
    private static final String EMF_POOL = "EntityManagerFactoryPool";
    private static final Localizer _loc = Localizer.forPackage(PersistenceProviderImpl.class);
    private Log _log;

    public OpenJPAEntityManagerFactory createEntityManagerFactory(String name, String resource, Map m) {
        PersistenceProductDerivation pd = new PersistenceProductDerivation();
        try {
            Object poolValue = Configurations.removeProperty((String)EMF_POOL, (Map)m);
            ConfigurationProvider cp = pd.load(resource, name, m);
            if (cp == null) {
                return null;
            }
            BrokerFactory factory = this.getBrokerFactory(cp, poolValue, null);
            OpenJPAConfiguration conf = factory.getConfiguration();
            this._log = conf.getLog("openjpa.Runtime");
            pd.checkPuNameCollisions(this._log, name);
            this.loadAgent(factory);
            this.loadValidator(factory);
            this.preloadMetaDataRepository(factory);
            return JPAFacadeHelper.toEntityManagerFactory(factory);
        }
        catch (Exception e) {
            if (this._log != null) {
                this._log.error((Object)_loc.get("create-emf-error", (Object)name), (Throwable)e);
            }
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    private BrokerFactory getBrokerFactory(ConfigurationProvider cp, Object poolValue, ClassLoader loader) {
        if (poolValue instanceof String && ("true".equalsIgnoreCase((String)poolValue) || "false".equalsIgnoreCase((String)poolValue))) {
            poolValue = Boolean.valueOf((String)poolValue);
        }
        if (poolValue != null && !(poolValue instanceof Boolean)) {
            throw new IllegalArgumentException(poolValue.toString());
        }
        if (poolValue == null || !((Boolean)poolValue).booleanValue()) {
            return Bootstrap.newBrokerFactory((ConfigurationProvider)cp, (ClassLoader)loader);
        }
        return Bootstrap.getBrokerFactory((ConfigurationProvider)cp, (ClassLoader)loader);
    }

    public OpenJPAEntityManagerFactory createEntityManagerFactory(String name, Map m) {
        return this.createEntityManagerFactory(name, null, m);
    }

    public OpenJPAEntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo pui, Map m) {
        PersistenceProductDerivation pd = new PersistenceProductDerivation();
        try {
            Object poolValue = Configurations.removeProperty((String)EMF_POOL, (Map)m);
            ConfigurationProvider cp = pd.load(pui, m);
            if (cp == null) {
                return null;
            }
            Exception transformerException = null;
            String ctOpts = (String)Configurations.getProperty((String)CLASS_TRANSFORMER_OPTIONS, (Map)pui.getProperties());
            try {
                pui.addTransformer((ClassTransformer)new ClassTransformerImpl(cp, ctOpts, pui.getNewTempClassLoader(), this.newConfigurationImpl()));
            }
            catch (Exception e) {
                transformerException = e;
            }
            if (!Configurations.containsProperty((String)"BrokerImpl", (Map)cp.getProperties())) {
                cp.addProperty("openjpa.BrokerImpl", (Object)this.getDefaultBrokerAlias());
            }
            BrokerFactory factory = BundleUtils.runningUnderOSGi() ? this.getBrokerFactory(cp, poolValue, BundleUtils.getBundleClassLoader()) : this.getBrokerFactory(cp, poolValue, pui.getClassLoader());
            OpenJPAConfiguration conf = factory.getConfiguration();
            this.setPersistenceEnvironmentInfo(conf, pui);
            this._log = conf.getLog("openjpa.Runtime");
            if (transformerException != null) {
                if (this._log.isTraceEnabled()) {
                    this._log.warn((Object)_loc.get("transformer-registration-error-ex", (Object)pui), (Throwable)transformerException);
                } else {
                    this._log.warn((Object)_loc.get("transformer-registration-error", (Object)pui));
                }
            }
            this.loadValidator(factory);
            this.preloadMetaDataRepository(factory);
            return JPAFacadeHelper.toEntityManagerFactory(factory);
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    public void setPersistenceEnvironmentInfo(OpenJPAConfiguration conf, PersistenceUnitInfo pui) {
        if (conf instanceof OpenJPAConfigurationImpl) {
            HashMap<String, URL> peMap = ((OpenJPAConfigurationImpl)conf).getPersistenceEnvironment();
            if (peMap == null) {
                peMap = new HashMap<String, URL>();
                ((OpenJPAConfigurationImpl)conf).setPersistenceEnvironment(peMap);
            }
            peMap.put("PersistenceUnitRootUrl", pui.getPersistenceUnitRootUrl());
            peMap.put("MappingFileNames", (URL)((Object)pui.getMappingFileNames()));
            peMap.put("JarFiles", (URL)((Object)pui.getJarFileUrls()));
        }
    }

    public ProviderUtil getProviderUtil() {
        return this;
    }

    protected String getDefaultBrokerAlias() {
        return "non-finalizing";
    }

    protected OpenJPAConfiguration newConfigurationImpl() {
        return new OpenJPAConfigurationImpl();
    }

    private void preloadMetaDataRepository(BrokerFactory factory) {
        OpenJPAConfiguration conf = factory.getConfiguration();
        Options o = Configurations.parseProperties((String)Configurations.getProperties((String)conf.getMetaDataRepository()));
        if (MetaDataRepository.needsPreload((Options)o)) {
            MetaDataRepository mdr = conf.getMetaDataRepositoryInstance();
            mdr.setValidate(8, true);
            mdr.setResolve(8, true);
            ((AbstractBrokerFactory)factory).loadPersistentTypes((ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction()));
            mdr.preload();
        }
    }

    private void loadAgent(BrokerFactory factory) {
        OpenJPAConfiguration conf = factory.getConfiguration();
        Log log = conf.getLog("openjpa.Runtime");
        if (conf.getDynamicEnhancementAgent()) {
            boolean res = PCEnhancerAgent.loadDynamicAgent((Log)log);
            if (log.isInfoEnabled() && res) {
                log.info((Object)_loc.get("dynamic-agent"));
            }
        }
    }

    private void loadValidator(BrokerFactory factory) {
        OpenJPAConfiguration conf = factory.getConfiguration();
        Log log = conf.getLog("openjpa.Runtime");
        if (ValidationUtils.setupValidation(conf) && log.isInfoEnabled()) {
            log.info((Object)_loc.get("vlem-creation-info"));
        }
    }

    public LoadState isLoaded(Object obj) {
        return this.isLoadedWithoutReference(obj, null);
    }

    public LoadState isLoadedWithReference(Object obj, String attr) {
        return this.isLoadedWithoutReference(obj, attr);
    }

    public LoadState isLoadedWithoutReference(Object obj, String attr) {
        if (obj == null) {
            return LoadState.UNKNOWN;
        }
        return OpenJPAPersistenceUtil.isLoaded(obj, attr);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassTransformerImpl
    implements ClassTransformer {
        private final ClassFileTransformer _trans;

        private ClassTransformerImpl(ConfigurationProvider cp, String props, final ClassLoader tmpLoader, OpenJPAConfiguration conf) {
            cp.setInto((Configuration)conf);
            conf.setClassResolver(new ClassResolver(){

                public ClassLoader getClassLoader(Class<?> context, ClassLoader env) {
                    return tmpLoader;
                }
            });
            conf.setReadOnly(1);
            MetaDataRepository repos = conf.getMetaDataRepositoryInstance();
            repos.setResolve(2, false);
            this._trans = new PCClassFileTransformer(repos, Configurations.parseProperties((String)props), tmpLoader);
        }

        public byte[] transform(ClassLoader cl, String name, Class<?> previousVersion, ProtectionDomain pd, byte[] bytes) throws IllegalClassFormatException {
            return this._trans.transform(cl, name, previousVersion, pd, bytes);
        }
    }
}

