/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.io.File;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.FetchType;
import javax.persistence.FlushModeType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.QueryHint;
import javax.persistence.SequenceGenerator;
import javax.persistence.Version;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.event.BeanLifecycleCallbacks;
import org.apache.openjpa.event.LifecycleCallbacks;
import org.apache.openjpa.event.LifecycleEvent;
import org.apache.openjpa.event.MethodLifecycleCallbacks;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPriv5Helper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.DelegatingMetaDataFactory;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.meta.LifecycleMetaData;
import org.apache.openjpa.meta.MetaDataDefaults;
import org.apache.openjpa.meta.MetaDataFactory;
import org.apache.openjpa.meta.MetaDataModes;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.persistence.DataCache;
import org.apache.openjpa.persistence.DataStoreId;
import org.apache.openjpa.persistence.Dependent;
import org.apache.openjpa.persistence.DetachedState;
import org.apache.openjpa.persistence.ElementDependent;
import org.apache.openjpa.persistence.ElementType;
import org.apache.openjpa.persistence.ExternalValues;
import org.apache.openjpa.persistence.Externalizer;
import org.apache.openjpa.persistence.Factory;
import org.apache.openjpa.persistence.FetchAttribute;
import org.apache.openjpa.persistence.FetchGroup;
import org.apache.openjpa.persistence.FetchGroups;
import org.apache.openjpa.persistence.InverseLogical;
import org.apache.openjpa.persistence.KeyDependent;
import org.apache.openjpa.persistence.KeyType;
import org.apache.openjpa.persistence.LRS;
import org.apache.openjpa.persistence.LoadFetchGroup;
import org.apache.openjpa.persistence.MetaDataParsers;
import org.apache.openjpa.persistence.MetaDataTag;
import org.apache.openjpa.persistence.PersistenceMetaDataDefaults;
import org.apache.openjpa.persistence.PersistenceMetaDataFactory;
import org.apache.openjpa.persistence.PersistenceStrategy;
import org.apache.openjpa.persistence.Persistent;
import org.apache.openjpa.persistence.PersistentCollection;
import org.apache.openjpa.persistence.PersistentMap;
import org.apache.openjpa.persistence.ReadOnly;
import org.apache.openjpa.persistence.Type;
import org.apache.openjpa.persistence.UpdateAction;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.UnsupportedException;
import org.apache.openjpa.util.UserException;
import serp.util.Numbers;
import serp.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationPersistenceMetaDataParser
implements MetaDataModes {
    private static final Localizer _loc = Localizer.forPackage(AnnotationPersistenceMetaDataParser.class);
    private static final Map<Class, MetaDataTag> _tags = new HashMap<Class, MetaDataTag>();
    private final OpenJPAConfiguration _conf;
    private final Log _log;
    private MetaDataRepository _repos = null;
    private ClassLoader _envLoader = null;
    private boolean _override = false;
    private int _mode = 0;
    private final Map<Package, Integer> _pkgs = new HashMap<Package, Integer>();
    private Class _cls = null;
    private File _file = null;

    public AnnotationPersistenceMetaDataParser(OpenJPAConfiguration conf) {
        this._conf = conf;
        this._log = conf.getLog("openjpa.MetaData");
    }

    public OpenJPAConfiguration getConfiguration() {
        return this._conf;
    }

    public Log getLog() {
        return this._log;
    }

    public MetaDataRepository getRepository() {
        if (this._repos == null) {
            MetaDataRepository repos = this._conf.newMetaDataRepositoryInstance();
            MetaDataFactory mdf = repos.getMetaDataFactory();
            if (mdf instanceof DelegatingMetaDataFactory) {
                mdf = ((DelegatingMetaDataFactory)mdf).getInnermostDelegate();
            }
            if (mdf instanceof PersistenceMetaDataFactory) {
                ((PersistenceMetaDataFactory)mdf).setAnnotationParser(this);
            }
            this._repos = repos;
        }
        return this._repos;
    }

    public void setRepository(MetaDataRepository repos) {
        this._repos = repos;
    }

    public ClassLoader getEnvClassLoader() {
        return this._envLoader;
    }

    public void setEnvClassLoader(ClassLoader loader) {
        this._envLoader = loader;
    }

    public boolean getMappingOverride() {
        return this._override;
    }

    public void setMappingOverride(boolean override) {
        this._override = override;
    }

    public int getMode() {
        return this._mode;
    }

    public void setMode(int mode, boolean on) {
        this._mode = mode == 0 ? 0 : (on ? (this._mode |= mode) : (this._mode &= ~mode));
    }

    public void setMode(int mode) {
        this._mode = mode;
    }

    protected boolean isMetaDataMode() {
        return (this._mode & 1) != 0;
    }

    protected boolean isQueryMode() {
        return (this._mode & 4) != 0;
    }

    protected boolean isMappingMode() {
        return (this._mode & 2) != 0;
    }

    protected boolean isMappingOverrideMode() {
        return this.isMappingMode() || this._override && this.isMetaDataMode();
    }

    public void clear() {
        this._cls = null;
        this._file = null;
        this._pkgs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Class cls) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)_loc.get("parse-class", (Object)cls.getName()));
        }
        this._cls = cls;
        try {
            this.parsePackageAnnotations();
            ClassMetaData meta = this.parseClassAnnotations();
            this.updateSourceMode(meta);
        }
        finally {
            this._cls = null;
            this._file = null;
        }
    }

    private void updateSourceMode(ClassMetaData meta) {
        if (this._cls.getPackage() != null) {
            this.addSourceMode(this._cls.getPackage(), this._mode);
        }
        if (meta != null) {
            meta.setSourceMode(this._mode, true);
        }
    }

    private void parsePackageAnnotations() {
        Package pkg = this._cls.getPackage();
        if (pkg == null) {
            return;
        }
        int pkgMode = this.getSourceMode(pkg);
        if (pkgMode == 0 && this._log.isTraceEnabled()) {
            this._log.trace((Object)_loc.get("parse-package", (Object)this._cls.getName()));
        }
        if ((pkgMode & this._mode) == this._mode) {
            return;
        }
        block7: for (Annotation anno : pkg.getDeclaredAnnotations()) {
            MetaDataTag tag = _tags.get(anno.annotationType());
            if (tag == null) {
                this.handleUnknownPackageAnnotation(pkg, anno);
                continue;
            }
            switch (tag) {
                case NATIVE_QUERIES: {
                    if (!this.isQueryMode() || (pkgMode & 4) != 0) continue block7;
                    this.parseNamedNativeQueries(pkg, ((NamedNativeQueries)anno).value());
                    continue block7;
                }
                case NATIVE_QUERY: {
                    if (!this.isQueryMode() || (pkgMode & 4) != 0) continue block7;
                    this.parseNamedNativeQueries(pkg, (NamedNativeQuery)anno);
                    continue block7;
                }
                case QUERIES: {
                    if (!this.isQueryMode() || (pkgMode & 4) != 0) continue block7;
                    this.parseNamedQueries(pkg, ((NamedQueries)anno).value());
                    continue block7;
                }
                case QUERY: {
                    if (!this.isQueryMode() || (pkgMode & 4) != 0) continue block7;
                    this.parseNamedQueries(pkg, (NamedQuery)anno);
                    continue block7;
                }
                case SEQ_GENERATOR: {
                    if (!this.isMappingOverrideMode() || (pkgMode & 2) != 0) continue block7;
                    this.parseSequenceGenerator(pkg, (SequenceGenerator)anno);
                    continue block7;
                }
                default: {
                    throw new UnsupportedException(_loc.get("unsupported", (Object)pkg, (Object)((Object)anno).toString()));
                }
            }
        }
        if (this.isMappingOverrideMode() && (pkgMode & 2) == 0) {
            this.parsePackageMappingAnnotations(pkg);
        }
    }

    protected void parsePackageMappingAnnotations(Package pkg) {
    }

    protected boolean handleUnknownPackageAnnotation(Package pkg, Annotation anno) {
        return false;
    }

    private int getSourceMode(Package pkg) {
        Number num = this._pkgs.get(pkg);
        return num == null ? 0 : num.intValue();
    }

    private void addSourceMode(Package pkg, int mode) {
        Integer num = this._pkgs.get(pkg);
        num = num == null ? Numbers.valueOf((int)mode) : Numbers.valueOf((int)(num | mode));
        this._pkgs.put(pkg, num);
    }

    private ClassMetaData parseClassAnnotations() {
        if (!(((Boolean)AccessController.doPrivileged(J2DoPriv5Helper.isAnnotationPresentAction((AnnotatedElement)this._cls, Entity.class))).booleanValue() || ((Boolean)AccessController.doPrivileged(J2DoPriv5Helper.isAnnotationPresentAction((AnnotatedElement)this._cls, Embeddable.class))).booleanValue() || ((Boolean)AccessController.doPrivileged(J2DoPriv5Helper.isAnnotationPresentAction((AnnotatedElement)this._cls, MappedSuperclass.class))).booleanValue())) {
            return null;
        }
        ClassMetaData meta = this.getMetaData();
        if (meta == null) {
            return null;
        }
        Entity entity = this._cls.getAnnotation(Entity.class);
        if (this.isMetaDataMode()) {
            if (entity == null) {
                meta.setEmbeddedOnly(true);
            } else {
                meta.setEmbeddedOnly(false);
                if (!StringUtils.isEmpty((String)entity.name())) {
                    meta.setTypeAlias(entity.name());
                }
            }
        }
        FetchGroup[] fgs = null;
        DetachedState detached = null;
        Collection<LifecycleCallbacks>[] listeners = null;
        block17: for (Annotation annotation : this._cls.getDeclaredAnnotations()) {
            MetaDataTag tag = _tags.get(annotation.annotationType());
            if (tag == null) {
                this.handleUnknownClassAnnotation(meta, annotation);
                continue;
            }
            switch (tag) {
                case ENTITY_LISTENERS: {
                    if (!this.isMetaDataMode()) continue block17;
                    listeners = this.parseEntityListeners(meta, (EntityListeners)annotation);
                    continue block17;
                }
                case EXCLUDE_DEFAULT_LISTENERS: {
                    if (!this.isMetaDataMode()) continue block17;
                    meta.getLifecycleMetaData().setIgnoreSystemListeners(true);
                    continue block17;
                }
                case EXCLUDE_SUPERCLASS_LISTENERS: {
                    if (!this.isMetaDataMode()) continue block17;
                    meta.getLifecycleMetaData().setIgnoreSuperclassCallbacks(2);
                    continue block17;
                }
                case FLUSH_MODE: {
                    if (!this.isMetaDataMode()) continue block17;
                    this.warnFlushMode(meta);
                    continue block17;
                }
                case ID_CLASS: {
                    if (!this.isMetaDataMode()) continue block17;
                    meta.setObjectIdType(((IdClass)annotation).value(), true);
                    continue block17;
                }
                case NATIVE_QUERIES: {
                    if (!this.isQueryMode()) continue block17;
                    this.parseNamedNativeQueries(this._cls, ((NamedNativeQueries)annotation).value());
                    continue block17;
                }
                case NATIVE_QUERY: {
                    if (!this.isQueryMode()) continue block17;
                    this.parseNamedNativeQueries(this._cls, (NamedNativeQuery)annotation);
                    continue block17;
                }
                case QUERIES: {
                    if (!this.isQueryMode()) continue block17;
                    this.parseNamedQueries(this._cls, ((NamedQueries)annotation).value());
                    continue block17;
                }
                case QUERY: {
                    if (!this.isQueryMode()) continue block17;
                    this.parseNamedQueries(this._cls, (NamedQuery)annotation);
                    continue block17;
                }
                case SEQ_GENERATOR: {
                    if (!this.isMappingOverrideMode()) continue block17;
                    this.parseSequenceGenerator(this._cls, (SequenceGenerator)annotation);
                    continue block17;
                }
                case DATA_CACHE: {
                    if (!this.isMetaDataMode()) continue block17;
                    this.parseDataCache(meta, (DataCache)annotation);
                    continue block17;
                }
                case DATASTORE_ID: {
                    if (!this.isMetaDataMode()) continue block17;
                    this.parseDataStoreId(meta, (DataStoreId)annotation);
                    continue block17;
                }
                case DETACHED_STATE: {
                    detached = (DetachedState)annotation;
                    continue block17;
                }
                case FETCH_GROUP: {
                    if (!this.isMetaDataMode()) continue block17;
                    fgs = new FetchGroup[]{(FetchGroup)annotation};
                    continue block17;
                }
                case FETCH_GROUPS: {
                    if (!this.isMetaDataMode()) continue block17;
                    fgs = ((FetchGroups)annotation).value();
                    continue block17;
                }
                default: {
                    throw new UnsupportedException(_loc.get("unsupported", (Object)this._cls, (Object)((Object)annotation).toString()));
                }
            }
        }
        if (this.isMetaDataMode()) {
            this.parseDetachedState(meta, detached);
            int[] highs = null;
            if (listeners != null) {
                highs = new int[listeners.length];
                for (int i = 0; i < listeners.length; ++i) {
                    if (listeners[i] == null) continue;
                    highs[i] = listeners[i].size();
                }
            }
            this.recordCallbacks(meta, AnnotationPersistenceMetaDataParser.parseCallbackMethods(this._cls, listeners, false, false, this.getRepository()), highs, false);
            if (!Object.class.equals(this._cls.getSuperclass())) {
                this.recordCallbacks(meta, AnnotationPersistenceMetaDataParser.parseCallbackMethods(this._cls.getSuperclass(), null, true, false, this.getRepository()), null, true);
            }
        }
        for (Annotation annotation : meta.getDeclaredFields()) {
            if (annotation.getManagement() != 3) continue;
            this.parseMemberAnnotations((FieldMetaData)annotation);
        }
        if (fgs != null) {
            this.parseFetchGroups(meta, fgs);
        }
        if (this.isMappingOverrideMode()) {
            this.parseClassMappingAnnotations(meta);
            for (Annotation annotation : meta.getDeclaredFields()) {
                if (annotation.getManagement() != 3) continue;
                this.parseMemberMappingAnnotations((FieldMetaData)annotation);
            }
        }
        return meta;
    }

    protected void parseClassMappingAnnotations(ClassMetaData meta) {
    }

    protected boolean handleUnknownClassAnnotation(ClassMetaData meta, Annotation anno) {
        return false;
    }

    private ClassMetaData getMetaData() {
        ClassMetaData meta = this.getRepository().getCachedMetaData(this._cls);
        if (meta != null && (this.isMetaDataMode() && (meta.getSourceMode() & 1) != 0 || this.isMappingMode() && (meta.getSourceMode() & 2) != 0)) {
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)_loc.get("dup-metadata", (Object)this._cls.getName()));
            }
            return null;
        }
        if (meta == null) {
            meta = this.getRepository().addMetaData(this._cls);
            meta.setEnvClassLoader(this._envLoader);
            meta.setSourceMode(0);
            meta.setSource(this.getSourceFile(), 1);
        }
        return meta;
    }

    protected File getSourceFile() {
        if (this._file != null) {
            return this._file;
        }
        Class<?> cls = this._cls;
        while (cls.getEnclosingClass() != null) {
            cls = cls.getEnclosingClass();
        }
        String rsrc = StringUtils.replace((String)cls.getName(), (String)".", (String)"/");
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(J2DoPriv5Helper.getClassLoaderAction(cls));
        if (loader == null) {
            loader = (ClassLoader)AccessController.doPrivileged(J2DoPriv5Helper.getSystemClassLoaderAction());
        }
        if (loader == null) {
            return null;
        }
        URL url = (URL)AccessController.doPrivileged(J2DoPriv5Helper.getResourceAction((ClassLoader)loader, (String)(rsrc + ".java")));
        if (url == null && (url = (URL)AccessController.doPrivileged(J2DoPriv5Helper.getResourceAction((ClassLoader)loader, (String)(rsrc + ".class")))) == null) {
            return null;
        }
        try {
            this._file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        return this._file;
    }

    private void parseDataStoreId(ClassMetaData meta, DataStoreId id) {
        meta.setIdentityType(1);
        int strat = AnnotationPersistenceMetaDataParser.getGeneratedValueStrategy(meta, id.strategy(), id.generator());
        if (strat != -1) {
            meta.setIdentityStrategy(strat);
        } else {
            switch (id.strategy()) {
                case TABLE: 
                case SEQUENCE: {
                    if (StringUtils.isEmpty((String)id.generator())) {
                        meta.setIdentitySequenceName("system");
                        break;
                    }
                    meta.setIdentitySequenceName(id.generator());
                    break;
                }
                case AUTO: {
                    meta.setIdentityStrategy(1);
                    break;
                }
                case IDENTITY: {
                    meta.setIdentityStrategy(3);
                    break;
                }
                default: {
                    throw new UnsupportedException(id.strategy().toString());
                }
            }
        }
    }

    private void warnFlushMode(Object context) {
        if (this._log.isWarnEnabled()) {
            this._log.warn((Object)_loc.get("unsupported", (Object)"FlushMode", context));
        }
    }

    private void parseDataCache(ClassMetaData meta, DataCache cache) {
        if (cache.timeout() != Integer.MIN_VALUE) {
            meta.setDataCacheTimeout(cache.timeout());
        }
        if (!StringUtils.isEmpty((String)cache.name())) {
            meta.setDataCacheName(cache.name());
        } else if (cache.enabled()) {
            meta.setDataCacheName("default");
        } else {
            meta.setDataCacheName(null);
        }
    }

    private void parseDetachedState(ClassMetaData meta, DetachedState detached) {
        if (detached != null) {
            if (!detached.enabled()) {
                meta.setDetachedState(null);
            } else if (StringUtils.isEmpty((String)detached.fieldName())) {
                meta.setDetachedState("`syn");
            } else {
                meta.setDetachedState(detached.fieldName());
            }
        } else {
            Field[] fields = (Field[])AccessController.doPrivileged(J2DoPriv5Helper.getDeclaredFieldsAction((Class)meta.getDescribedType()));
            for (int i = 0; i < fields.length; ++i) {
                if (!((Boolean)AccessController.doPrivileged(J2DoPriv5Helper.isAnnotationPresentAction((AnnotatedElement)fields[i], DetachedState.class))).booleanValue()) continue;
                meta.setDetachedState(fields[i].getName());
            }
        }
    }

    private Collection<LifecycleCallbacks>[] parseEntityListeners(ClassMetaData meta, EntityListeners listeners) {
        Class[] classes = listeners.value();
        Collection<LifecycleCallbacks>[] parsed = null;
        for (Class cls : classes) {
            parsed = AnnotationPersistenceMetaDataParser.parseCallbackMethods(cls, parsed, true, true, this.getRepository());
        }
        return parsed;
    }

    public static Collection<LifecycleCallbacks>[] parseCallbackMethods(Class cls, Collection<LifecycleCallbacks>[] callbacks, boolean sups, boolean listener, MetaDataRepository repos) {
        TreeSet<Method> methods = new TreeSet<Method>(MethodComparator.getInstance());
        Class sup = cls;
        HashSet<MethodKey> seen = new HashSet<MethodKey>();
        do {
            for (Method m : (Method[])AccessController.doPrivileged(J2DoPriv5Helper.getDeclaredMethodsAction((Class)sup))) {
                MethodKey key;
                int mods = m.getModifiers();
                if (Modifier.isStatic(mods) || Modifier.isFinal(mods) || Object.class.equals(m.getDeclaringClass()) || seen.contains(key = new MethodKey(m))) continue;
                methods.add(m);
                seen.add(key);
            }
            sup = sup.getSuperclass();
        } while (sups && !Object.class.equals(sup));
        MetaDataDefaults def = repos.getMetaDataFactory().getDefaults();
        for (Method m : methods) {
            for (Annotation anno : (Annotation[])AccessController.doPrivileged(J2DoPriv5Helper.getDeclaredAnnotationsAction((AnnotatedElement)m))) {
                int[] events;
                MetaDataTag tag = _tags.get(anno.annotationType());
                if (tag == null || (events = MetaDataParsers.getEventTypes(tag)) == null) continue;
                if (callbacks == null) {
                    callbacks = new Collection[LifecycleEvent.ALL_EVENTS.length];
                }
                for (int i = 0; i < events.length; ++i) {
                    int e = events[i];
                    if (callbacks[e] == null) {
                        callbacks[e] = new ArrayList<LifecycleCallbacks>(3);
                    }
                    MetaDataParsers.validateMethodsForSameCallback(cls, callbacks[e], m, tag, def, repos.getLog());
                    if (listener) {
                        callbacks[e].add((LifecycleCallbacks)new BeanLifecycleCallbacks(cls, m, false));
                        continue;
                    }
                    callbacks[e].add((LifecycleCallbacks)new MethodLifecycleCallbacks(m, false));
                }
            }
        }
        return callbacks;
    }

    private void recordCallbacks(ClassMetaData cls, Collection<LifecycleCallbacks>[] callbacks, int[] highs, boolean superClass) {
        if (callbacks == null) {
            return;
        }
        LifecycleMetaData meta = cls.getLifecycleMetaData();
        for (int event : LifecycleEvent.ALL_EVENTS) {
            if (callbacks[event] == null) continue;
            LifecycleCallbacks[] array = callbacks[event].toArray(new LifecycleCallbacks[callbacks[event].size()]);
            if (superClass) {
                meta.setNonPCSuperclassCallbacks(event, array, highs == null ? 0 : highs[event]);
                continue;
            }
            meta.setDeclaredCallbacks(event, array, highs == null ? 0 : highs[event]);
        }
    }

    private void parseFetchGroups(ClassMetaData meta, FetchGroup ... groups) {
        org.apache.openjpa.meta.FetchGroup fg;
        for (FetchGroup group : groups) {
            if (StringUtils.isEmpty((String)group.name())) {
                throw new MetaDataException(_loc.get("unnamed-fg", (Object)meta));
            }
            fg = meta.addDeclaredFetchGroup(group.name());
            if (group.postLoad()) {
                fg.setPostLoad(true);
            }
            for (String s : group.fetchGroups()) {
                fg.addDeclaredInclude(s);
            }
        }
        for (FetchGroup group : groups) {
            String[] includedFetchGropNames;
            fg = meta.getFetchGroup(group.name());
            for (String includedFectchGroupName : includedFetchGropNames = fg.getDeclaredIncludes()) {
                org.apache.openjpa.meta.FetchGroup child = meta.getFetchGroup(includedFectchGroupName);
                if (child == null) {
                    throw new UserException(_loc.get("missing-included-fg", (Object)meta.getDescribedType().getName(), (Object)fg.getName(), (Object)includedFectchGroupName));
                }
                child.addContainedBy(fg);
            }
        }
        for (FetchGroup group : groups) {
            fg = meta.getFetchGroup(group.name());
            for (FetchAttribute attr : group.attributes()) {
                this.parseFetchAttribute(meta, fg, attr);
            }
        }
    }

    private void parseFetchAttribute(ClassMetaData meta, org.apache.openjpa.meta.FetchGroup fg, FetchAttribute attr) {
        FieldMetaData field = meta.getDeclaredField(attr.name());
        if (field == null || field.getManagement() != 3) {
            throw new MetaDataException(_loc.get("bad-fg-field", (Object)fg.getName(), (Object)meta, (Object)attr.name()));
        }
        field.setInFetchGroup(fg.getName(), true);
        Set parentFetchGroups = fg.getContainedBy();
        for (Object parentFetchGroup : parentFetchGroups) {
            field.setInFetchGroup(parentFetchGroup.toString(), true);
        }
        if (attr.recursionDepth() != Integer.MIN_VALUE) {
            fg.setRecursionDepth(field, attr.recursionDepth());
        }
    }

    private void parseMemberAnnotations(FieldMetaData fmd) {
        Member member = this.getRepository().getMetaDataFactory().getDefaults().getBackingMember(fmd);
        PersistenceStrategy pstrat = PersistenceMetaDataDefaults.getPersistenceStrategy(fmd, member);
        if (pstrat == null) {
            return;
        }
        fmd.setExplicit(true);
        AnnotatedElement el = (AnnotatedElement)((Object)member);
        boolean lob = (Boolean)AccessController.doPrivileged(J2DoPriv5Helper.isAnnotationPresentAction((AnnotatedElement)el, Lob.class));
        if (this.isMetaDataMode()) {
            switch (pstrat) {
                case BASIC: {
                    this.parseBasic(fmd, el.getAnnotation(Basic.class), lob);
                    break;
                }
                case MANY_ONE: {
                    this.parseManyToOne(fmd, el.getAnnotation(ManyToOne.class));
                    break;
                }
                case ONE_ONE: {
                    this.parseOneToOne(fmd, el.getAnnotation(OneToOne.class));
                    break;
                }
                case EMBEDDED: {
                    this.parseEmbedded(fmd, el.getAnnotation(Embedded.class));
                    break;
                }
                case ONE_MANY: {
                    this.parseOneToMany(fmd, el.getAnnotation(OneToMany.class));
                    break;
                }
                case MANY_MANY: {
                    this.parseManyToMany(fmd, el.getAnnotation(ManyToMany.class));
                    break;
                }
                case PERS: {
                    this.parsePersistent(fmd, el.getAnnotation(Persistent.class));
                    break;
                }
                case PERS_COLL: {
                    this.parsePersistentCollection(fmd, el.getAnnotation(PersistentCollection.class));
                    break;
                }
                case PERS_MAP: {
                    this.parsePersistentMap(fmd, el.getAnnotation(PersistentMap.class));
                    break;
                }
                case TRANSIENT: {
                    break;
                }
                default: {
                    throw new InternalException();
                }
            }
        }
        if (this.isMappingOverrideMode() && lob) {
            this.parseLobMapping(fmd);
        }
        block34: for (Annotation anno : el.getDeclaredAnnotations()) {
            MetaDataTag tag = _tags.get(anno.annotationType());
            if (tag == null) {
                this.handleUnknownMemberAnnotation(fmd, anno);
                continue;
            }
            switch (tag) {
                case FLUSH_MODE: {
                    if (!this.isMetaDataMode()) continue block34;
                    this.warnFlushMode(fmd);
                    continue block34;
                }
                case GENERATED_VALUE: {
                    if (!this.isMappingOverrideMode()) continue block34;
                    this.parseGeneratedValue(fmd, (GeneratedValue)anno);
                    continue block34;
                }
                case ID: 
                case EMBEDDED_ID: {
                    fmd.setPrimaryKey(true);
                    continue block34;
                }
                case MAP_KEY: {
                    if (!this.isMappingOverrideMode()) continue block34;
                    this.parseMapKey(fmd, (MapKey)anno);
                    continue block34;
                }
                case ORDER_BY: {
                    this.parseOrderBy(fmd, el.getAnnotation(OrderBy.class));
                    continue block34;
                }
                case SEQ_GENERATOR: {
                    if (!this.isMappingOverrideMode()) continue block34;
                    this.parseSequenceGenerator(el, (SequenceGenerator)anno);
                    continue block34;
                }
                case VERSION: {
                    fmd.setVersion(true);
                    continue block34;
                }
                case DEPENDENT: {
                    if (!this.isMetaDataMode() || !((Dependent)anno).value()) continue block34;
                    fmd.setCascadeDelete(2);
                    continue block34;
                }
                case ELEM_DEPENDENT: {
                    if (!this.isMetaDataMode() || !((ElementDependent)anno).value()) continue block34;
                    fmd.getElement().setCascadeDelete(2);
                    continue block34;
                }
                case ELEM_TYPE: {
                    if (!this.isMetaDataMode()) continue block34;
                    fmd.getElement().setTypeOverride(AnnotationPersistenceMetaDataParser.toOverrideType(((ElementType)anno).value()));
                    continue block34;
                }
                case EXTERNAL_VALS: {
                    if (!this.isMetaDataMode()) continue block34;
                    fmd.setExternalValues(Strings.join((Object[])((ExternalValues)anno).value(), (String)","));
                    continue block34;
                }
                case EXTERNALIZER: {
                    if (!this.isMetaDataMode()) continue block34;
                    fmd.setExternalizer(((Externalizer)anno).value());
                    continue block34;
                }
                case FACTORY: {
                    if (!this.isMetaDataMode()) continue block34;
                    fmd.setFactory(((Factory)anno).value());
                    continue block34;
                }
                case INVERSE_LOGICAL: {
                    if (!this.isMetaDataMode()) continue block34;
                    fmd.setInverse(((InverseLogical)anno).value());
                    continue block34;
                }
                case KEY_DEPENDENT: {
                    if (!this.isMetaDataMode() || !((KeyDependent)anno).value()) continue block34;
                    fmd.getKey().setCascadeDelete(2);
                    continue block34;
                }
                case KEY_TYPE: {
                    if (!this.isMetaDataMode()) continue block34;
                    fmd.getKey().setTypeOverride(AnnotationPersistenceMetaDataParser.toOverrideType(((KeyType)anno).value()));
                    continue block34;
                }
                case LOAD_FETCH_GROUP: {
                    if (!this.isMetaDataMode()) continue block34;
                    fmd.setLoadFetchGroup(((LoadFetchGroup)anno).value());
                    continue block34;
                }
                case LRS: {
                    if (!this.isMetaDataMode()) continue block34;
                    fmd.setLRS(((LRS)anno).value());
                    continue block34;
                }
                case READ_ONLY: {
                    if (!this.isMetaDataMode()) continue block34;
                    this.parseReadOnly(fmd, (ReadOnly)anno);
                    continue block34;
                }
                case TYPE: {
                    if (!this.isMetaDataMode()) continue block34;
                    fmd.setTypeOverride(AnnotationPersistenceMetaDataParser.toOverrideType(((Type)anno).value()));
                    continue block34;
                }
                default: {
                    throw new UnsupportedException(_loc.get("unsupported", (Object)fmd, (Object)((Object)anno).toString()));
                }
            }
        }
    }

    protected void parseMemberMappingAnnotations(FieldMetaData fmd) {
    }

    protected boolean handleUnknownMemberAnnotation(FieldMetaData fmd, Annotation anno) {
        return false;
    }

    private static Class toOverrideType(Class cls) {
        return cls == Entity.class ? PersistenceCapable.class : cls;
    }

    private void parseReadOnly(FieldMetaData fmd, ReadOnly ro) {
        if (ro.value() == UpdateAction.RESTRICT) {
            fmd.setUpdateStrategy(2);
        } else if (ro.value() == UpdateAction.IGNORE) {
            fmd.setUpdateStrategy(1);
        } else {
            throw new InternalException();
        }
    }

    private void parseGeneratedValue(FieldMetaData fmd, GeneratedValue gen) {
        GenerationType strategy = gen.strategy();
        String generator = gen.generator();
        AnnotationPersistenceMetaDataParser.parseGeneratedValue(fmd, strategy, generator);
    }

    static void parseGeneratedValue(FieldMetaData fmd, GenerationType strategy, String generator) {
        int strat = AnnotationPersistenceMetaDataParser.getGeneratedValueStrategy(fmd, strategy, generator);
        if (strat != -1) {
            fmd.setValueStrategy(strat);
        } else {
            switch (strategy) {
                case TABLE: 
                case SEQUENCE: {
                    if (StringUtils.isEmpty((String)generator)) {
                        fmd.setValueSequenceName("system");
                        break;
                    }
                    fmd.setValueSequenceName(generator);
                    break;
                }
                case AUTO: {
                    fmd.setValueSequenceName("system");
                    break;
                }
                case IDENTITY: {
                    fmd.setValueStrategy(3);
                    break;
                }
                default: {
                    throw new UnsupportedException(strategy.toString());
                }
            }
        }
    }

    private static int getGeneratedValueStrategy(Object context, GenerationType strategy, String generator) {
        if (strategy != GenerationType.AUTO || StringUtils.isEmpty((String)generator)) {
            return -1;
        }
        if ("uuid-hex".equals(generator)) {
            return 6;
        }
        if ("uuid-string".equals(generator)) {
            return 5;
        }
        throw new MetaDataException(_loc.get("generator-bad-strategy", context, (Object)generator));
    }

    private void parseBasic(FieldMetaData fmd, Basic anno, boolean lob) {
        Class type = fmd.getDeclaredType();
        if (lob && type != String.class && type != char[].class && type != Character[].class && type != byte[].class && type != Byte[].class) {
            fmd.setSerialized(true);
        } else if (!lob) {
            switch (fmd.getDeclaredTypeCode()) {
                case 8: {
                    if (Enum.class.isAssignableFrom(type)) break;
                }
                case 12: 
                case 13: 
                case 15: 
                case 27: {
                    if (Serializable.class.isAssignableFrom(type)) {
                        fmd.setSerialized(true);
                        break;
                    }
                    throw new MetaDataException(_loc.get("bad-meta-anno", (Object)fmd, (Object)"Basic"));
                }
                case 11: {
                    if (type == char[].class || type == Character[].class || type == byte[].class || type == Byte[].class) break;
                    if (Serializable.class.isAssignableFrom(type.getComponentType())) {
                        fmd.setSerialized(true);
                        break;
                    }
                    throw new MetaDataException(_loc.get("bad-meta-anno", (Object)fmd, (Object)"Basic"));
                }
            }
        }
        if (anno == null) {
            return;
        }
        fmd.setInDefaultFetchGroup(anno.fetch() == FetchType.EAGER);
        if (!anno.optional()) {
            fmd.setNullValue(2);
        }
    }

    private void parseManyToOne(FieldMetaData fmd, ManyToOne anno) {
        if (!JavaTypes.maybePC((ValueMetaData)fmd.getValue())) {
            throw new MetaDataException(_loc.get("bad-meta-anno", (Object)fmd, (Object)"ManyToOne"));
        }
        if (anno.fetch() == FetchType.EAGER) {
            fmd.setInDefaultFetchGroup(true);
        }
        if (!anno.optional()) {
            fmd.setNullValue(2);
        }
        if (anno.targetEntity() != Void.TYPE) {
            fmd.setTypeOverride(anno.targetEntity());
        }
        this.setCascades((ValueMetaData)fmd, anno.cascade());
    }

    private void parseOneToOne(FieldMetaData fmd, OneToOne anno) {
        if (!JavaTypes.maybePC((ValueMetaData)fmd.getValue())) {
            throw new MetaDataException(_loc.get("bad-meta-anno", (Object)fmd, (Object)"OneToOne"));
        }
        if (anno.fetch() == FetchType.EAGER) {
            fmd.setInDefaultFetchGroup(true);
        }
        if (!anno.optional()) {
            fmd.setNullValue(2);
        }
        if (this.isMappingOverrideMode() && !StringUtils.isEmpty((String)anno.mappedBy())) {
            fmd.setMappedBy(anno.mappedBy());
        }
        if (anno.targetEntity() != Void.TYPE) {
            fmd.setTypeOverride(anno.targetEntity());
        }
        this.setCascades((ValueMetaData)fmd, anno.cascade());
    }

    private void parseEmbedded(FieldMetaData fmd, Embedded anno) {
        if (!JavaTypes.maybePC((ValueMetaData)fmd.getValue())) {
            throw new MetaDataException(_loc.get("bad-meta-anno", (Object)fmd, (Object)"Embedded"));
        }
        fmd.setInDefaultFetchGroup(true);
        fmd.setEmbedded(true);
        if (fmd.getEmbeddedMetaData() == null) {
            fmd.addEmbeddedMetaData();
        }
    }

    private void parseOneToMany(FieldMetaData fmd, OneToMany anno) {
        switch (fmd.getDeclaredTypeCode()) {
            case 11: 
            case 12: 
            case 13: {
                if (JavaTypes.maybePC((ValueMetaData)fmd.getElement())) break;
            }
            default: {
                throw new MetaDataException(_loc.get("bad-meta-anno", (Object)fmd, (Object)"OneToMany"));
            }
        }
        fmd.setInDefaultFetchGroup(anno.fetch() == FetchType.EAGER);
        if (this.isMappingOverrideMode() && !StringUtils.isEmpty((String)anno.mappedBy())) {
            fmd.setMappedBy(anno.mappedBy());
        }
        if (anno.targetEntity() != Void.TYPE) {
            fmd.getElement().setDeclaredType(anno.targetEntity());
        }
        this.setCascades(fmd.getElement(), anno.cascade());
    }

    private void parseManyToMany(FieldMetaData fmd, ManyToMany anno) {
        switch (fmd.getDeclaredTypeCode()) {
            case 11: 
            case 12: 
            case 13: {
                if (JavaTypes.maybePC((ValueMetaData)fmd.getElement())) break;
            }
            default: {
                throw new MetaDataException(_loc.get("bad-meta-anno", (Object)fmd, (Object)"OneToMany"));
            }
        }
        fmd.setInDefaultFetchGroup(anno.fetch() == FetchType.EAGER);
        if (this.isMappingOverrideMode() && !StringUtils.isEmpty((String)anno.mappedBy())) {
            fmd.setMappedBy(anno.mappedBy());
        }
        if (anno.targetEntity() != Void.TYPE) {
            fmd.getElement().setDeclaredType(anno.targetEntity());
        }
        this.setCascades(fmd.getElement(), anno.cascade());
    }

    private void parseMapKey(FieldMetaData fmd, MapKey anno) {
        String name = anno.name();
        if (StringUtils.isEmpty((String)name)) {
            fmd.getKey().setValueMappedBy("`pk`");
        } else {
            fmd.getKey().setValueMappedBy(name);
        }
    }

    protected void parseLobMapping(FieldMetaData fmd) {
    }

    private void parseOrderBy(FieldMetaData fmd, OrderBy anno) {
        String dec = anno.value();
        if (dec.length() == 0) {
            dec = "#element asc";
        }
        fmd.setOrderDeclaration(dec);
    }

    private void parsePersistent(FieldMetaData fmd, Persistent anno) {
        switch (fmd.getDeclaredTypeCode()) {
            case 11: {
                if (fmd.getDeclaredType() == byte[].class || fmd.getDeclaredType() == Byte[].class || fmd.getDeclaredType() == char[].class || fmd.getDeclaredType() == Character[].class) break;
            }
            case 12: 
            case 13: {
                throw new MetaDataException(_loc.get("bad-meta-anno", (Object)fmd, (Object)"Persistent"));
            }
        }
        if (!StringUtils.isEmpty((String)anno.mappedBy())) {
            fmd.setMappedBy(anno.mappedBy());
        }
        fmd.setInDefaultFetchGroup(anno.fetch() == FetchType.EAGER);
        if (!anno.optional()) {
            fmd.setNullValue(2);
        }
        this.setCascades((ValueMetaData)fmd, anno.cascade());
        if (anno.embedded()) {
            if (!JavaTypes.maybePC((ValueMetaData)fmd.getValue())) {
                throw new MetaDataException(_loc.get("bad-meta-anno", (Object)fmd, (Object)"Persistent(embedded=true)"));
            }
            fmd.setEmbedded(true);
            if (fmd.getEmbeddedMetaData() == null) {
                fmd.addEmbeddedMetaData();
            }
        }
    }

    private void parsePersistentCollection(FieldMetaData fmd, PersistentCollection anno) {
        if (fmd.getDeclaredTypeCode() != 11 && fmd.getDeclaredTypeCode() != 12) {
            throw new MetaDataException(_loc.get("bad-meta-anno", (Object)fmd, (Object)"PersistentCollection"));
        }
        if (!StringUtils.isEmpty((String)anno.mappedBy())) {
            fmd.setMappedBy(anno.mappedBy());
        }
        fmd.setInDefaultFetchGroup(anno.fetch() == FetchType.EAGER);
        if (anno.elementType() != Void.TYPE) {
            fmd.getElement().setDeclaredType(anno.elementType());
        }
        this.setCascades(fmd.getElement(), anno.elementCascade());
        if (anno.elementEmbedded()) {
            if (!JavaTypes.maybePC((ValueMetaData)fmd.getElement())) {
                throw new MetaDataException(_loc.get("bad-meta-anno", (Object)fmd, (Object)"PersistentCollection(embeddedElement=true)"));
            }
            fmd.getElement().setEmbedded(true);
            if (fmd.getElement().getEmbeddedMetaData() == null) {
                fmd.getElement().addEmbeddedMetaData();
            }
        }
    }

    private void parsePersistentMap(FieldMetaData fmd, PersistentMap anno) {
        if (fmd.getDeclaredTypeCode() != 13) {
            throw new MetaDataException(_loc.get("bad-meta-anno", (Object)fmd, (Object)"PersistentMap"));
        }
        fmd.setInDefaultFetchGroup(anno.fetch() == FetchType.EAGER);
        if (anno.keyType() != Void.TYPE) {
            fmd.getKey().setDeclaredType(anno.keyType());
        }
        if (anno.elementType() != Void.TYPE) {
            fmd.getElement().setDeclaredType(anno.elementType());
        }
        this.setCascades(fmd.getKey(), anno.keyCascade());
        this.setCascades(fmd.getElement(), anno.elementCascade());
        if (anno.keyEmbedded()) {
            if (!JavaTypes.maybePC((ValueMetaData)fmd.getKey())) {
                throw new MetaDataException(_loc.get("bad-meta-anno", (Object)fmd, (Object)"PersistentMap(embeddedKey=true)"));
            }
            fmd.getKey().setEmbedded(true);
            if (fmd.getKey().getEmbeddedMetaData() == null) {
                fmd.getKey().addEmbeddedMetaData();
            }
        }
        if (anno.elementEmbedded()) {
            if (!JavaTypes.maybePC((ValueMetaData)fmd.getElement())) {
                throw new MetaDataException(_loc.get("bad-meta-anno", (Object)fmd, (Object)"PersistentMap(embeddedValue=true)"));
            }
            fmd.getElement().setEmbedded(true);
            if (fmd.getElement().getEmbeddedMetaData() == null) {
                fmd.getElement().addEmbeddedMetaData();
            }
        }
    }

    private void setCascades(ValueMetaData vmd, CascadeType[] cascades) {
        for (CascadeType cascade : cascades) {
            if (cascade == CascadeType.ALL || cascade == CascadeType.REMOVE) {
                vmd.setCascadeDelete(1);
            }
            if (cascade == CascadeType.ALL || cascade == CascadeType.PERSIST) {
                vmd.setCascadePersist(1);
            }
            if (cascade == CascadeType.ALL || cascade == CascadeType.MERGE) {
                vmd.setCascadeAttach(1);
            }
            if (cascade != CascadeType.ALL && cascade != CascadeType.REFRESH) continue;
            vmd.setCascadeRefresh(1);
        }
    }

    private void parseSequenceGenerator(AnnotatedElement el, SequenceGenerator gen) {
        String props;
        String clsName;
        SequenceMetaData meta;
        String name = gen.name();
        if (StringUtils.isEmpty((String)name)) {
            throw new MetaDataException(_loc.get("no-seq-name", (Object)el));
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)_loc.get("parse-sequence", (Object)name));
        }
        if ((meta = this.getRepository().getCachedSequenceMetaData(name)) != null) {
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)_loc.get("dup-sequence", (Object)name, (Object)el));
            }
            return;
        }
        meta = this.getRepository().addSequenceMetaData(name);
        String seq = gen.sequenceName();
        int initial = gen.initialValue();
        int allocate = gen.allocationSize();
        if (initial == 0) {
            initial = 1;
        }
        if (StringUtils.isEmpty((String)seq)) {
            clsName = "native";
            props = null;
        } else if (seq.indexOf(40) != -1) {
            clsName = Configurations.getClassName((String)seq);
            props = Configurations.getProperties((String)seq);
            seq = null;
        } else {
            clsName = "native";
            props = null;
        }
        meta.setSequencePlugin(Configurations.getPlugin((String)clsName, props));
        meta.setSequence(seq);
        meta.setInitialValue(initial);
        meta.setAllocate(allocate);
        meta.setSource(this.getSourceFile(), (Object)(el instanceof Class ? el : null), 1);
    }

    private void parseNamedQueries(AnnotatedElement el, NamedQuery ... queries) {
        for (NamedQuery query : queries) {
            QueryMetaData meta;
            if (StringUtils.isEmpty((String)query.name())) {
                throw new MetaDataException(_loc.get("no-query-name", (Object)el));
            }
            if (StringUtils.isEmpty((String)query.query())) {
                throw new MetaDataException(_loc.get("no-query-string", (Object)query.name(), (Object)el));
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)_loc.get("parse-query", (Object)query.name()));
            }
            if ((meta = this.getRepository().getCachedQueryMetaData(null, query.name())) != null) {
                if (!this._log.isWarnEnabled()) continue;
                this._log.warn((Object)_loc.get("dup-query", (Object)query.name(), (Object)el));
                continue;
            }
            meta = this.getRepository().addQueryMetaData(null, query.name());
            meta.setQueryString(query.query());
            meta.setLanguage("javax.persistence.JPQL");
            for (QueryHint hint : query.hints()) {
                meta.addHint(hint.name(), (Object)hint.value());
            }
            meta.setSource(this.getSourceFile(), (Object)(el instanceof Class ? el : null), 1);
            if (this.isMetaDataMode()) {
                meta.setSourceMode(1);
                continue;
            }
            if (this.isMappingMode()) {
                meta.setSourceMode(2);
                continue;
            }
            meta.setSourceMode(4);
        }
    }

    private void parseNamedNativeQueries(AnnotatedElement el, NamedNativeQuery ... queries) {
        for (NamedNativeQuery query : queries) {
            QueryMetaData meta;
            if (StringUtils.isEmpty((String)query.name())) {
                throw new MetaDataException(_loc.get("no-native-query-name", (Object)el));
            }
            if (StringUtils.isEmpty((String)query.query())) {
                throw new MetaDataException(_loc.get("no-native-query-string", (Object)query.name(), (Object)el));
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)_loc.get("parse-native-query", (Object)query.name()));
            }
            if ((meta = this.getRepository().getCachedQueryMetaData(null, query.name())) != null) {
                if (!this._log.isWarnEnabled()) continue;
                this._log.warn((Object)_loc.get("dup-query", (Object)query.name(), (Object)el));
                continue;
            }
            meta = this.getRepository().addQueryMetaData(null, query.name());
            meta.setQueryString(query.query());
            meta.setLanguage("openjpa.SQL");
            Class res = query.resultClass();
            if (ImplHelper.isManagedType((OpenJPAConfiguration)this.getConfiguration(), (Class)res)) {
                meta.setCandidateType(res);
            } else if (!Void.TYPE.equals(res)) {
                meta.setResultType(res);
            }
            if (!StringUtils.isEmpty((String)query.resultSetMapping())) {
                meta.setResultSetMappingName(query.resultSetMapping());
            }
            meta.setSource(this.getSourceFile(), (Object)(el instanceof Class ? el : null), 1);
            if (this.isMetaDataMode()) {
                meta.setSourceMode(1);
                continue;
            }
            if (this.isMappingMode()) {
                meta.setSourceMode(2);
                continue;
            }
            meta.setSourceMode(4);
        }
    }

    static {
        _tags.put(EmbeddedId.class, MetaDataTag.EMBEDDED_ID);
        _tags.put(EntityListeners.class, MetaDataTag.ENTITY_LISTENERS);
        _tags.put(ExcludeDefaultListeners.class, MetaDataTag.EXCLUDE_DEFAULT_LISTENERS);
        _tags.put(ExcludeSuperclassListeners.class, MetaDataTag.EXCLUDE_SUPERCLASS_LISTENERS);
        _tags.put(FlushModeType.class, MetaDataTag.FLUSH_MODE);
        _tags.put(GeneratedValue.class, MetaDataTag.GENERATED_VALUE);
        _tags.put(Id.class, MetaDataTag.ID);
        _tags.put(IdClass.class, MetaDataTag.ID_CLASS);
        _tags.put(MapKey.class, MetaDataTag.MAP_KEY);
        _tags.put(NamedNativeQueries.class, MetaDataTag.NATIVE_QUERIES);
        _tags.put(NamedNativeQuery.class, MetaDataTag.NATIVE_QUERY);
        _tags.put(NamedQueries.class, MetaDataTag.QUERIES);
        _tags.put(NamedQuery.class, MetaDataTag.QUERY);
        _tags.put(OrderBy.class, MetaDataTag.ORDER_BY);
        _tags.put(PostLoad.class, MetaDataTag.POST_LOAD);
        _tags.put(PostPersist.class, MetaDataTag.POST_PERSIST);
        _tags.put(PostRemove.class, MetaDataTag.POST_REMOVE);
        _tags.put(PostUpdate.class, MetaDataTag.POST_UPDATE);
        _tags.put(PrePersist.class, MetaDataTag.PRE_PERSIST);
        _tags.put(PreRemove.class, MetaDataTag.PRE_REMOVE);
        _tags.put(PreUpdate.class, MetaDataTag.PRE_UPDATE);
        _tags.put(SequenceGenerator.class, MetaDataTag.SEQ_GENERATOR);
        _tags.put(Version.class, MetaDataTag.VERSION);
        _tags.put(DataCache.class, MetaDataTag.DATA_CACHE);
        _tags.put(DataStoreId.class, MetaDataTag.DATASTORE_ID);
        _tags.put(Dependent.class, MetaDataTag.DEPENDENT);
        _tags.put(DetachedState.class, MetaDataTag.DETACHED_STATE);
        _tags.put(ElementDependent.class, MetaDataTag.ELEM_DEPENDENT);
        _tags.put(ElementType.class, MetaDataTag.ELEM_TYPE);
        _tags.put(ExternalValues.class, MetaDataTag.EXTERNAL_VALS);
        _tags.put(Externalizer.class, MetaDataTag.EXTERNALIZER);
        _tags.put(Factory.class, MetaDataTag.FACTORY);
        _tags.put(FetchGroup.class, MetaDataTag.FETCH_GROUP);
        _tags.put(FetchGroups.class, MetaDataTag.FETCH_GROUPS);
        _tags.put(InverseLogical.class, MetaDataTag.INVERSE_LOGICAL);
        _tags.put(KeyDependent.class, MetaDataTag.KEY_DEPENDENT);
        _tags.put(KeyType.class, MetaDataTag.KEY_TYPE);
        _tags.put(LoadFetchGroup.class, MetaDataTag.LOAD_FETCH_GROUP);
        _tags.put(LRS.class, MetaDataTag.LRS);
        _tags.put(ReadOnly.class, MetaDataTag.READ_ONLY);
        _tags.put(Type.class, MetaDataTag.TYPE);
    }

    private static class MethodComparator
    implements Comparator {
        private static MethodComparator INSTANCE = null;

        private MethodComparator() {
        }

        public static MethodComparator getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new MethodComparator();
            }
            return INSTANCE;
        }

        public int compare(Object o1, Object o2) {
            Class<?> c2;
            Method m1 = (Method)o1;
            Method m2 = (Method)o2;
            Class<?> c1 = m1.getDeclaringClass();
            if (!c1.equals(c2 = m2.getDeclaringClass())) {
                if (c1.isAssignableFrom(c2)) {
                    return -1;
                }
                return 1;
            }
            int compare = m1.getName().compareTo(m2.getName());
            if (compare == 0) {
                return m1.hashCode() - m2.hashCode();
            }
            return compare;
        }
    }

    private static class MethodKey {
        private final Method _method;

        public MethodKey(Method m) {
            this._method = m;
        }

        public int hashCode() {
            int code = 552 + this._method.getName().hashCode();
            for (Class<?> param : this._method.getParameterTypes()) {
                code = 46 * code + param.hashCode();
            }
            return code;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MethodKey)) {
                return false;
            }
            Method other = ((MethodKey)o)._method;
            if (!this._method.getName().equals(other.getName())) {
                return false;
            }
            return Arrays.equals(this._method.getParameterTypes(), other.getParameterTypes());
        }
    }
}

