/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.lockmgr;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.persistence.EntityManagerFactory;
import javax.persistence.LockModeType;
import javax.persistence.PessimisticLockException;
import javax.persistence.Query;
import javax.persistence.QueryTimeoutException;
import javax.persistence.TypedQuery;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.jdbc.sql.InformixDictionary;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.persistence.LockTimeoutException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.lockmgr.Department;
import org.apache.openjpa.persistence.lockmgr.Employee;
import org.apache.openjpa.persistence.lockmgr.VersionEntity;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;
import org.apache.openjpa.util.OpenJPAException;

public class TestPessimisticLocks
extends SQLListenerTestCase {
    private DBDictionary dict = null;
    private int lockWaitTime = 2000;

    protected String getPersistenceUnitName() {
        return "locking-test";
    }

    public void setUp() {
        OpenJPAEntityManagerFactorySPI tempEMF = this.emf;
        if (tempEMF == null) {
            tempEMF = this.createEMF(new Object[0]);
        }
        TestPessimisticLocks.assertNotNull((Object)tempEMF);
        this.dict = ((JDBCConfiguration)tempEMF.getConfiguration()).getDBDictionaryInstance();
        TestPessimisticLocks.assertNotNull((Object)this.dict);
        if (!this.dict.supportsQueryTimeout) {
            this.setTestsDisabled(true);
        }
        if (this.emf == null) {
            this.closeEMF((EntityManagerFactory)tempEMF);
        }
        if (this.isTestsDisabled()) {
            return;
        }
        this.setUp(new Object[]{CLEAR_TABLES, Employee.class, Department.class, VersionEntity.class, "openjpa.LockManager", "mixed"});
        OpenJPAEntityManagerSPI em = null;
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Department d1 = new Department();
        d1.setId(10);
        d1.setName("D10");
        Employee e1 = new Employee();
        e1.setId(1);
        e1.setDepartment(d1);
        e1.setFirstName("first.1");
        e1.setLastName("last.1");
        Department d2 = new Department();
        d2.setId(20);
        d2.setName("D20");
        Employee e2 = new Employee();
        e2.setId(2);
        e2.setDepartment(d2);
        e2.setFirstName("first.2");
        e2.setLastName("last.2");
        em.persist((Object)d1);
        em.persist((Object)d2);
        em.persist((Object)e1);
        em.persist((Object)e2);
        em.getTransaction().commit();
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFindAfterQueryWithPessimisticLocks() {
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        em1.getTransaction().begin();
        TypedQuery query = em1.createQuery("select e from Employee e where e.id < 10", Employee.class).setFirstResult(1);
        query.setLockMode(LockModeType.PESSIMISTIC_READ);
        query.setHint("javax.persistence.query.timeout", (Object)this.lockWaitTime);
        List employees = query.getResultList();
        TestPessimisticLocks.assertEquals((String)"Expected 1 element with emplyee id=2", (int)employees.size(), (int)1);
        TestPessimisticLocks.assertTrue((String)"Test Employee first name = 'first.2'", (((Employee)employees.get(0)).getFirstName().equals("first.1") || ((Employee)employees.get(0)).getFirstName().equals("first.2") ? 1 : 0) != 0);
        em2.getTransaction().begin();
        HashMap<String, Integer> hints = new HashMap<String, Integer>();
        hints.put("javax.persistence.lock.timeout", this.lockWaitTime);
        try {
            em2.find(Employee.class, (Object)2, LockModeType.PESSIMISTIC_READ, hints);
            TestPessimisticLocks.fail((String)"Unexcpected find succeeded. Should throw a PessimisticLockException.");
        }
        catch (Throwable e) {
            this.assertError(e, PessimisticLockException.class, LockTimeoutException.class);
        }
        finally {
            if (em1.getTransaction().isActive()) {
                em1.getTransaction().rollback();
            }
            if (em2.getTransaction().isActive()) {
                em2.getTransaction().rollback();
            }
        }
        em1.getTransaction().begin();
        TypedQuery query2 = em1.createQuery("select e.department from Employee e where e.id < 10", Department.class).setFirstResult(1);
        query.setLockMode(LockModeType.PESSIMISTIC_READ);
        query.setHint("javax.persistence.query.timeout", (Object)this.lockWaitTime);
        List depts = query2.getResultList();
        TestPessimisticLocks.assertEquals((String)"Expected 1 element with department id=20", (int)depts.size(), (int)1);
        TestPessimisticLocks.assertTrue((String)"Test department name = 'D20'", (((Department)depts.get(0)).getName().equals("D10") || ((Department)depts.get(0)).getName().equals("D20") ? 1 : 0) != 0);
        em2.getTransaction().begin();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("javax.persistence.lock.timeout", this.lockWaitTime);
        try {
            Employee emp = (Employee)em2.find(Employee.class, (Object)1, LockModeType.PESSIMISTIC_READ, map);
            TestPessimisticLocks.assertNotNull((String)"Query locks department only, therefore should find Employee.", (Object)emp);
            TestPessimisticLocks.assertEquals((String)"Test Employee first name = 'first.1'", (String)emp.getFirstName(), (String)"first.1");
        }
        catch (Exception ex) {
            TestPessimisticLocks.fail((String)("Caught unexpected " + ex.getClass().getName() + ":" + ex.getMessage()));
        }
        finally {
            if (em1.getTransaction().isActive()) {
                em1.getTransaction().rollback();
            }
            if (em2.getTransaction().isActive()) {
                em2.getTransaction().rollback();
            }
        }
        em1.close();
        em2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFindAfterQueryOrderByWithPessimisticLocks() {
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        em1.getTransaction().begin();
        Query query = em1.createQuery("select e from Employee e where e.id < 10 order by e.id").setFirstResult(1);
        query.setLockMode(LockModeType.PESSIMISTIC_READ);
        query.setHint("javax.persistence.query.timeout", (Object)this.lockWaitTime);
        List q = query.getResultList();
        TestPessimisticLocks.assertEquals((String)"Expected 1 element with emplyee id=2", (int)q.size(), (int)1);
        TestPessimisticLocks.assertEquals((String)"Test Employee first name = 'first.2'", (String)((Employee)q.get(0)).getFirstName(), (String)"first.2");
        em2.getTransaction().begin();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("javax.persistence.lock.timeout", this.lockWaitTime);
        try {
            em2.find(Employee.class, (Object)2, LockModeType.PESSIMISTIC_READ, map);
            TestPessimisticLocks.fail((String)"Unexcpected find succeeded. Should throw a PessimisticLockException.");
        }
        catch (Exception e) {
            this.assertError(e, PessimisticLockException.class, LockTimeoutException.class);
        }
        finally {
            if (em1.getTransaction().isActive()) {
                em1.getTransaction().rollback();
            }
            if (em2.getTransaction().isActive()) {
                em2.getTransaction().rollback();
            }
        }
        em1.getTransaction().begin();
        query = em1.createQuery("select e.department from Employee e where e.id < 10 order by e.department.id").setFirstResult(1);
        query.setLockMode(LockModeType.PESSIMISTIC_READ);
        query.setHint("javax.persistence.query.timeout", (Object)this.lockWaitTime);
        List result = query.getResultList();
        TestPessimisticLocks.assertEquals((String)"Expected 1 element with department id=20", (int)q.size(), (int)1);
        TestPessimisticLocks.assertEquals((String)"Test department name = 'D20'", (String)((Department)result.get(0)).getName(), (String)"D20");
        em2.getTransaction().begin();
        map.clear();
        map.put("javax.persistence.lock.timeout", this.lockWaitTime);
        try {
            Employee emp = (Employee)em2.find(Employee.class, (Object)1, LockModeType.PESSIMISTIC_READ, map);
            TestPessimisticLocks.assertNotNull((String)"Query locks department only, therefore should find Employee.", (Object)emp);
            TestPessimisticLocks.assertEquals((String)"Test Employee first name = 'first.1'", (String)emp.getFirstName(), (String)"first.1");
        }
        catch (Exception ex) {
            if (!this.dict.supportsLockingWithOrderClause) {
                TestPessimisticLocks.fail((String)("Caught unexpected " + ex.getClass().getName() + ":" + ex.getMessage()));
            } else {
                this.assertError(ex, LockTimeoutException.class);
            }
        }
        finally {
            if (em1.getTransaction().isActive()) {
                em1.getTransaction().rollback();
            }
            if (em2.getTransaction().isActive()) {
                em2.getTransaction().rollback();
            }
        }
        em1.close();
        em2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryAfterFindWithPessimisticLocks() {
        List q;
        Query query;
        HashMap<String, Integer> map;
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        try {
            em2.getTransaction().begin();
            map = new HashMap<String, Integer>();
            map.put("javax.persistence.lock.timeout", this.lockWaitTime);
            em2.find(Employee.class, (Object)1, LockModeType.PESSIMISTIC_READ, map);
            em1.getTransaction().begin();
            query = em1.createQuery("select e.department from Employee e where e.id < 10").setFirstResult(1);
            query.setLockMode(LockModeType.PESSIMISTIC_READ);
            query.setHint("javax.persistence.query.timeout", (Object)this.lockWaitTime);
            q = query.getResultList();
            TestPessimisticLocks.assertEquals((String)"Expected 1 element with department id=20", (int)q.size(), (int)1);
            TestPessimisticLocks.assertTrue((String)"Test department name = 'D20'", (((Department)q.get(0)).getName().equals("D10") || ((Department)q.get(0)).getName().equals("D20") ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            this.assertError(ex, QueryTimeoutException.class);
        }
        finally {
            if (em1.getTransaction().isActive()) {
                em1.getTransaction().rollback();
            }
            if (em2.getTransaction().isActive()) {
                em2.getTransaction().rollback();
            }
        }
        em2.getTransaction().begin();
        map = new HashMap();
        map.put("javax.persistence.lock.timeout", this.lockWaitTime);
        em2.find(Employee.class, (Object)2, LockModeType.PESSIMISTIC_READ, map);
        em1.getTransaction().begin();
        query = em1.createQuery("select e from Employee e where e.id < 10").setFirstResult(1);
        query.setLockMode(LockModeType.PESSIMISTIC_READ);
        query.setHint("javax.persistence.query.timeout", (Object)this.lockWaitTime);
        try {
            q = query.getResultList();
            TestPessimisticLocks.fail((String)"Unexcpected find succeeded. Should throw a PessimisticLockException.");
        }
        catch (Exception e) {
            this.assertError(e, PessimisticLockException.class, QueryTimeoutException.class);
        }
        finally {
            if (em1.getTransaction().isActive()) {
                em1.getTransaction().rollback();
            }
            if (em2.getTransaction().isActive()) {
                em2.getTransaction().rollback();
            }
        }
        em1.close();
        em2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryOrderByAfterFindWithPessimisticLocks() {
        List q;
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        em2.getTransaction().begin();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("javax.persistence.lock.timeout", this.lockWaitTime);
        em2.find(Employee.class, (Object)1, LockModeType.PESSIMISTIC_READ, map);
        em1.getTransaction().begin();
        Query query = em1.createQuery("select e.department from Employee e where e.id < 10 order by e.department.id").setFirstResult(1);
        query.setLockMode(LockModeType.PESSIMISTIC_READ);
        query.setHint("javax.persistence.query.timeout", (Object)this.lockWaitTime);
        try {
            q = query.getResultList();
            TestPessimisticLocks.assertEquals((String)"Expected 1 element with department id=20", (int)q.size(), (int)1);
            TestPessimisticLocks.assertEquals((String)"Test department name = 'D20'", (String)((Department)q.get(0)).getName(), (String)"D20");
        }
        catch (Exception ex) {
            this.assertError(ex, QueryTimeoutException.class);
        }
        finally {
            if (em1.getTransaction().isActive()) {
                em1.getTransaction().rollback();
            }
            if (em2.getTransaction().isActive()) {
                em2.getTransaction().rollback();
            }
        }
        em2.getTransaction().begin();
        map.clear();
        map.put("javax.persistence.lock.timeout", this.lockWaitTime);
        em2.find(Employee.class, (Object)2, LockModeType.PESSIMISTIC_READ, map);
        em1.getTransaction().begin();
        query = em1.createQuery("select e from Employee e where e.id < 10 order by e.department.id").setFirstResult(1);
        query.setLockMode(LockModeType.PESSIMISTIC_READ);
        query.setHint("javax.persistence.query.timeout", (Object)this.lockWaitTime);
        try {
            q = query.getResultList();
            TestPessimisticLocks.fail((String)"Unexcpected find succeeded. Should throw a PessimisticLockException.");
        }
        catch (Exception e) {
            this.assertError(e, PessimisticLockException.class, QueryTimeoutException.class);
        }
        finally {
            if (em1.getTransaction().isActive()) {
                em1.getTransaction().rollback();
            }
            if (em2.getTransaction().isActive()) {
                em2.getTransaction().rollback();
            }
        }
        em1.close();
        em2.close();
    }

    public void testRepeatedQueryWithPessimisticLocks() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.resetSQL();
        em.getTransaction().begin();
        String jpql = "select e.firstName from Employee e where e.id = 1";
        Query q1 = em.createQuery(jpql);
        q1.setLockMode(LockModeType.PESSIMISTIC_WRITE);
        String firstName1 = (String)q1.getSingleResult();
        String SQL1 = this.getLastSQL(this.sql);
        this.resetSQL();
        Query q2 = em.createQuery(jpql);
        q2.setLockMode(LockModeType.PESSIMISTIC_WRITE);
        String firstName2 = (String)q2.getSingleResult();
        String SQL2 = this.getLastSQL(this.sql);
        TestPessimisticLocks.assertEquals((String)SQL1, (String)SQL2);
        em.getTransaction().commit();
    }

    protected Log getLog() {
        return this.emf.getConfiguration().getLog("Tests");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshLockTimeout() {
        Object props;
        if (!(this.dict instanceof DerbyDictionary || this.dict instanceof DB2Dictionary || this.dict instanceof InformixDictionary)) {
            return;
        }
        if (this.dict instanceof InformixDictionary) {
            InformixDictionary ifxDict = (InformixDictionary)((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance();
            ifxDict.lockModeEnabled = true;
            ifxDict.lockWaitSeconds = 5;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.resetSQL();
        VersionEntity ve = new VersionEntity();
        int veid = new Random().nextInt();
        ve.setId(veid);
        ve.setName("Versioned Entity");
        em.getTransaction().begin();
        em.persist((Object)ve);
        em.getTransaction().commit();
        em.getTransaction().begin();
        ve = (VersionEntity)em.find(VersionEntity.class, (Object)veid);
        TestPessimisticLocks.assertTrue((boolean)em.contains((Object)ve));
        TestPessimisticLocks.assertTrue((em.getLockMode((Object)ve) == LockModeType.NONE ? 1 : 0) != 0);
        em.getTransaction().commit();
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future<Boolean> result = executor.submit(new RefreshWithLock(veid, (Object)this));
        try {
            this.getLog().trace((Object)"Main: waiting");
            TestPessimisticLocks testPessimisticLocks = this;
            synchronized (testPessimisticLocks) {
                ((Object)((Object)this)).wait(70000L);
            }
            this.getLog().trace((Object)"Main: done waiting");
            props = new HashMap<String, Integer>();
            if (!(this.dict instanceof InformixDictionary)) {
                props.put("javax.persistence.lock.timeout", 5000);
            }
            em.getTransaction().begin();
            this.getLog().trace((Object)"Main: refresh with force increment");
            em.refresh((Object)ve, LockModeType.PESSIMISTIC_FORCE_INCREMENT, props);
            this.getLog().trace((Object)"Main: commit");
            em.getTransaction().commit();
            this.getLog().trace((Object)"Main: done commit");
            TestPessimisticLocks.fail((String)"Expected LockTimeoutException");
        }
        catch (Throwable t) {
            this.getLog().trace((Object)("Main: exception - " + t.getMessage()), t);
            TestPessimisticLocks.assertTrue((boolean)(t instanceof LockTimeoutException));
        }
        finally {
            try {
                props = this;
                synchronized (props) {
                    ((Object)((Object)this)).notify();
                }
                result.get();
            }
            catch (Throwable t) {
                TestPessimisticLocks.fail((String)("Caught throwable waiting for thread finish: " + t));
            }
        }
    }

    void assertError(Throwable actual, Class<? extends Throwable> ... expected) {
        boolean matched = false;
        String expectedNames = "";
        for (Class<? extends Throwable> aExpected : expected) {
            expectedNames = expectedNames + aExpected.getName() + ", ";
            if (!aExpected.isAssignableFrom(actual.getClass())) continue;
            matched = true;
        }
        if (!matched) {
            actual.printStackTrace();
            throw new AssertionFailedError(actual.getClass().getName() + " was raised but expecting one of the following: [" + expectedNames.substring(0, expectedNames.length() - 2) + "]");
        }
        Object failed = this.getFailedObject(actual);
        TestPessimisticLocks.assertNotNull((String)"Failed object is null", (Object)failed);
        TestPessimisticLocks.assertNotEquals((Object)"null", (Object)failed);
    }

    Object getFailedObject(Throwable e) {
        if (e instanceof LockTimeoutException) {
            return ((LockTimeoutException)e).getObject();
        }
        if (e instanceof PessimisticLockException) {
            return ((PessimisticLockException)e).getEntity();
        }
        if (e instanceof QueryTimeoutException) {
            return ((QueryTimeoutException)e).getQuery();
        }
        if (e instanceof OpenJPAException) {
            return ((OpenJPAException)e).getFailedObject();
        }
        return null;
    }

    public class RefreshWithLock
    implements Callable<Boolean> {
        private int _id;
        private Object _monitor;

        public RefreshWithLock(int id, Object monitor) {
            this._id = id;
            this._monitor = monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            try {
                OpenJPAEntityManagerSPI em = TestPessimisticLocks.this.emf.createEntityManager();
                em.getTransaction().begin();
                VersionEntity ve = (VersionEntity)em.find(VersionEntity.class, (Object)this._id, LockModeType.PESSIMISTIC_FORCE_INCREMENT);
                TestCase.assertTrue((em.getLockMode((Object)ve) == LockModeType.PESSIMISTIC_FORCE_INCREMENT ? 1 : 0) != 0);
                TestPessimisticLocks.this.getLog().trace((Object)"Thread: wake up main thread");
                Object object = this._monitor;
                synchronized (object) {
                    this._monitor.notify();
                }
                try {
                    TestPessimisticLocks.this.getLog().trace((Object)"Thread: waiting up to 120 secs for notify");
                    object = this._monitor;
                    synchronized (object) {
                        this._monitor.wait(120000L);
                    }
                    TestPessimisticLocks.this.getLog().trace((Object)"Thread: done waiting");
                }
                catch (Throwable t) {
                    TestPessimisticLocks.this.getLog().trace((Object)"Unexpected thread interrupt", t);
                }
                em.getTransaction().commit();
                em.close();
                TestPessimisticLocks.this.getLog().trace((Object)"Thread: done");
            }
            catch (Throwable t) {
                TestPessimisticLocks.this.getLog().trace((Object)("Thread: caught - " + t.getMessage()), t);
            }
            return Boolean.TRUE;
        }
    }
}

