/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.lockmgr;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.persistence.LockModeType;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.lockmgr.LockEmployeeNonVersion;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestMixedLockManagerNonVersion
extends SQLListenerTestCase {
    private String empTableName;

    protected String getPersistenceUnitName() {
        return "locking-test";
    }

    public void setUp() {
        this.setUp(new Object[]{LockEmployeeNonVersion.class, "openjpa.LockManager", "mixed", "openjpa.Optimistic", "false"});
        this.commonSetUp();
    }

    public void testFindNonVersionWithLock() {
        this.commonFindNonVerWithLock(LockModeType.NONE);
        this.commonFindNonVerWithLock(LockModeType.READ);
        this.commonFindNonVerWithLock(LockModeType.WRITE);
        this.commonFindNonVerWithLock(LockModeType.OPTIMISTIC);
        this.commonFindNonVerWithLock(LockModeType.OPTIMISTIC_FORCE_INCREMENT);
        this.commonFindNonVerWithLock(LockModeType.PESSIMISTIC_READ);
        this.commonFindNonVerWithLock(LockModeType.PESSIMISTIC_WRITE);
        this.commonFindNonVerWithLock(LockModeType.PESSIMISTIC_FORCE_INCREMENT);
    }

    private void commonFindNonVerWithLock(LockModeType lockMode) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        LockEmployeeNonVersion emp = (LockEmployeeNonVersion)em.find(LockEmployeeNonVersion.class, (Object)1, lockMode);
        TestMixedLockManagerNonVersion.assertNotNull((Object)emp);
        String lastLastName = emp.getLastName();
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        emp = (LockEmployeeNonVersion)em.find(LockEmployeeNonVersion.class, (Object)1);
        TestMixedLockManagerNonVersion.assertNotNull((Object)emp);
        TestMixedLockManagerNonVersion.assertEquals((String)lastLastName, (String)emp.getLastName());
        emp = (LockEmployeeNonVersion)em.find(LockEmployeeNonVersion.class, (Object)1, lockMode);
        emp.setLastName(lockMode.toString());
        em.getTransaction().commit();
        emp = (LockEmployeeNonVersion)em.find(LockEmployeeNonVersion.class, (Object)1);
        TestMixedLockManagerNonVersion.assertNotNull((Object)emp);
        TestMixedLockManagerNonVersion.assertEquals((String)lockMode.toString(), (String)emp.getLastName());
        em.close();
    }

    public void testLockNonVersionWithLock() {
        this.commonLockNonVerWithLock(LockModeType.NONE);
        this.commonLockNonVerWithLock(LockModeType.READ);
        this.commonLockNonVerWithLock(LockModeType.WRITE);
        this.commonLockNonVerWithLock(LockModeType.OPTIMISTIC);
        this.commonLockNonVerWithLock(LockModeType.OPTIMISTIC_FORCE_INCREMENT);
        this.commonLockNonVerWithLock(LockModeType.PESSIMISTIC_READ);
        this.commonLockNonVerWithLock(LockModeType.PESSIMISTIC_WRITE);
        this.commonLockNonVerWithLock(LockModeType.PESSIMISTIC_FORCE_INCREMENT);
    }

    private void commonLockNonVerWithLock(LockModeType lockMode) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        LockEmployeeNonVersion emp = (LockEmployeeNonVersion)em.find(LockEmployeeNonVersion.class, (Object)1);
        TestMixedLockManagerNonVersion.assertNotNull((Object)emp);
        em.lock((Object)emp, lockMode);
        String lastLastName = emp.getLastName();
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        emp = (LockEmployeeNonVersion)em.find(LockEmployeeNonVersion.class, (Object)1);
        TestMixedLockManagerNonVersion.assertNotNull((Object)emp);
        TestMixedLockManagerNonVersion.assertEquals((String)lastLastName, (String)emp.getLastName());
        emp = (LockEmployeeNonVersion)em.find(LockEmployeeNonVersion.class, (Object)2);
        em.lock((Object)emp, lockMode);
        emp.setLastName(lockMode.toString());
        em.getTransaction().commit();
        emp = (LockEmployeeNonVersion)em.find(LockEmployeeNonVersion.class, (Object)2);
        TestMixedLockManagerNonVersion.assertNotNull((Object)emp);
        TestMixedLockManagerNonVersion.assertEquals((String)lockMode.toString(), (String)emp.getLastName());
        em.close();
    }

    public void testRefreshNonVersionWithLock() {
        this.commonRefreshNonVerWithLock(LockModeType.NONE);
        this.commonRefreshNonVerWithLock(LockModeType.READ);
        this.commonRefreshNonVerWithLock(LockModeType.WRITE);
        this.commonRefreshNonVerWithLock(LockModeType.OPTIMISTIC);
        this.commonRefreshNonVerWithLock(LockModeType.OPTIMISTIC_FORCE_INCREMENT);
        this.commonRefreshNonVerWithLock(LockModeType.PESSIMISTIC_READ);
        this.commonRefreshNonVerWithLock(LockModeType.PESSIMISTIC_WRITE);
        this.commonRefreshNonVerWithLock(LockModeType.PESSIMISTIC_FORCE_INCREMENT);
    }

    private void commonRefreshNonVerWithLock(LockModeType lockMode) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        LockEmployeeNonVersion emp = (LockEmployeeNonVersion)em.find(LockEmployeeNonVersion.class, (Object)1);
        TestMixedLockManagerNonVersion.assertNotNull((Object)emp);
        String lastLastName = emp.getLastName();
        em.refresh((Object)emp, lockMode);
        TestMixedLockManagerNonVersion.assertEquals((String)lastLastName, (String)emp.getLastName());
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        emp = (LockEmployeeNonVersion)em.find(LockEmployeeNonVersion.class, (Object)1);
        TestMixedLockManagerNonVersion.assertNotNull((Object)emp);
        TestMixedLockManagerNonVersion.assertEquals((String)lastLastName, (String)emp.getLastName());
        emp = (LockEmployeeNonVersion)em.find(LockEmployeeNonVersion.class, (Object)3);
        em.refresh((Object)emp, lockMode);
        emp.setLastName(lockMode.toString());
        em.getTransaction().commit();
        emp = (LockEmployeeNonVersion)em.find(LockEmployeeNonVersion.class, (Object)3);
        TestMixedLockManagerNonVersion.assertNotNull((Object)emp);
        TestMixedLockManagerNonVersion.assertEquals((String)lockMode.toString(), (String)emp.getLastName());
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commonSetUp() {
        this.empTableName = this.getMapping(LockEmployeeNonVersion.class).getTable().getFullName();
        this.cleanupDB();
        LockEmployeeNonVersion e1 = this.newEmployee(1);
        LockEmployeeNonVersion e2 = this.newEmployee(2);
        LockEmployeeNonVersion e3 = this.newEmployee(3);
        this.resetSQL();
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)e1);
            em.persist((Object)e2);
            em.persist((Object)e3);
            em.getTransaction().commit();
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        this.assertAllSQLInOrder(new String[]{"INSERT INTO " + this.empTableName + " .*"});
    }

    private void cleanupDB() {
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.createQuery("delete from " + this.empTableName).executeUpdate();
            em.getTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    private LockEmployeeNonVersion newEmployee(int id) {
        LockEmployeeNonVersion e = new LockEmployeeNonVersion();
        e.setId(id);
        return e;
    }

    protected Log getLog() {
        return this.emf.getConfiguration().getLog("Tests");
    }

    protected Log getDumpStackLog() {
        return this.emf.getConfiguration().getLog("DumpStack");
    }

    protected void logStack(Throwable t) {
        StringWriter str = new StringWriter();
        PrintWriter print = new PrintWriter(str);
        t.printStackTrace(print);
        this.getDumpStackLog().trace((Object)str.toString());
    }
}

