/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.lockmgr;

import java.util.Arrays;
import javax.persistence.LockModeType;
import org.apache.openjpa.persistence.lockmgr.LockEmployee;
import org.apache.openjpa.persistence.lockmgr.SequencedActionsTest;

public class TestMixedLockManagerFindPermutation
extends SequencedActionsTest {
    public void setUp() {
        this.setUp(new Object[]{LockEmployee.class, "openjpa.LockManager", "mixed"});
        this.commonSetUp();
    }

    public void testFindReadRead() {
        this.commonFindTest("testFind(Read,Commit/Read,Commit)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass);
        this.commonFindTest("testFind(Read,Commit/Read,Rollback)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.RollbackTx, 1, null);
    }

    public void testFindReadWrite() {
        this.commonFindTest("testFind(Read,Commit/Write,Commit)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass);
        this.commonFindTest("testFind(Read,Commit/Write,Rollback)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.RollbackTx, 1, null);
    }

    public void testFindReadPessimisticRead() {
        this.commonFindTest("testFind(Read,Commit/PessimisticRead,Commit)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null);
        this.commonFindTest("testFind(Read,Commit/PessimisticRead,Rollback)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.RollbackTx, 1, null);
    }

    public void testFindReadPessimisticWrite() {
        this.commonFindTest("testFind(Read,Commit/PessimisticWrite,Commit)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null);
        this.commonFindTest("testFind(Read,Commit/PessimisticWrite,Rollback)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.RollbackTx, 1, null);
    }

    public void testFindReadPessimisticForceInc() {
        this.commonFindTest("testFind(Read,Commit/PessimisticForceInc,Commit)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null);
        this.commonFindTest("testFind(Read,Commit/PessimisticForceInc,Rollback)", LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.RollbackTx, 1, null);
    }

    public void testFindWriteRead() {
        this.commonFindTest("testFind(Write,Commit/Read,Commit)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass);
        this.commonFindTest("testFind(Write,Commit/Read,Rollback)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.RollbackTx, 1, null);
    }

    public void testFindWriteWrite() {
        this.commonFindTest("testFind(Write,Commit/Write,Commit)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass);
        this.commonFindTest("testFind(Write,Commit/Write,Rollback)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.RollbackTx, 1, null);
    }

    public void testFindWritePessimisticRead() {
        this.commonFindTest("testFind(Write,Commit/PessimisticRead,Commit)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null);
        this.commonFindTest("testFind(Write,Commit/PessimisticRead,Rollback)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.RollbackTx, 1, null);
    }

    public void testFindWritePessimisticWrite() {
        this.commonFindTest("testFind(Write,Commit/PessimisticWrite,Commit)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null);
        this.commonFindTest("testFind(Write,Commit/PessimisticWrite,Rollback)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.RollbackTx, 1, null);
    }

    public void testFindWritePessimisticForceInc() {
        this.commonFindTest("testFind(Write,Commit/PessimisticForceInc,Commit)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null);
        this.commonFindTest("testFind(Write,Commit/PessimisticForceInc,Rollback)", LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.RollbackTx, 1, null);
    }

    public void testFindPessimisticReadRead() {
        this.commonFindTest("testFind(PessimisticRead,Commit/Read,Commit)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass);
        this.commonFindTest("testFind(PessimisticRead,Commit/Read,Rollback)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.RollbackTx, 1, null);
    }

    public void testFindPessimisticReadWrite() {
        this.commonFindTest("testFind(PessimisticRead,Commit/Write,Commit)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass);
        this.commonFindTest("testFind(PessimisticRead,Commit/Write,Rollback)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.RollbackTx, 1, null);
    }

    public void testFindPessimisticReadPessimisticRead() {
        this.commonFindTest("testFind(PessimisticRead,Commit/PessimisticRead,Commit)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null);
        this.commonFindTest("testFind(PessimisticRead,Commit/PessimisticRead,Rollback)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.RollbackTx, 0, null);
    }

    public void testFindPessimisticReadPessimisticWrite() {
        this.commonFindTest("testFind(PessimisticRead,Commit/PessimisticWrite,Commit)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null);
        this.commonFindTest("testFind(PessimisticRead,Commit/PessimisticWrite,Rollback)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.RollbackTx, 0, null);
    }

    public void testFindPessimisticReadPessimisticForceInc() {
        this.commonFindTest("testFind(PessimisticRead,Commit/PessimisticForceInc,Commit)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null);
        this.commonFindTest("testFind(PessimisticRead,Commit/PessimisticForceInc,Rollback)", LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.RollbackTx, 0, null);
    }

    public void testFindPessimsiticWriteRead() {
        this.commonFindTest("testFind(PessimsiticWrite,Commit/Read,Commit)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass);
        this.commonFindTest("testFind(PessimsiticWrite,Commit/Read,Rollback)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.RollbackTx, 1, null);
    }

    public void testFindPessimsiticWriteWrite() {
        this.commonFindTest("testFind(PessimsiticWrite,Commit/Write,Commit)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass);
        this.commonFindTest("testFind(PessimsiticWrite,Commit/Write,Rollback)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.RollbackTx, 1, null);
    }

    public void testFindPessimsiticWritePessimisticRead() {
        this.commonFindTest("testFind(PessimsiticWrite,Commit/PessimisticRead,Commit)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null);
        this.commonFindTest("testFind(PessimsiticWrite,Commit/PessimisticRead,Rollback)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.RollbackTx, 0, null);
    }

    public void testFindPessimsiticWritePessimisticWrite() {
        this.commonFindTest("testFind(PessimsiticWrite,Commit/PessimisticWrite,Commit)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null);
        this.commonFindTest("testFind(PessimsiticWrite,Commit/PessimisticWrite,Rollback)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.RollbackTx, 0, null);
    }

    public void testFindPessimsiticWritePessimisticForceInc() {
        this.commonFindTest("testFind(PessimsiticWrite,Commit/PessimisticForceInc,Commit)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null);
        this.commonFindTest("testFind(PessimsiticWrite,Commit/PessimisticForceInc,Rollback)", LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.RollbackTx, 0, null);
    }

    public void testFindPessimsiticForceIncRead() {
        this.commonFindTest("testFind(PessimsiticForceInc,Commit/Read,Commit)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass);
        this.commonFindTest("testFind(PessimsiticForceInc,Commit/Read,Rollback)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.READ, SequencedActionsTest.Act.RollbackTx, 1, null);
    }

    public void testFindPessimsiticForceIncWrite() {
        this.commonFindTest("testFind(PessimsiticForceInc,Commit/Write,Commit)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.CommitTx, 1, ExpectingOptimisticLockExClass);
        this.commonFindTest("testFind(PessimsiticForceInc,Commit/Write,Rollback)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.WRITE, SequencedActionsTest.Act.RollbackTx, 1, null);
    }

    public void testFindPessimsiticForceIncPessimisticRead() {
        this.commonFindTest("testFind(PessimsiticForceInc,Commit/PessimisticRead,Commit)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.CommitTx, 1, null);
        this.commonFindTest("testFind(PessimsiticForceInc,Commit/PessimisticRead,Rollback)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_READ, SequencedActionsTest.Act.RollbackTx, 0, null);
    }

    public void testFindPessimsiticForceIncPessimisticWrite() {
        this.commonFindTest("testFind(PessimsiticForceInc,Commit/PessimisticWrite,Commit)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.CommitTx, 1, null);
        this.commonFindTest("testFind(PessimsiticForceInc,Commit/PessimisticWrite,Rollback)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_WRITE, SequencedActionsTest.Act.RollbackTx, 0, null);
    }

    public void testFindPessimsiticForceIncPessimisticForceInc() {
        this.commonFindTest("testFind(PessimsiticForceInc,Commit/PessimisticForceInc,Commit)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null);
        this.commonFindTest("testFind(PessimsiticForceInc,Commit/PessimisticForceInc,Rollback)", LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.CommitTx, 1, null, LockModeType.PESSIMISTIC_FORCE_INCREMENT, SequencedActionsTest.Act.RollbackTx, 0, null);
    }

    private void commonFindTest(String testName, LockModeType t1Lock, SequencedActionsTest.Act t1IsCommit, int t1VersionInc, Class<?>[] t1Exceptions, LockModeType t2Lock, SequencedActionsTest.Act t2IsCommit, int t2VersionInc, Class<?>[] t2Exceptions) {
        String[] parameters = new String[]{"Thread 1: lock= " + t1Lock + ", isCommit= " + (Object)((Object)t1IsCommit) + ", versionInc= +" + t1VersionInc + ", expectedEx= " + Arrays.toString(t1Exceptions), "Thread 2: lock= " + t2Lock + ", isCommit= " + (Object)((Object)t2IsCommit) + ", versionInc= +" + t2VersionInc + ", expectedEx= " + Arrays.toString(t2Exceptions)};
        Object[][] threadMain = new Object[][]{{SequencedActionsTest.Act.CreateEm}, {SequencedActionsTest.Act.Find}, {SequencedActionsTest.Act.SaveVersion}, {SequencedActionsTest.Act.TestEmployee, 1, "Def FirstName"}, {SequencedActionsTest.Act.CloseEm}, {SequencedActionsTest.Act.Sleep, 100}, {SequencedActionsTest.Act.CreateEm}, {SequencedActionsTest.Act.StartTx}, {SequencedActionsTest.Act.FindWithLock, 1, t1Lock}, {SequencedActionsTest.Act.SaveVersion}, {SequencedActionsTest.Act.TestException}, {SequencedActionsTest.Act.NewThread, 1}, {SequencedActionsTest.Act.StartThread, 1}, {SequencedActionsTest.Act.Wait}, {SequencedActionsTest.Act.UpdateEmployee}, {t1IsCommit}, {SequencedActionsTest.Act.Notify, 1}, {SequencedActionsTest.Act.Find}, {SequencedActionsTest.Act.WaitAllChildren}, {SequencedActionsTest.Act.Find}, {SequencedActionsTest.Act.TestEmployee, 1, null, t1VersionInc}, {SequencedActionsTest.Act.TestException, 0, t1Exceptions}, {SequencedActionsTest.Act.TestException, 1, t2Exceptions}, {SequencedActionsTest.Act.CloseEm}};
        Object[][] thread1 = new Object[][]{{SequencedActionsTest.Act.CreateEm}, {SequencedActionsTest.Act.StartTx}, {SequencedActionsTest.Act.FindWithLock, 1, t2Lock}, {SequencedActionsTest.Act.SaveVersion}, {SequencedActionsTest.Act.TestException}, {SequencedActionsTest.Act.Notify, 0}, {SequencedActionsTest.Act.Wait}, {SequencedActionsTest.Act.Sleep, 2000}, {SequencedActionsTest.Act.UpdateEmployee}, {t2IsCommit}, {SequencedActionsTest.Act.Sleep, 1000}, {SequencedActionsTest.Act.Find}, {SequencedActionsTest.Act.TestEmployee, 1, null, t2VersionInc}, {SequencedActionsTest.Act.CloseEm}};
        this.launchActionSequence(testName, parameters, threadMain, thread1);
    }
}

