/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.lockmgr;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.persistence.LockModeType;
import javax.persistence.PessimisticLockScope;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.lockmgr.Person;
import org.apache.openjpa.persistence.lockmgr.PhoneNumber;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestLocking
extends SQLListenerTestCase {
    String _phone = "5075555555";

    protected String getPersistenceUnitName() {
        return "locking-test";
    }

    public void setUp() {
        super.setUp(new Object[]{CLEAR_TABLES, Person.class, PhoneNumber.class});
        this.populate();
    }

    public void testExtendedLockScope() throws Exception {
        HashMap<String, PessimisticLockScope> props = new HashMap<String, PessimisticLockScope>();
        props.put("javax.persistence.lock.scope", PessimisticLockScope.EXTENDED);
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        CommitterThread committer = new CommitterThread(em2);
        em1.getTransaction().begin();
        Person e1 = (Person)em1.find(Person.class, (Object)1);
        TestLocking.assertEquals((int)1, (int)e1.getPhoneNumbers().size());
        em1.refresh((Object)e1, LockModeType.PESSIMISTIC_FORCE_INCREMENT, props);
        committer.start();
        while (System.currentTimeMillis() - committer.sleepStartTime < 5000L) {
            Thread.sleep(5000L);
        }
        TestLocking.assertFalse((boolean)committer.commitComplete);
        em1.getTransaction().commit();
        em1.close();
        committer.join();
    }

    private void populate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        PhoneNumber p = new PhoneNumber(this._phone);
        List<PhoneNumber> numbers = Arrays.asList(p);
        Person e1 = new Person();
        e1.setId(1);
        e1.setPhoneNumbers(numbers);
        Person e2 = new Person();
        e2.setId(2);
        e2.setPhoneNumbers(numbers);
        p.setOwners(Arrays.asList(e1, e2));
        em.persist((Object)e1);
        em.persist((Object)e2);
        em.persist((Object)p);
        em.getTransaction().commit();
        em.close();
    }

    private class CommitterThread
    extends Thread {
        OpenJPAEntityManagerSPI _em2;
        boolean inCommit = false;
        boolean commitComplete = false;
        long sleepStartTime = Long.MAX_VALUE;

        public CommitterThread(OpenJPAEntityManagerSPI e) {
            this._em2 = e;
        }

        @Override
        public void run() {
            this._em2.getTransaction().begin();
            PhoneNumber phoneNumber = (PhoneNumber)this._em2.find(PhoneNumber.class, (Object)TestLocking.this._phone);
            this._em2.remove((Object)phoneNumber);
            this.inCommit = true;
            this.sleepStartTime = System.currentTimeMillis();
            this._em2.getTransaction().commit();
            this.commitComplete = true;
            this._em2.close();
        }
    }
}

