/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.lockmgr;

import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfigurationImpl;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.FetchDirection;
import org.apache.openjpa.persistence.jdbc.FetchMode;
import org.apache.openjpa.persistence.jdbc.IsolationLevel;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;
import org.apache.openjpa.persistence.jdbc.JoinSyntax;
import org.apache.openjpa.persistence.jdbc.LRSSizeAlgorithm;
import org.apache.openjpa.persistence.jdbc.ResultSetType;
import org.apache.openjpa.persistence.lockmgr.LockEmployee;
import org.apache.openjpa.persistence.lockmgr.SequencedActionsTest;

public class TestFetchHints
extends SequencedActionsTest {
    public void setUp() {
        this.setUp(new Object[]{LockEmployee.class, "openjpa.LockManager", "mixed"});
        this.commonSetUp();
    }

    public void testFetchBatchSizeHint() {
        String hintName = "openjpa.FetchBatchSize";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.fetchBatchSizeHintTest(fPlan, fConfig, hintName, "-1", -1);
        this.fetchBatchSizeHintTest(fPlan, fConfig, hintName, -1, -1);
        this.fetchBatchSizeHintTest(fPlan, fConfig, hintName, "100", 100);
        this.fetchBatchSizeHintTest(fPlan, fConfig, hintName, 100, 100);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"xxxxx");
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setFetchBatchSize(999);
            fPlan.setHint(hintName, (Object)-99);
            TestFetchHints.assertEquals((int)fPlan.getFetchBatchSize(), (int)-1);
        }
        catch (Exception e) {
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.close();
    }

    public void testFetchPlanFetchBatchSizeHint() {
        String hintName = "openjpa.FetchPlan.FetchBatchSize";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.fetchBatchSizeHintTest(fPlan, fConfig, hintName, "0", 0);
        this.fetchBatchSizeHintTest(fPlan, fConfig, hintName, 0, 0);
        this.fetchBatchSizeHintTest(fPlan, fConfig, hintName, "500", 500);
        this.fetchBatchSizeHintTest(fPlan, fConfig, hintName, 500, 500);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setFetchBatchSize(999);
            fPlan.setHint(hintName, (Object)-99);
            TestFetchHints.assertEquals((int)fPlan.getFetchBatchSize(), (int)-1);
        }
        catch (Exception e) {
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.close();
    }

    private void fetchBatchSizeHintTest(JDBCFetchPlan fPlan, JDBCFetchConfigurationImpl fConfig, String hint, Object value, int expected) {
        fConfig.setFetchBatchSize(999);
        fPlan.setHint(hint, value);
        Object getValue = fPlan.getHint(hint);
        TestFetchHints.assertEquals(value.getClass(), getValue.getClass());
        TestFetchHints.assertEquals((Object)value, (Object)getValue);
        TestFetchHints.assertEquals((int)expected, (int)fPlan.getFetchBatchSize());
        TestFetchHints.assertEquals((int)expected, (int)fConfig.getFetchBatchSize());
    }

    public void testFetchPlanEagerFetchModeHint() {
        String hintName = "openjpa.FetchPlan.EagerFetchMode";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.eagerFetchModeHintTest(fPlan, fConfig, hintName, "none", FetchMode.NONE, 0);
        this.eagerFetchModeHintTest(fPlan, fConfig, hintName, FetchMode.NONE.name(), FetchMode.NONE, 0);
        this.eagerFetchModeHintTest(fPlan, fConfig, hintName, FetchMode.NONE, FetchMode.NONE, 0);
        this.eagerFetchModeHintTest(fPlan, fConfig, hintName, "parallel", FetchMode.PARALLEL, 2);
        this.eagerFetchModeHintTest(fPlan, fConfig, hintName, FetchMode.PARALLEL.name(), FetchMode.PARALLEL, 2);
        this.eagerFetchModeHintTest(fPlan, fConfig, hintName, FetchMode.PARALLEL, FetchMode.PARALLEL, 2);
        this.eagerFetchModeHintTest(fPlan, fConfig, hintName, "join", FetchMode.JOIN, 1);
        this.eagerFetchModeHintTest(fPlan, fConfig, hintName, FetchMode.JOIN.name(), FetchMode.JOIN, 1);
        this.eagerFetchModeHintTest(fPlan, fConfig, hintName, FetchMode.JOIN, FetchMode.JOIN, 1);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-2);
            fPlan.setHint(hintName, (Object)-3);
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        em.close();
    }

    public void testJdbcEagerFetchModeHint() {
        String hintName = "openjpa.jdbc.EagerFetchMode";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.eagerFetchModeHintTest(fPlan, fConfig, hintName, String.valueOf(0), FetchMode.NONE, 0);
        this.eagerFetchModeHintTest(fPlan, fConfig, hintName, 0, FetchMode.NONE, 0);
        this.eagerFetchModeHintTest(fPlan, fConfig, hintName, 2, FetchMode.PARALLEL, 2);
        this.eagerFetchModeHintTest(fPlan, fConfig, hintName, String.valueOf(2), FetchMode.PARALLEL, 2);
        this.eagerFetchModeHintTest(fPlan, fConfig, hintName, String.valueOf(1), FetchMode.JOIN, 1);
        this.eagerFetchModeHintTest(fPlan, fConfig, hintName, 1, FetchMode.JOIN, 1);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-1);
            fPlan.setHint(hintName, (Object)-2);
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-99);
            TestFetchHints.assertEquals((Object)fPlan.getEagerFetchMode(), (Object)FetchMode.PARALLEL);
        }
        catch (Exception e) {
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.close();
    }

    private void eagerFetchModeHintTest(JDBCFetchPlan fPlan, JDBCFetchConfigurationImpl fConfig, String hint, Object value, Object expectedValue, int expected) {
        fPlan.setHint(hint, value);
        Object getValue = fPlan.getHint(hint);
        TestFetchHints.assertEquals(value.getClass(), getValue.getClass());
        TestFetchHints.assertEquals((Object)value, (Object)getValue);
        TestFetchHints.assertEquals((Object)expectedValue, (Object)fPlan.getEagerFetchMode());
        TestFetchHints.assertEquals((int)expected, (int)fConfig.getEagerFetchMode());
    }

    public void testFetchPlanJoinSyntaxHint() {
        String hintName = "openjpa.FetchPlan.JoinSyntax";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.joinSyntaxHintTest(fPlan, fConfig, hintName, "sql92", JoinSyntax.SQL92, 0);
        this.joinSyntaxHintTest(fPlan, fConfig, hintName, JoinSyntax.SQL92.name(), JoinSyntax.SQL92, 0);
        this.joinSyntaxHintTest(fPlan, fConfig, hintName, JoinSyntax.SQL92, JoinSyntax.SQL92, 0);
        this.joinSyntaxHintTest(fPlan, fConfig, hintName, "traditional", JoinSyntax.TRADITIONAL, 1);
        this.joinSyntaxHintTest(fPlan, fConfig, hintName, JoinSyntax.TRADITIONAL.name(), JoinSyntax.TRADITIONAL, 1);
        this.joinSyntaxHintTest(fPlan, fConfig, hintName, JoinSyntax.TRADITIONAL, JoinSyntax.TRADITIONAL, 1);
        this.joinSyntaxHintTest(fPlan, fConfig, hintName, "database", JoinSyntax.DATABASE, 2);
        this.joinSyntaxHintTest(fPlan, fConfig, hintName, JoinSyntax.DATABASE.name(), JoinSyntax.DATABASE, 2);
        this.joinSyntaxHintTest(fPlan, fConfig, hintName, JoinSyntax.DATABASE, JoinSyntax.DATABASE, 2);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-1);
            fPlan.setHint(hintName, (Object)-2);
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        em.close();
    }

    public void testJdbcJoinSyntaxHint() {
        String hintName = "openjpa.jdbc.JoinSyntax";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.joinSyntaxHintTest(fPlan, fConfig, hintName, String.valueOf(0), JoinSyntax.SQL92, 0);
        this.joinSyntaxHintTest(fPlan, fConfig, hintName, 0, JoinSyntax.SQL92, 0);
        this.joinSyntaxHintTest(fPlan, fConfig, hintName, String.valueOf(1), JoinSyntax.TRADITIONAL, 1);
        this.joinSyntaxHintTest(fPlan, fConfig, hintName, 1, JoinSyntax.TRADITIONAL, 1);
        this.joinSyntaxHintTest(fPlan, fConfig, hintName, String.valueOf(2), JoinSyntax.DATABASE, 2);
        this.joinSyntaxHintTest(fPlan, fConfig, hintName, 2, JoinSyntax.DATABASE, 2);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-1);
            fPlan.setHint(hintName, (Object)-2);
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-99);
            TestFetchHints.assertEquals((int)fConfig.getJoinSyntax(), (int)((JDBCConfiguration)fConfig.getContext().getConfiguration()).getDBDictionaryInstance().joinSyntax);
        }
        catch (Exception e) {
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.close();
    }

    private void joinSyntaxHintTest(JDBCFetchPlan fPlan, JDBCFetchConfigurationImpl fConfig, String hint, Object value, Object expectedValue, int expected) {
        fPlan.setHint(hint, value);
        Object getValue = fPlan.getHint(hint);
        TestFetchHints.assertEquals(value.getClass(), getValue.getClass());
        TestFetchHints.assertEquals((Object)value, (Object)getValue);
        TestFetchHints.assertEquals((Object)expectedValue, (Object)fPlan.getJoinSyntax());
        TestFetchHints.assertEquals((int)expected, (int)fConfig.getJoinSyntax());
    }

    public void testFetchPlanFetchDirectionHint() {
        String hintName = "openjpa.FetchPlan.FetchDirection";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.fetchDirectionHintTest(fPlan, fConfig, hintName, "forward", FetchDirection.FORWARD, 1000);
        this.fetchDirectionHintTest(fPlan, fConfig, hintName, FetchDirection.FORWARD.name(), FetchDirection.FORWARD, 1000);
        this.fetchDirectionHintTest(fPlan, fConfig, hintName, FetchDirection.FORWARD, FetchDirection.FORWARD, 1000);
        this.fetchDirectionHintTest(fPlan, fConfig, hintName, "reverse", FetchDirection.REVERSE, 1001);
        this.fetchDirectionHintTest(fPlan, fConfig, hintName, FetchDirection.REVERSE.name(), FetchDirection.REVERSE, 1001);
        this.fetchDirectionHintTest(fPlan, fConfig, hintName, FetchDirection.REVERSE, FetchDirection.REVERSE, 1001);
        this.fetchDirectionHintTest(fPlan, fConfig, hintName, "unknown", FetchDirection.UNKNOWN, 1002);
        this.fetchDirectionHintTest(fPlan, fConfig, hintName, FetchDirection.UNKNOWN.name(), FetchDirection.UNKNOWN, 1002);
        this.fetchDirectionHintTest(fPlan, fConfig, hintName, FetchDirection.UNKNOWN, FetchDirection.UNKNOWN, 1002);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-1);
            fPlan.setHint(hintName, (Object)-2);
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        em.close();
    }

    public void testJdbcFetchDirectionHint() {
        String hintName = "openjpa.jdbc.FetchDirection";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.fetchDirectionHintTest(fPlan, fConfig, hintName, String.valueOf(1000), FetchDirection.FORWARD, 1000);
        this.fetchDirectionHintTest(fPlan, fConfig, hintName, 1000, FetchDirection.FORWARD, 1000);
        this.fetchDirectionHintTest(fPlan, fConfig, hintName, String.valueOf(1001), FetchDirection.REVERSE, 1001);
        this.fetchDirectionHintTest(fPlan, fConfig, hintName, 1001, FetchDirection.REVERSE, 1001);
        this.fetchDirectionHintTest(fPlan, fConfig, hintName, String.valueOf(1002), FetchDirection.UNKNOWN, 1002);
        this.fetchDirectionHintTest(fPlan, fConfig, hintName, 1002, FetchDirection.UNKNOWN, 1002);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-1);
            fPlan.setHint(hintName, (Object)-2);
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-99);
            TestFetchHints.assertEquals((int)fConfig.getFetchDirection(), (int)1000);
        }
        catch (Exception e) {
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.close();
    }

    private void fetchDirectionHintTest(JDBCFetchPlan fPlan, JDBCFetchConfigurationImpl fConfig, String hint, Object value, Object expectedValue, int expected) {
        fPlan.setHint(hint, value);
        Object getValue = fPlan.getHint(hint);
        TestFetchHints.assertEquals(value.getClass(), getValue.getClass());
        TestFetchHints.assertEquals((Object)value, (Object)getValue);
        TestFetchHints.assertEquals((Object)expectedValue, (Object)fPlan.getFetchDirection());
        TestFetchHints.assertEquals((int)expected, (int)fConfig.getFetchDirection());
    }

    public void testFetchPlanIsolationHint() {
        String hintName = "openjpa.FetchPlan.Isolation";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.isolationHintTest(oem, fPlan, fConfig, hintName, "default", IsolationLevel.DEFAULT, -1);
        this.isolationHintTest(oem, fPlan, fConfig, hintName, "DEFAULT", IsolationLevel.DEFAULT, -1);
        this.isolationHintTest(oem, fPlan, fConfig, hintName, IsolationLevel.DEFAULT, IsolationLevel.DEFAULT, -1);
        boolean supportIsolationForUpdate = ((JDBCConfiguration)fConfig.getContext().getConfiguration()).getDBDictionaryInstance().supportsIsolationForUpdate();
        if (supportIsolationForUpdate) {
            this.isolationHintTest(oem, fPlan, fConfig, hintName, "none", IsolationLevel.NONE, 0);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, "NONE", IsolationLevel.NONE, 0);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, IsolationLevel.NONE, IsolationLevel.NONE, 0);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, "read-uncommitted", IsolationLevel.READ_UNCOMMITTED, 1);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, "READ_UNCOMMITTED", IsolationLevel.READ_UNCOMMITTED, 1);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, IsolationLevel.READ_UNCOMMITTED, IsolationLevel.READ_UNCOMMITTED, 1);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, "read-committed", IsolationLevel.READ_COMMITTED, 2);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, "READ_COMMITTED", IsolationLevel.READ_COMMITTED, 2);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, IsolationLevel.READ_COMMITTED, IsolationLevel.READ_COMMITTED, 2);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, "repeatable-read", IsolationLevel.REPEATABLE_READ, 4);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, "REPEATABLE_READ", IsolationLevel.REPEATABLE_READ, 4);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, IsolationLevel.REPEATABLE_READ, IsolationLevel.REPEATABLE_READ, 4);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, "serializable", IsolationLevel.SERIALIZABLE, 8);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, "SERIALIZABLE", IsolationLevel.SERIALIZABLE, 8);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, IsolationLevel.SERIALIZABLE, IsolationLevel.SERIALIZABLE, 8);
        }
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        em.close();
    }

    public void testJdbcTransactionIsolationHint() {
        String hintName = "openjpa.jdbc.TransactionIsolation";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.isolationHintTest(oem, fPlan, fConfig, hintName, "-1", IsolationLevel.DEFAULT, -1);
        this.isolationHintTest(oem, fPlan, fConfig, hintName, -1, IsolationLevel.DEFAULT, -1);
        boolean supportIsolationForUpdate = ((JDBCConfiguration)fConfig.getContext().getConfiguration()).getDBDictionaryInstance().supportsIsolationForUpdate();
        if (supportIsolationForUpdate) {
            this.isolationHintTest(oem, fPlan, fConfig, hintName, String.valueOf(0), IsolationLevel.NONE, 0);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, 0, IsolationLevel.NONE, 0);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, String.valueOf(1), IsolationLevel.READ_UNCOMMITTED, 1);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, 1, IsolationLevel.READ_UNCOMMITTED, 1);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, String.valueOf(2), IsolationLevel.READ_COMMITTED, 2);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, 2, IsolationLevel.READ_COMMITTED, 2);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, String.valueOf(4), IsolationLevel.REPEATABLE_READ, 4);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, 4, IsolationLevel.REPEATABLE_READ, 4);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, String.valueOf(8), IsolationLevel.SERIALIZABLE, 8);
            this.isolationHintTest(oem, fPlan, fConfig, hintName, 8, IsolationLevel.SERIALIZABLE, 8);
        }
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-2);
            fPlan.setHint(hintName, (Object)-3);
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-99);
            TestFetchHints.assertEquals((Object)IsolationLevel.DEFAULT, (Object)fPlan.getIsolation());
            TestFetchHints.assertEquals((int)-1, (int)fConfig.getIsolation());
        }
        catch (Exception e) {
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.close();
    }

    private void isolationHintTest(OpenJPAEntityManager oem, JDBCFetchPlan fPlan, JDBCFetchConfigurationImpl fConfig, String hint, Object value, Object expectedValue, int expected) {
        fPlan.setHint(hint, value);
        Object getValue = fPlan.getHint(hint);
        TestFetchHints.assertEquals(value.getClass(), getValue.getClass());
        TestFetchHints.assertEquals((Object)value, (Object)getValue);
        TestFetchHints.assertEquals((Object)expectedValue, (Object)fPlan.getIsolation());
        TestFetchHints.assertEquals((int)expected, (int)fConfig.getIsolation());
    }

    public void testFetchPlanLRSSizeAlgorithmHint() {
        String hintName = "openjpa.FetchPlan.LRSSizeAlgorithm";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.lrsSizeHintTest(fPlan, fConfig, hintName, "query", LRSSizeAlgorithm.QUERY, 2);
        this.lrsSizeHintTest(fPlan, fConfig, hintName, LRSSizeAlgorithm.QUERY.name(), LRSSizeAlgorithm.QUERY, 2);
        this.lrsSizeHintTest(fPlan, fConfig, hintName, LRSSizeAlgorithm.QUERY, LRSSizeAlgorithm.QUERY, 2);
        this.lrsSizeHintTest(fPlan, fConfig, hintName, "last", LRSSizeAlgorithm.LAST, 1);
        this.lrsSizeHintTest(fPlan, fConfig, hintName, LRSSizeAlgorithm.LAST.name(), LRSSizeAlgorithm.LAST, 1);
        this.lrsSizeHintTest(fPlan, fConfig, hintName, LRSSizeAlgorithm.LAST, LRSSizeAlgorithm.LAST, 1);
        this.lrsSizeHintTest(fPlan, fConfig, hintName, "unknown", LRSSizeAlgorithm.UNKNOWN, 0);
        this.lrsSizeHintTest(fPlan, fConfig, hintName, LRSSizeAlgorithm.UNKNOWN.name(), LRSSizeAlgorithm.UNKNOWN, 0);
        this.lrsSizeHintTest(fPlan, fConfig, hintName, LRSSizeAlgorithm.UNKNOWN, LRSSizeAlgorithm.UNKNOWN, 0);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-1);
            fPlan.setHint(hintName, (Object)-2);
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)("Caught unexpected exception " + e), (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        em.close();
    }

    public void testFetchPlanLRSSizeHint() {
        String hintName = "openjpa.FetchPlan.LRSSize";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.lrsSizeHintTest(fPlan, fConfig, hintName, String.valueOf(2), LRSSizeAlgorithm.QUERY, 2);
        this.lrsSizeHintTest(fPlan, fConfig, hintName, 2, LRSSizeAlgorithm.QUERY, 2);
        this.lrsSizeHintTest(fPlan, fConfig, hintName, String.valueOf(1), LRSSizeAlgorithm.LAST, 1);
        this.lrsSizeHintTest(fPlan, fConfig, hintName, 1, LRSSizeAlgorithm.LAST, 1);
        this.lrsSizeHintTest(fPlan, fConfig, hintName, String.valueOf(0), LRSSizeAlgorithm.UNKNOWN, 0);
        this.lrsSizeHintTest(fPlan, fConfig, hintName, 0, LRSSizeAlgorithm.UNKNOWN, 0);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-1);
            fPlan.setHint(hintName, (Object)-2);
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-99);
            TestFetchHints.assertEquals((Object)LRSSizeAlgorithm.QUERY, (Object)fPlan.getLRSSizeAlgorithm());
            TestFetchHints.assertEquals((int)2, (int)fPlan.getLRSSize());
            TestFetchHints.assertEquals((int)2, (int)fConfig.getLRSSize());
        }
        catch (Exception e) {
            e.printStackTrace();
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.close();
    }

    public void testJdbcLRSSizeHint() {
        String hintName = "openjpa.jdbc.LRSSize";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.lrsSizeHintTest(fPlan, fConfig, hintName, String.valueOf(2), LRSSizeAlgorithm.QUERY, 2);
        this.lrsSizeHintTest(fPlan, fConfig, hintName, 2, LRSSizeAlgorithm.QUERY, 2);
        this.lrsSizeHintTest(fPlan, fConfig, hintName, String.valueOf(1), LRSSizeAlgorithm.LAST, 1);
        this.lrsSizeHintTest(fPlan, fConfig, hintName, 1, LRSSizeAlgorithm.LAST, 1);
        this.lrsSizeHintTest(fPlan, fConfig, hintName, String.valueOf(0), LRSSizeAlgorithm.UNKNOWN, 0);
        this.lrsSizeHintTest(fPlan, fConfig, hintName, 0, LRSSizeAlgorithm.UNKNOWN, 0);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-1);
            fPlan.setHint(hintName, (Object)-2);
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-99);
            TestFetchHints.assertEquals((Object)LRSSizeAlgorithm.QUERY, (Object)fPlan.getLRSSizeAlgorithm());
            TestFetchHints.assertEquals((int)2, (int)fPlan.getLRSSize());
            TestFetchHints.assertEquals((int)2, (int)fConfig.getLRSSize());
        }
        catch (Exception e) {
            e.printStackTrace();
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.close();
    }

    private void lrsSizeHintTest(JDBCFetchPlan fPlan, JDBCFetchConfigurationImpl fConfig, String hint, Object value, Object expectedValue, int expected) {
        fPlan.setHint(hint, value);
        Object getValue = fPlan.getHint(hint);
        TestFetchHints.assertEquals(value.getClass(), getValue.getClass());
        TestFetchHints.assertEquals((Object)value, (Object)getValue);
        TestFetchHints.assertEquals((Object)expectedValue, (Object)fPlan.getLRSSizeAlgorithm());
        TestFetchHints.assertEquals((int)expected, (int)fPlan.getLRSSize());
        TestFetchHints.assertEquals((int)expected, (int)fConfig.getLRSSize());
    }

    public void testFetchPlanMaxFetchDepthHint() {
        String hintName = "openjpa.FetchPlan.MaxFetchDepth";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.maxFetchDepthHintTest(fPlan, fConfig, hintName, "-1", -1);
        this.maxFetchDepthHintTest(fPlan, fConfig, hintName, -1, -1);
        this.maxFetchDepthHintTest(fPlan, fConfig, hintName, "500", 500);
        this.maxFetchDepthHintTest(fPlan, fConfig, hintName, 500, 500);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-99);
            TestFetchHints.assertEquals((int)-1, (int)fPlan.getMaxFetchDepth());
            TestFetchHints.assertEquals((int)-1, (int)fConfig.getMaxFetchDepth());
        }
        catch (IllegalArgumentException e) {
            TestFetchHints.fail((String)"Unexpected IllegalArgumentException.");
        }
        em.close();
    }

    public void testMaxFetchDepthHint() {
        String hintName = "openjpa.MaxFetchDepth";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.maxFetchDepthHintTest(fPlan, fConfig, hintName, "-1", -1);
        this.maxFetchDepthHintTest(fPlan, fConfig, hintName, -1, -1);
        this.maxFetchDepthHintTest(fPlan, fConfig, hintName, "100", 100);
        this.maxFetchDepthHintTest(fPlan, fConfig, hintName, 100, 100);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-99);
            TestFetchHints.assertEquals((int)-1, (int)fPlan.getMaxFetchDepth());
            TestFetchHints.assertEquals((int)-1, (int)fConfig.getMaxFetchDepth());
        }
        catch (Exception e) {
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.close();
    }

    private void maxFetchDepthHintTest(JDBCFetchPlan fPlan, JDBCFetchConfigurationImpl fConfig, String hint, Object value, int expected) {
        fPlan.setHint(hint, value);
        Object getValue = fPlan.getHint(hint);
        TestFetchHints.assertEquals(value.getClass(), getValue.getClass());
        TestFetchHints.assertEquals((Object)value, (Object)getValue);
        TestFetchHints.assertEquals((int)expected, (int)fPlan.getMaxFetchDepth());
        TestFetchHints.assertEquals((int)expected, (int)fConfig.getMaxFetchDepth());
    }

    public void testLockTimeoutHint() {
        String hintName = "openjpa.LockTimeout";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.lockTimeoutHintTest(fPlan, fConfig, hintName, "-1", -1);
        this.lockTimeoutHintTest(fPlan, fConfig, hintName, -1, -1);
        this.lockTimeoutHintTest(fPlan, fConfig, hintName, "0", 0);
        this.lockTimeoutHintTest(fPlan, fConfig, hintName, 0, 0);
        this.lockTimeoutHintTest(fPlan, fConfig, hintName, "100", 100);
        this.lockTimeoutHintTest(fPlan, fConfig, hintName, 100, 100);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-2);
            fPlan.setHint(hintName, (Object)-3);
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-99);
            int defTimeout = fConfig.getContext().getConfiguration().getLockTimeout();
            TestFetchHints.assertEquals((int)defTimeout, (int)fPlan.getLockTimeout());
            TestFetchHints.assertEquals((int)defTimeout, (int)fConfig.getLockTimeout());
        }
        catch (Exception e) {
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.close();
    }

    public void testFetchPlanLockTimeoutHint() {
        String hintName = "openjpa.FetchPlan.LockTimeout";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.lockTimeoutHintTest(fPlan, fConfig, hintName, "-1", -1);
        this.lockTimeoutHintTest(fPlan, fConfig, hintName, -1, -1);
        this.lockTimeoutHintTest(fPlan, fConfig, hintName, "0", 0);
        this.lockTimeoutHintTest(fPlan, fConfig, hintName, 0, 0);
        this.lockTimeoutHintTest(fPlan, fConfig, hintName, "1500", 1500);
        this.lockTimeoutHintTest(fPlan, fConfig, hintName, 1500, 1500);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-2);
            fPlan.setHint(hintName, (Object)-3);
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-99);
            int defTimeout = fConfig.getContext().getConfiguration().getLockTimeout();
            TestFetchHints.assertEquals((int)defTimeout, (int)fPlan.getLockTimeout());
            TestFetchHints.assertEquals((int)defTimeout, (int)fConfig.getLockTimeout());
        }
        catch (Exception e) {
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.close();
    }

    public void testJavaxLockTimeoutHint() {
        String hintName = "javax.persistence.lock.timeout";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.lockTimeoutHintTest(fPlan, fConfig, hintName, "-1", -1);
        this.lockTimeoutHintTest(fPlan, fConfig, hintName, -1, -1);
        this.lockTimeoutHintTest(fPlan, fConfig, hintName, "0", 0);
        this.lockTimeoutHintTest(fPlan, fConfig, hintName, 0, 0);
        this.lockTimeoutHintTest(fPlan, fConfig, hintName, "2000", 2000);
        this.lockTimeoutHintTest(fPlan, fConfig, hintName, 2000, 2000);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-2);
            fPlan.setHint(hintName, (Object)-3);
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-99);
            int defTimeout = fConfig.getContext().getConfiguration().getLockTimeout();
            TestFetchHints.assertEquals((int)defTimeout, (int)fPlan.getLockTimeout());
            TestFetchHints.assertEquals((int)defTimeout, (int)fConfig.getLockTimeout());
        }
        catch (Exception e) {
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.close();
    }

    private void lockTimeoutHintTest(JDBCFetchPlan fPlan, JDBCFetchConfigurationImpl fConfig, String hint, Object value, int expected) {
        fPlan.setHint(hint, value);
        Object getValue = fPlan.getHint(hint);
        TestFetchHints.assertEquals(value.getClass(), getValue.getClass());
        TestFetchHints.assertEquals((Object)value, (Object)getValue);
        TestFetchHints.assertEquals((int)expected, (int)fPlan.getLockTimeout());
        TestFetchHints.assertEquals((int)expected, (int)fConfig.getLockTimeout());
    }

    public void testQueryTimeoutHint() {
        String hintName = "openjpa.QueryTimeout";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.queryTimeoutHintTest(fPlan, fConfig, hintName, "-1", -1);
        this.queryTimeoutHintTest(fPlan, fConfig, hintName, -1, -1);
        this.queryTimeoutHintTest(fPlan, fConfig, hintName, "0", 0);
        this.queryTimeoutHintTest(fPlan, fConfig, hintName, 0, 0);
        this.queryTimeoutHintTest(fPlan, fConfig, hintName, "100", 100);
        this.queryTimeoutHintTest(fPlan, fConfig, hintName, 100, 100);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-2);
            fPlan.setHint(hintName, (Object)-3);
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-99);
            int defTimeout = fConfig.getContext().getConfiguration().getQueryTimeout();
            TestFetchHints.assertEquals((int)defTimeout, (int)fPlan.getQueryTimeout());
            TestFetchHints.assertEquals((int)defTimeout, (int)fConfig.getQueryTimeout());
        }
        catch (Exception e) {
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.close();
    }

    public void testFetchPlanQueryTimeoutHint() {
        String hintName = "openjpa.FetchPlan.QueryTimeout";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.queryTimeoutHintTest(fPlan, fConfig, hintName, "-1", -1);
        this.queryTimeoutHintTest(fPlan, fConfig, hintName, -1, -1);
        this.queryTimeoutHintTest(fPlan, fConfig, hintName, "0", 0);
        this.queryTimeoutHintTest(fPlan, fConfig, hintName, 0, 0);
        this.queryTimeoutHintTest(fPlan, fConfig, hintName, "1500", 1500);
        this.queryTimeoutHintTest(fPlan, fConfig, hintName, 1500, 1500);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-2);
            fPlan.setHint(hintName, (Object)-3);
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-99);
            int defTimeout = fConfig.getContext().getConfiguration().getQueryTimeout();
            TestFetchHints.assertEquals((int)defTimeout, (int)fPlan.getQueryTimeout());
            TestFetchHints.assertEquals((int)defTimeout, (int)fConfig.getQueryTimeout());
        }
        catch (Exception e) {
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.close();
    }

    public void testJavaxQueryTimeoutHint() {
        String hintName = "javax.persistence.query.timeout";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.queryTimeoutHintTest(fPlan, fConfig, hintName, "-1", -1);
        this.queryTimeoutHintTest(fPlan, fConfig, hintName, -1, -1);
        this.queryTimeoutHintTest(fPlan, fConfig, hintName, "0", 0);
        this.queryTimeoutHintTest(fPlan, fConfig, hintName, 0, 0);
        this.queryTimeoutHintTest(fPlan, fConfig, hintName, "2000", 2000);
        this.queryTimeoutHintTest(fPlan, fConfig, hintName, 2000, 2000);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-2);
            fPlan.setHint(hintName, (Object)-3);
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-99);
            int defTimeout = fConfig.getContext().getConfiguration().getQueryTimeout();
            TestFetchHints.assertEquals((int)defTimeout, (int)fPlan.getQueryTimeout());
            TestFetchHints.assertEquals((int)defTimeout, (int)fConfig.getQueryTimeout());
        }
        catch (Exception e) {
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.close();
    }

    private void queryTimeoutHintTest(JDBCFetchPlan fPlan, JDBCFetchConfigurationImpl fConfig, String hint, Object value, int expected) {
        fPlan.setHint(hint, value);
        Object getValue = fPlan.getHint(hint);
        TestFetchHints.assertEquals(value.getClass(), getValue.getClass());
        TestFetchHints.assertEquals((Object)value, (Object)getValue);
        TestFetchHints.assertEquals((int)expected, (int)fPlan.getQueryTimeout());
        TestFetchHints.assertEquals((int)expected, (int)fConfig.getQueryTimeout());
    }

    public void testFetchPlanResultSetTypeHint() {
        String hintName = "openjpa.FetchPlan.ResultSetType";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.resultSetTypeHintTest(fPlan, fConfig, hintName, ResultSetType.FORWARD_ONLY.name(), ResultSetType.FORWARD_ONLY, 1003);
        this.resultSetTypeHintTest(fPlan, fConfig, hintName, ResultSetType.FORWARD_ONLY, ResultSetType.FORWARD_ONLY, 1003);
        this.resultSetTypeHintTest(fPlan, fConfig, hintName, ResultSetType.SCROLL_SENSITIVE.name(), ResultSetType.SCROLL_SENSITIVE, 1005);
        this.resultSetTypeHintTest(fPlan, fConfig, hintName, ResultSetType.SCROLL_SENSITIVE, ResultSetType.SCROLL_SENSITIVE, 1005);
        this.resultSetTypeHintTest(fPlan, fConfig, hintName, ResultSetType.SCROLL_INSENSITIVE.name(), ResultSetType.SCROLL_INSENSITIVE, 1004);
        this.resultSetTypeHintTest(fPlan, fConfig, hintName, ResultSetType.SCROLL_INSENSITIVE, ResultSetType.SCROLL_INSENSITIVE, 1004);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-1);
            fPlan.setHint(hintName, (Object)-2);
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)("Caught unexpected exception " + e), (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        em.close();
    }

    public void testJdbcResultSetTypeHint() {
        String hintName = "openjpa.jdbc.ResultSetType";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.resultSetTypeHintTest(fPlan, fConfig, hintName, String.valueOf(1003), ResultSetType.FORWARD_ONLY, 1003);
        this.resultSetTypeHintTest(fPlan, fConfig, hintName, 1003, ResultSetType.FORWARD_ONLY, 1003);
        this.resultSetTypeHintTest(fPlan, fConfig, hintName, String.valueOf(1005), ResultSetType.SCROLL_SENSITIVE, 1005);
        this.resultSetTypeHintTest(fPlan, fConfig, hintName, 1005, ResultSetType.SCROLL_SENSITIVE, 1005);
        this.resultSetTypeHintTest(fPlan, fConfig, hintName, String.valueOf(1004), ResultSetType.SCROLL_INSENSITIVE, 1004);
        this.resultSetTypeHintTest(fPlan, fConfig, hintName, 1004, ResultSetType.SCROLL_INSENSITIVE, 1004);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-1);
            fPlan.setHint(hintName, (Object)-2);
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-99);
            TestFetchHints.assertEquals((int)1003, (int)fConfig.getResultSetType());
        }
        catch (Exception e) {
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.close();
    }

    private void resultSetTypeHintTest(JDBCFetchPlan fPlan, JDBCFetchConfigurationImpl fConfig, String hint, Object value, Object expectedValue, int expected) {
        fPlan.setHint(hint, value);
        Object getValue = fPlan.getHint(hint);
        TestFetchHints.assertEquals(value.getClass(), getValue.getClass());
        TestFetchHints.assertEquals((Object)value, (Object)getValue);
        TestFetchHints.assertEquals((Object)expectedValue, (Object)fPlan.getResultSetType());
        TestFetchHints.assertEquals((int)expected, (int)fConfig.getResultSetType());
    }

    public void testFetchPlanSubclassFetchModeHint() {
        String hintName = "openjpa.FetchPlan.SubclassFetchMode";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.subclassFetchModeHintTest(fPlan, fConfig, hintName, "none", FetchMode.NONE, 0);
        this.subclassFetchModeHintTest(fPlan, fConfig, hintName, FetchMode.NONE.name(), FetchMode.NONE, 0);
        this.subclassFetchModeHintTest(fPlan, fConfig, hintName, FetchMode.NONE, FetchMode.NONE, 0);
        this.subclassFetchModeHintTest(fPlan, fConfig, hintName, "parallel", FetchMode.PARALLEL, 2);
        this.subclassFetchModeHintTest(fPlan, fConfig, hintName, FetchMode.PARALLEL.name(), FetchMode.PARALLEL, 2);
        this.subclassFetchModeHintTest(fPlan, fConfig, hintName, FetchMode.PARALLEL, FetchMode.PARALLEL, 2);
        this.subclassFetchModeHintTest(fPlan, fConfig, hintName, "join", FetchMode.JOIN, 1);
        this.subclassFetchModeHintTest(fPlan, fConfig, hintName, FetchMode.JOIN.name(), FetchMode.JOIN, 1);
        this.subclassFetchModeHintTest(fPlan, fConfig, hintName, FetchMode.JOIN, FetchMode.JOIN, 1);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-1);
            fPlan.setHint(hintName, (Object)-2);
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        em.close();
    }

    public void testJdbcSubclassFetchModeHint() {
        String hintName = "openjpa.jdbc.SubclassFetchMode";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.subclassFetchModeHintTest(fPlan, fConfig, hintName, String.valueOf(0), FetchMode.NONE, 0);
        this.subclassFetchModeHintTest(fPlan, fConfig, hintName, 0, FetchMode.NONE, 0);
        this.subclassFetchModeHintTest(fPlan, fConfig, hintName, String.valueOf(2), FetchMode.PARALLEL, 2);
        this.subclassFetchModeHintTest(fPlan, fConfig, hintName, 2, FetchMode.PARALLEL, 2);
        this.subclassFetchModeHintTest(fPlan, fConfig, hintName, String.valueOf(1), FetchMode.JOIN, 1);
        this.subclassFetchModeHintTest(fPlan, fConfig, hintName, 1, FetchMode.JOIN, 1);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-1);
            fPlan.setHint(hintName, (Object)-2);
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-99);
            TestFetchHints.assertEquals((int)1, (int)fConfig.getSubclassFetchMode());
        }
        catch (Exception e) {
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.close();
    }

    private void subclassFetchModeHintTest(JDBCFetchPlan fPlan, JDBCFetchConfigurationImpl fConfig, String hint, Object value, Object expectedValue, int expected) {
        fPlan.setHint(hint, value);
        Object getValue = fPlan.getHint(hint);
        TestFetchHints.assertEquals(value.getClass(), getValue.getClass());
        TestFetchHints.assertEquals((Object)value, (Object)getValue);
        TestFetchHints.assertEquals((Object)expectedValue, (Object)fPlan.getSubclassFetchMode());
        TestFetchHints.assertEquals((int)expected, (int)fConfig.getSubclassFetchMode());
    }

    public void testFlushBeforeQueriesHint() {
        String hintName = "openjpa.FlushBeforeQueries";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        this.flushBeforeQueriesHintTest(fPlan, fConfig, hintName, String.valueOf(0), 0);
        this.flushBeforeQueriesHintTest(fPlan, fConfig, hintName, 0, 0);
        this.flushBeforeQueriesHintTest(fPlan, fConfig, hintName, String.valueOf(1), 1);
        this.flushBeforeQueriesHintTest(fPlan, fConfig, hintName, 1, 1);
        this.flushBeforeQueriesHintTest(fPlan, fConfig, hintName, String.valueOf(2), 2);
        this.flushBeforeQueriesHintTest(fPlan, fConfig, hintName, 2, 2);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-1);
            fPlan.setHint(hintName, (Object)-2);
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-99);
            fConfig.getFlushBeforeQueries();
            TestFetchHints.assertEquals((int)0, (int)fConfig.getFlushBeforeQueries());
        }
        catch (Exception e) {
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.close();
    }

    private void flushBeforeQueriesHintTest(JDBCFetchPlan fPlan, JDBCFetchConfigurationImpl fConfig, String hint, Object value, int expected) {
        fPlan.setHint(hint, value);
        Object getValue = fPlan.getHint(hint);
        TestFetchHints.assertEquals(value.getClass(), getValue.getClass());
        TestFetchHints.assertEquals((Object)value, (Object)getValue);
        TestFetchHints.assertEquals((int)expected, (int)fConfig.getFlushBeforeQueries());
    }

    public void testReadLockLevelHint() {
        String hintName = "openjpa.ReadLockLevel";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        em.getTransaction().begin();
        this.readLockLevelHintTest(fPlan, fConfig, hintName, String.valueOf(0), LockModeType.NONE, 0);
        this.readLockLevelHintTest(fPlan, fConfig, hintName, 0, LockModeType.NONE, 0);
        this.readLockLevelHintTest(fPlan, fConfig, hintName, String.valueOf(10), LockModeType.READ, 10);
        this.readLockLevelHintTest(fPlan, fConfig, hintName, 10, LockModeType.READ, 10);
        this.readLockLevelHintTest(fPlan, fConfig, hintName, String.valueOf(20), LockModeType.WRITE, 20);
        this.readLockLevelHintTest(fPlan, fConfig, hintName, 20, LockModeType.WRITE, 20);
        this.readLockLevelHintTest(fPlan, fConfig, hintName, String.valueOf(15), LockModeType.OPTIMISTIC, 15);
        this.readLockLevelHintTest(fPlan, fConfig, hintName, 15, LockModeType.OPTIMISTIC, 15);
        this.readLockLevelHintTest(fPlan, fConfig, hintName, String.valueOf(25), LockModeType.OPTIMISTIC_FORCE_INCREMENT, 25);
        this.readLockLevelHintTest(fPlan, fConfig, hintName, 25, LockModeType.OPTIMISTIC_FORCE_INCREMENT, 25);
        this.readLockLevelHintTest(fPlan, fConfig, hintName, String.valueOf(30), LockModeType.PESSIMISTIC_READ, 30);
        this.readLockLevelHintTest(fPlan, fConfig, hintName, 30, LockModeType.PESSIMISTIC_READ, 30);
        this.readLockLevelHintTest(fPlan, fConfig, hintName, String.valueOf(40), LockModeType.PESSIMISTIC_WRITE, 40);
        this.readLockLevelHintTest(fPlan, fConfig, hintName, 40, LockModeType.PESSIMISTIC_WRITE, 40);
        this.readLockLevelHintTest(fPlan, fConfig, hintName, String.valueOf(50), LockModeType.PESSIMISTIC_FORCE_INCREMENT, 50);
        this.readLockLevelHintTest(fPlan, fConfig, hintName, 50, LockModeType.PESSIMISTIC_FORCE_INCREMENT, 50);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-1);
            fPlan.setHint(hintName, (Object)-2);
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-99);
            TestFetchHints.assertEquals((int)10, (int)fConfig.getReadLockLevel());
        }
        catch (Exception e) {
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.getTransaction().rollback();
        em.close();
    }

    private void readLockLevelHintTest(JDBCFetchPlan fPlan, JDBCFetchConfigurationImpl fConfig, String hint, Object value, Object expectedMode, int expectedLevel) {
        fPlan.setHint(hint, value);
        Object getValue = fPlan.getHint(hint);
        TestFetchHints.assertEquals(value.getClass(), getValue.getClass());
        TestFetchHints.assertEquals((Object)value, (Object)getValue);
        TestFetchHints.assertEquals((Object)expectedMode, (Object)fPlan.getReadLockMode());
        TestFetchHints.assertEquals((int)expectedLevel, (int)fConfig.getReadLockLevel());
    }

    public void testWriteLockLevelHint() {
        String hintName = "openjpa.WriteLockLevel";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        em.getTransaction().begin();
        this.writeLockLevelHintTest(fPlan, fConfig, hintName, String.valueOf(0), LockModeType.NONE, 0);
        this.writeLockLevelHintTest(fPlan, fConfig, hintName, 0, LockModeType.NONE, 0);
        this.writeLockLevelHintTest(fPlan, fConfig, hintName, String.valueOf(10), LockModeType.READ, 10);
        this.writeLockLevelHintTest(fPlan, fConfig, hintName, 10, LockModeType.READ, 10);
        this.writeLockLevelHintTest(fPlan, fConfig, hintName, String.valueOf(20), LockModeType.WRITE, 20);
        this.writeLockLevelHintTest(fPlan, fConfig, hintName, 20, LockModeType.WRITE, 20);
        this.writeLockLevelHintTest(fPlan, fConfig, hintName, String.valueOf(15), LockModeType.OPTIMISTIC, 15);
        this.writeLockLevelHintTest(fPlan, fConfig, hintName, 15, LockModeType.OPTIMISTIC, 15);
        this.writeLockLevelHintTest(fPlan, fConfig, hintName, String.valueOf(25), LockModeType.OPTIMISTIC_FORCE_INCREMENT, 25);
        this.writeLockLevelHintTest(fPlan, fConfig, hintName, 25, LockModeType.OPTIMISTIC_FORCE_INCREMENT, 25);
        this.writeLockLevelHintTest(fPlan, fConfig, hintName, String.valueOf(30), LockModeType.PESSIMISTIC_READ, 30);
        this.writeLockLevelHintTest(fPlan, fConfig, hintName, 30, LockModeType.PESSIMISTIC_READ, 30);
        this.writeLockLevelHintTest(fPlan, fConfig, hintName, String.valueOf(40), LockModeType.PESSIMISTIC_WRITE, 40);
        this.writeLockLevelHintTest(fPlan, fConfig, hintName, 40, LockModeType.PESSIMISTIC_WRITE, 40);
        this.writeLockLevelHintTest(fPlan, fConfig, hintName, String.valueOf(50), LockModeType.PESSIMISTIC_FORCE_INCREMENT, 50);
        this.writeLockLevelHintTest(fPlan, fConfig, hintName, 50, LockModeType.PESSIMISTIC_FORCE_INCREMENT, 50);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-1);
            fPlan.setHint(hintName, (Object)-2);
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-99);
            TestFetchHints.assertEquals((int)20, (int)fConfig.getWriteLockLevel());
        }
        catch (Exception e) {
            TestFetchHints.fail((String)("Unexpected " + e.getClass().getName()));
        }
        em.getTransaction().rollback();
        em.close();
    }

    private void writeLockLevelHintTest(JDBCFetchPlan fPlan, JDBCFetchConfigurationImpl fConfig, String hint, Object value, Object expectedMode, int expectedLevel) {
        fPlan.setHint(hint, value);
        Object getValue = fPlan.getHint(hint);
        TestFetchHints.assertEquals(value.getClass(), getValue.getClass());
        TestFetchHints.assertEquals((Object)value, (Object)getValue);
        TestFetchHints.assertEquals((Object)expectedMode, (Object)fPlan.getWriteLockMode());
        TestFetchHints.assertEquals((int)expectedLevel, (int)fConfig.getWriteLockLevel());
    }

    public void testFetchPlanReadLockModeHintInTx() {
        this.fetchPlanReadLockModeHint(true);
    }

    public void testFetchPlanReadLockModeHintNotInTx() {
        this.fetchPlanReadLockModeHint(false);
    }

    private void fetchPlanReadLockModeHint(boolean inTransaction) {
        String hintName = "openjpa.FetchPlan.ReadLockMode";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        if (inTransaction) {
            em.getTransaction().begin();
        }
        this.readLockModeHintTest(fPlan, fConfig, hintName, "none", LockModeType.NONE, 0);
        this.readLockModeHintTest(fPlan, fConfig, hintName, LockModeType.NONE, LockModeType.NONE, 0);
        this.readLockModeHintTest(fPlan, fConfig, hintName, LockModeType.NONE.name(), LockModeType.NONE, 0);
        this.readLockModeHintTest(fPlan, fConfig, hintName, "read", LockModeType.READ, 10);
        this.readLockModeHintTest(fPlan, fConfig, hintName, LockModeType.READ, LockModeType.READ, 10);
        this.readLockModeHintTest(fPlan, fConfig, hintName, LockModeType.READ.name(), LockModeType.READ, 10);
        this.readLockModeHintTest(fPlan, fConfig, hintName, "write", LockModeType.WRITE, 20);
        this.readLockModeHintTest(fPlan, fConfig, hintName, LockModeType.WRITE, LockModeType.WRITE, 20);
        this.readLockModeHintTest(fPlan, fConfig, hintName, LockModeType.WRITE.name(), LockModeType.WRITE, 20);
        this.readLockModeHintTest(fPlan, fConfig, hintName, "optimistic", LockModeType.OPTIMISTIC, 15);
        this.readLockModeHintTest(fPlan, fConfig, hintName, LockModeType.OPTIMISTIC, LockModeType.OPTIMISTIC, 15);
        this.readLockModeHintTest(fPlan, fConfig, hintName, LockModeType.OPTIMISTIC.name(), LockModeType.OPTIMISTIC, 15);
        this.readLockModeHintTest(fPlan, fConfig, hintName, "optimistic-force-increment", LockModeType.OPTIMISTIC_FORCE_INCREMENT, 25);
        this.readLockModeHintTest(fPlan, fConfig, hintName, LockModeType.OPTIMISTIC_FORCE_INCREMENT, LockModeType.OPTIMISTIC_FORCE_INCREMENT, 25);
        this.readLockModeHintTest(fPlan, fConfig, hintName, LockModeType.OPTIMISTIC_FORCE_INCREMENT.name(), LockModeType.OPTIMISTIC_FORCE_INCREMENT, 25);
        this.readLockModeHintTest(fPlan, fConfig, hintName, "pessimistic-read", LockModeType.PESSIMISTIC_READ, 30);
        this.readLockModeHintTest(fPlan, fConfig, hintName, LockModeType.PESSIMISTIC_READ, LockModeType.PESSIMISTIC_READ, 30);
        this.readLockModeHintTest(fPlan, fConfig, hintName, LockModeType.PESSIMISTIC_READ.name(), LockModeType.PESSIMISTIC_READ, 30);
        this.readLockModeHintTest(fPlan, fConfig, hintName, "pessimistic-write", LockModeType.PESSIMISTIC_WRITE, 40);
        this.readLockModeHintTest(fPlan, fConfig, hintName, LockModeType.PESSIMISTIC_WRITE, LockModeType.PESSIMISTIC_WRITE, 40);
        this.readLockModeHintTest(fPlan, fConfig, hintName, LockModeType.PESSIMISTIC_WRITE.name(), LockModeType.PESSIMISTIC_WRITE, 40);
        this.readLockModeHintTest(fPlan, fConfig, hintName, "pessimistic-force-increment", LockModeType.PESSIMISTIC_FORCE_INCREMENT, 50);
        this.readLockModeHintTest(fPlan, fConfig, hintName, LockModeType.PESSIMISTIC_FORCE_INCREMENT, LockModeType.PESSIMISTIC_FORCE_INCREMENT, 50);
        this.readLockModeHintTest(fPlan, fConfig, hintName, LockModeType.PESSIMISTIC_FORCE_INCREMENT.name(), LockModeType.PESSIMISTIC_FORCE_INCREMENT, 50);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-1);
            fPlan.setHint(hintName, (Object)-2);
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        if (inTransaction) {
            em.getTransaction().rollback();
        }
        em.close();
    }

    private void readLockModeHintTest(JDBCFetchPlan fPlan, JDBCFetchConfigurationImpl fConfig, String hint, Object value, Object expectedMode, int expectedLevel) {
        fPlan.setHint(hint, value);
        Object getValue = fPlan.getHint(hint);
        TestFetchHints.assertEquals(value.getClass(), getValue.getClass());
        TestFetchHints.assertEquals((Object)value, (Object)getValue);
        TestFetchHints.assertEquals((Object)expectedMode, (Object)fPlan.getReadLockMode());
        TestFetchHints.assertEquals((int)expectedLevel, (int)fConfig.getReadLockLevel());
    }

    public void testFetchPlanWriteLockModeHintInTx() {
        this.fetchPlanWriteLockModeHint(true);
    }

    public void testFetchPlanWriteLockModeHintNotInTx() {
        this.fetchPlanWriteLockModeHint(false);
    }

    private void fetchPlanWriteLockModeHint(boolean inTransaction) {
        String hintName = "openjpa.FetchPlan.WriteLockMode";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        if (inTransaction) {
            em.getTransaction().begin();
        }
        this.writeLockModeHintTest(fPlan, fConfig, hintName, "none", LockModeType.NONE, 0);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, LockModeType.NONE, LockModeType.NONE, 0);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, LockModeType.NONE.name(), LockModeType.NONE, 0);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, "read", LockModeType.READ, 10);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, LockModeType.READ, LockModeType.READ, 10);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, LockModeType.READ.name(), LockModeType.READ, 10);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, "write", LockModeType.WRITE, 20);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, LockModeType.WRITE, LockModeType.WRITE, 20);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, LockModeType.WRITE.name(), LockModeType.WRITE, 20);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, "optimistic", LockModeType.OPTIMISTIC, 15);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, LockModeType.OPTIMISTIC, LockModeType.OPTIMISTIC, 15);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, LockModeType.OPTIMISTIC.name(), LockModeType.OPTIMISTIC, 15);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, "optimistic-force-increment", LockModeType.OPTIMISTIC_FORCE_INCREMENT, 25);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, LockModeType.OPTIMISTIC_FORCE_INCREMENT, LockModeType.OPTIMISTIC_FORCE_INCREMENT, 25);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, LockModeType.OPTIMISTIC_FORCE_INCREMENT.name(), LockModeType.OPTIMISTIC_FORCE_INCREMENT, 25);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, "pessimistic-read", LockModeType.PESSIMISTIC_READ, 30);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, LockModeType.PESSIMISTIC_READ, LockModeType.PESSIMISTIC_READ, 30);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, LockModeType.PESSIMISTIC_READ.name(), LockModeType.PESSIMISTIC_READ, 30);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, "pessimistic-write", LockModeType.PESSIMISTIC_WRITE, 40);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, LockModeType.PESSIMISTIC_WRITE, LockModeType.PESSIMISTIC_WRITE, 40);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, LockModeType.PESSIMISTIC_WRITE.name(), LockModeType.PESSIMISTIC_WRITE, 40);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, "pessimistic-force-increment", LockModeType.PESSIMISTIC_FORCE_INCREMENT, 50);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, LockModeType.PESSIMISTIC_FORCE_INCREMENT, LockModeType.PESSIMISTIC_FORCE_INCREMENT, 50);
        this.writeLockModeHintTest(fPlan, fConfig, hintName, LockModeType.PESSIMISTIC_FORCE_INCREMENT.name(), LockModeType.PESSIMISTIC_FORCE_INCREMENT, 50);
        try {
            fPlan.setHint(hintName, (Object)"xxxxx");
            fPlan.setHint(hintName, (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)"12345");
            fPlan.setHint(hintName, (Object)"67890");
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        try {
            fPlan.setHint(hintName, (Object)-1);
            fPlan.setHint(hintName, (Object)-2);
            TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        if (inTransaction) {
            em.getTransaction().rollback();
        }
        em.close();
    }

    private void writeLockModeHintTest(JDBCFetchPlan fPlan, JDBCFetchConfigurationImpl fConfig, String hint, Object value, Object expectedMode, Object expectedLevel) {
        fPlan.setHint(hint, value);
        Object getValue = fPlan.getHint(hint);
        TestFetchHints.assertEquals(value.getClass(), getValue.getClass());
        TestFetchHints.assertEquals((Object)value, (Object)getValue);
        TestFetchHints.assertEquals((Object)expectedMode, (Object)fPlan.getWriteLockMode());
        TestFetchHints.assertEquals((Object)expectedLevel, (Object)fConfig.getWriteLockLevel());
    }

    public void testSimiliarLockTimeoutHints() {
        String JavaxLockTimeout = "javax.persistence.lock.timeout";
        String OpenJPALockTimeout = "openjpa.LockTimeout";
        String FetchPlanLockTimeout = "openjpa.FetchPlan.LockTimeout";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        this.similarLockTimeoutHintsTest(oem, JavaxLockTimeout, 333, JavaxLockTimeout, 333, OpenJPALockTimeout, 111, FetchPlanLockTimeout, 222);
        this.similarLockTimeoutHintsTest(oem, JavaxLockTimeout, 333, OpenJPALockTimeout, 111, FetchPlanLockTimeout, 222, JavaxLockTimeout, 333);
        this.similarLockTimeoutHintsTest(oem, JavaxLockTimeout, 333, JavaxLockTimeout, 333, FetchPlanLockTimeout, 222, OpenJPALockTimeout, 111);
        this.similarLockTimeoutHintsTest(oem, FetchPlanLockTimeout, 222, OpenJPALockTimeout, 111, FetchPlanLockTimeout, 222);
        this.similarLockTimeoutHintsTest(oem, FetchPlanLockTimeout, 222, FetchPlanLockTimeout, 222, OpenJPALockTimeout, 111);
        this.similarLockTimeoutHintsTest(oem, OpenJPALockTimeout, 111, OpenJPALockTimeout, 111);
        this.similarLockTimeoutHintsTest(oem, FetchPlanLockTimeout, 222, FetchPlanLockTimeout, 222);
        this.similarLockTimeoutHintsTest(oem, JavaxLockTimeout, 333, JavaxLockTimeout, 333);
        em.close();
    }

    private void similarLockTimeoutHintsTest(OpenJPAEntityManager oem, String winner, Object expected, Object ... hintNvalues) {
        int i;
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.pushFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)fPlan.getDelegate();
        for (i = 0; i < hintNvalues.length; i += 2) {
            fPlan.setHint((String)hintNvalues[i], hintNvalues[i + 1]);
        }
        for (i = 0; i < hintNvalues.length; i += 2) {
            String hintName = (String)hintNvalues[i];
            Object expectedValue = hintNvalues[i + 1];
            Object getValue = fPlan.getHint(hintName);
            if (!hintName.equals(winner)) continue;
            TestFetchHints.assertEquals(expectedValue.getClass(), getValue.getClass());
            TestFetchHints.assertEquals((Object)expectedValue, (Object)getValue);
        }
        TestFetchHints.assertEquals((Object)expected, (Object)fPlan.getLockTimeout());
        TestFetchHints.assertEquals((Object)expected, (Object)fConfig.getLockTimeout());
        oem.popFetchPlan();
    }

    public void testSimiliarQueryTimeoutHints() {
        String JavaxQueryTimeout = "javax.persistence.query.timeout";
        String OpenJPAQueryTimeout = "openjpa.QueryTimeout";
        String FetchPlanQueryTimeout = "openjpa.FetchPlan.QueryTimeout";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        this.similarQueryTimeoutHintsTest(oem, JavaxQueryTimeout, 333, JavaxQueryTimeout, 333, OpenJPAQueryTimeout, 111, FetchPlanQueryTimeout, 222);
        this.similarQueryTimeoutHintsTest(oem, JavaxQueryTimeout, 333, OpenJPAQueryTimeout, 111, FetchPlanQueryTimeout, 222, JavaxQueryTimeout, 333);
        this.similarQueryTimeoutHintsTest(oem, JavaxQueryTimeout, 333, JavaxQueryTimeout, 333, FetchPlanQueryTimeout, 222, OpenJPAQueryTimeout, 111);
        this.similarQueryTimeoutHintsTest(oem, FetchPlanQueryTimeout, 222, OpenJPAQueryTimeout, 111, FetchPlanQueryTimeout, 222);
        this.similarQueryTimeoutHintsTest(oem, FetchPlanQueryTimeout, 222, FetchPlanQueryTimeout, 222, OpenJPAQueryTimeout, 111);
        this.similarQueryTimeoutHintsTest(oem, OpenJPAQueryTimeout, 111, OpenJPAQueryTimeout, 111);
        this.similarQueryTimeoutHintsTest(oem, FetchPlanQueryTimeout, 222, FetchPlanQueryTimeout, 222);
        this.similarQueryTimeoutHintsTest(oem, JavaxQueryTimeout, 333, JavaxQueryTimeout, 333);
        em.close();
    }

    private void similarQueryTimeoutHintsTest(OpenJPAEntityManager oem, String winner, Object expected, Object ... hintNvalues) {
        int i;
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.pushFetchPlan();
        JDBCFetchConfigurationImpl fConfig = (JDBCFetchConfigurationImpl)fPlan.getDelegate();
        for (i = 0; i < hintNvalues.length; i += 2) {
            fPlan.setHint((String)hintNvalues[i], hintNvalues[i + 1]);
        }
        for (i = 0; i < hintNvalues.length; i += 2) {
            String hintName = (String)hintNvalues[i];
            Object expectedValue = hintNvalues[i + 1];
            Object getValue = fPlan.getHint(hintName);
            if (!hintName.equals(winner)) continue;
            TestFetchHints.assertEquals(expectedValue.getClass(), getValue.getClass());
            TestFetchHints.assertEquals((Object)expectedValue, (Object)getValue);
        }
        TestFetchHints.assertEquals((Object)expected, (Object)fPlan.getQueryTimeout());
        TestFetchHints.assertEquals((Object)expected, (Object)fConfig.getQueryTimeout());
        oem.popFetchPlan();
    }

    public void testSetHintAddHintsArgument() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        fPlan.setHint("unrecognized.prop.name", (Object)"unrecognized.prop.value");
        TestFetchHints.assertEquals(null, (Object)fPlan.getHint("unrecognized.prop.name"));
        OpenJPAConfiguration conf = oem.getConfiguration();
        if (conf instanceof JDBCConfiguration && ((JDBCConfiguration)conf).getDBDictionaryInstance().supportsIsolationForUpdate()) {
            try {
                fPlan.setHint("openjpa.jdbc.TransactionIsolation", (Object)9999);
                TestFetchHints.fail((String)"Expecting a a IllegalArgumentException.");
            }
            catch (Exception e) {
                TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
            }
        }
        try {
            fPlan.setHint("openjpa.FetchPlan.Isolation", (Object)13);
            fPlan.setHint("openjpa.FetchPlan.Isolation", (Object)14);
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        em.close();
    }

    public void testInvalidQuerySetHint() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        ((EntityManagerImpl)oem).getBroker().getFetchConfiguration();
        Query q = em.createQuery("select o from LockEmployee o");
        try {
            q.setHint("openjpa.FetchPlan.Isolation", (Object)"yyyyy");
            TestFetchHints.fail((String)"Expecting a IllegalArgumentException.");
        }
        catch (Exception e) {
            TestFetchHints.assertTrue((String)"Caught expected exception", (boolean)IllegalArgumentException.class.isAssignableFrom(e.getClass()));
        }
        em.close();
    }
}

