/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.lockmgr;

import java.util.HashMap;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;
import org.apache.openjpa.persistence.lockmgr.LockEmployee;
import org.apache.openjpa.persistence.lockmgr.SequencedActionsTest;
import org.apache.openjpa.persistence.test.AllowFailure;

public class TestEmLockTimeout
extends SequencedActionsTest {
    public void setUp() {
        this.setUp(new Object[]{LockEmployee.class, "openjpa.LockManager", "mixed"});
        this.commonSetUp();
        this.emf.close();
    }

    public void testSetJavaxLockTimeoutAtProviderCreateEmf() {
        this.setUp(new Object[]{LockEmployee.class, "openjpa.LockManager", "mixed", "javax.persistence.lock.timeout", "13"});
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        int lockTmo1 = fPlan.getLockTimeout();
        TestEmLockTimeout.assertEquals((int)13, (int)lockTmo1);
        em.close();
        this.emf.close();
    }

    @AllowFailure(message="OPENJPA-??? - Provider.createEntityManagerFactory does not suppport multiple equivalent properties.")
    public void testSetLockTimeoutsAtProviderCreateEmf() {
        this.setUp(new Object[]{LockEmployee.class, "openjpa.LockManager", "mixed", "openjpa.LockTimeout", 122, "javax.persistence.lock.timeout", "133"});
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        int lockTmo1 = fPlan.getLockTimeout();
        TestEmLockTimeout.assertEquals((int)133, (int)lockTmo1);
        em.close();
        this.emf.close();
    }

    public void testSetJavaxLockTimeoutAtFind() {
        this.setUp(new Object[]{LockEmployee.class, "openjpa.LockManager", "mixed", "javax.persistence.lock.timeout", "13"});
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        HashMap<String, Integer> props2 = new HashMap<String, Integer>();
        props2.put("javax.persistence.lock.timeout", 3333);
        em.find(LockEmployee.class, (Object)1, props2);
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.getDelegate();
        JDBCFetchPlan fPlan = (JDBCFetchPlan)oem.getFetchPlan();
        int lockTmo3 = fPlan.getLockTimeout();
        TestEmLockTimeout.assertEquals((int)13, (int)lockTmo3);
        em.close();
        this.emf.close();
    }
}

