/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.lock.extended;

import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.lock.extended.LSE1x1Lf;
import org.apache.openjpa.persistence.lock.extended.LSE1x1LfJT;
import org.apache.openjpa.persistence.lock.extended.LSE1x1LfJTLzy;
import org.apache.openjpa.persistence.lock.extended.LSE1x1LfLzy;
import org.apache.openjpa.persistence.lock.extended.LSE1x1Rt;
import org.apache.openjpa.persistence.lock.extended.LockScopeTestCase;

public class Test1x1LockScope
extends LockScopeTestCase {
    public void setUp() {
        this.setSupportedDatabases(new Class[]{DerbyDictionary.class, OracleDictionary.class, DB2Dictionary.class});
        if (this.isTestsDisabled()) {
            return;
        }
        this.setUp(new Object[]{LSE1x1Lf.class, LSE1x1LfLzy.class, LSE1x1LfJT.class, LSE1x1LfJTLzy.class, LSE1x1Rt.class, "openjpa.LockManager", "mixed", "openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)"});
        this.commonSetUp(LSE1x1Lf.class, LSE1x1LfLzy.class, LSE1x1LfJT.class, LSE1x1LfJTLzy.class, LSE1x1Rt.class);
    }

    public void testNormalUni1x1Lock() {
        this.common1x1Lock("testNormalUni1x1Lock", 1111201, false);
    }

    public void testExtendedUni1x1Lock() {
        this.common1x1Lock("testExtendedUni1x1Lock", 1111211, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void common1x1Lock(String testName, int idLf0, boolean extended) {
        String tableLfName = "LSE1x1Lf";
        String tableRtName = "LSE1x1Rt";
        String joinTables = "LSE1x1Lf.*JOIN.*LSE1x1Rt";
        this.getLog().info((Object)("** " + testName + "()"));
        String scope = extended ? "Extended" : "Normal";
        int idRt0 = idLf0 + 10000;
        int idLf1 = idLf0 + 1;
        int idRt1 = idRt0 + 1;
        LSE1x1Lf eLf0 = new LSE1x1Lf();
        LSE1x1Rt eRt0 = new LSE1x1Rt();
        eLf0.setId(idLf0);
        eLf0.setFirstName("firstName " + idLf0);
        eLf0.setUniRight(eRt0);
        eRt0.setId(idRt0);
        eRt0.setLastName("lastName " + idRt0);
        LSE1x1Lf eLf1 = new LSE1x1Lf();
        LSE1x1Rt eRt1 = new LSE1x1Rt();
        eLf1.setId(idLf1);
        eLf1.setFirstName("firstName " + idLf1);
        eLf1.setUniRight(eRt1);
        eRt1.setId(idRt1);
        eRt1.setLastName("lastName " + idRt1);
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)eLf0);
            em.persist((Object)eRt0);
            em.persist((Object)eLf1);
            em.persist((Object)eRt1);
            em.getTransaction().commit();
        }
        finally {
            em = null;
            eLf1 = null;
            eLf0 = null;
            eRt1 = null;
            eRt0 = null;
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        this.commonLockTest(testName, LSE1x1Lf.class, idLf0, extended, "SELECT c FROM LSE1x1Lf c WHERE c.firstName LIKE :firstName", "findLSE1x1Lf" + scope, new LockScopeTestCase.AssertCallback(){

            @Override
            public void findNoLockDbSQL(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*LSE1x1Rt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void findPessimisticForcIncDbSQL(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1Lf.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}");
                        Test1x1LockScope.this.assertLockTestNoSQLs("SELECT.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    case oracle: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*LSE1x1Rt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*(JOIN){0}.*LSE1x1Lf.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1Lf.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}");
                        Test1x1LockScope.this.assertLockTestNoSQLs("SELECT.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void queryPessimisticReadDbSQL(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1Lf.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}");
                        Test1x1LockScope.this.assertLockTestNoSQLs("SELECT.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    case oracle: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*LSE1x1Rt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*(JOIN){0}.*LSE1x1Lf.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1Lf.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}");
                        Test1x1LockScope.this.assertLockTestNoSQLs("SELECT.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterQueryPessimisticReadDbSQL(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*LSE1x1Rt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void namedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1Lf.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}");
                        Test1x1LockScope.this.assertLockTestNoSQLs("SELECT.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    case oracle: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*LSE1x1Rt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*(JOIN){0}.*LSE1x1Lf.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1Lf.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}");
                        Test1x1LockScope.this.assertLockTestNoSQLs("SELECT.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterNamedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*LSE1x1Rt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1Lf.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }
        });
    }

    public void testNormalUni1x1LazyLock() {
        this.common1x1LazyLock("testNormalUni1x1LazyLock", 1111101, false);
    }

    public void testExtendedUni1x1LazyLock() {
        this.common1x1LazyLock("testExtendedUni1x1LazyLock", 1111111, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void common1x1LazyLock(String testName, int idLf0, boolean extended) {
        String tableLfName = "LSE1x1LfLzy";
        this.getLog().info((Object)("** " + testName + "()"));
        String scope = extended ? "Extended" : "Normal";
        int idRt0 = idLf0 + 10000;
        int idLf1 = idLf0 + 1;
        int idRt1 = idRt0 + 1;
        LSE1x1LfLzy eLf0 = new LSE1x1LfLzy();
        LSE1x1Rt eRt0 = new LSE1x1Rt();
        eLf0.setId(idLf0);
        eLf0.setFirstName("firstName " + idLf0);
        eLf0.setUniRight(eRt0);
        eRt0.setId(idRt0);
        eRt0.setLastName("lastName " + idRt0);
        LSE1x1LfLzy eLf1 = new LSE1x1LfLzy();
        LSE1x1Rt eRt1 = new LSE1x1Rt();
        eLf1.setId(idLf1);
        eLf1.setFirstName("firstName " + idLf1);
        eLf1.setUniRight(eRt1);
        eRt1.setId(idRt1);
        eRt1.setLastName("lastName " + idRt1);
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)eLf0);
            em.persist((Object)eRt0);
            em.persist((Object)eLf1);
            em.persist((Object)eRt1);
            em.getTransaction().commit();
        }
        finally {
            em = null;
            eLf1 = null;
            eLf0 = null;
            eRt1 = null;
            eRt0 = null;
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        this.commonLockTest(testName, LSE1x1LfLzy.class, idLf0, extended, "SELECT c FROM LSE1x1LfLzy c WHERE c.firstName LIKE :firstName", "findLSE1x1LfLzy" + scope, new LockScopeTestCase.AssertCallback(){

            @Override
            public void findNoLockDbSQL(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfLzy.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfLzy.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void findPessimisticForcIncDbSQL(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfLzy.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfLzy.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void queryPessimisticReadDbSQL(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfLzy.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfLzy.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterQueryPessimisticReadDbSQL(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfLzy.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfLzy.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void namedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfLzy.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfLzy.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterNamedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfLzy.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfLzy.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }
        });
    }

    public void testNormalUni1x1JTLock() {
        this.common1x1JTLock("testNormalUni1x1JTLock", 1112201, false);
    }

    public void testExtendedUni1x1JTLock() {
        this.common1x1JTLock("testExtendedUni1x1JTLock", 1112211, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void common1x1JTLock(String testName, int idLf0, boolean extended) {
        String tableLfName = "LSE1x1LfJT";
        String tableJTName = "Uni1x1LfJT_Uni1x1RT";
        String tableRtName = "LSE1x1Rt";
        String joinTables = "LSE1x1LfJT.*JOIN.*Uni1x1LfJT_Uni1x1RT.*JOIN.*LSE1x1Rt";
        this.getLog().info((Object)("** " + testName + "()"));
        String scope = extended ? "Extended" : "Normal";
        int idRt0 = idLf0 + 10000;
        int idLf1 = idLf0 + 1;
        int idRt1 = idRt0 + 1;
        LSE1x1LfJT eLf0 = new LSE1x1LfJT();
        LSE1x1Rt eRt0 = new LSE1x1Rt();
        eLf0.setId(idLf0);
        eLf0.setFirstName("firstName " + idLf0);
        eLf0.setUniRightJT(eRt0);
        eRt0.setId(idRt0);
        eRt0.setLastName("lastName " + idRt0);
        LSE1x1LfJT eLf1 = new LSE1x1LfJT();
        LSE1x1Rt eRt1 = new LSE1x1Rt();
        eLf1.setId(idLf1);
        eLf1.setFirstName("firstName " + idLf1);
        eLf1.setUniRightJT(eRt1);
        eRt1.setId(idRt1);
        eRt1.setLastName("lastName " + idRt1);
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)eLf0);
            em.persist((Object)eRt0);
            em.persist((Object)eLf1);
            em.persist((Object)eRt1);
            em.getTransaction().commit();
        }
        finally {
            em = null;
            eLf1 = null;
            eLf0 = null;
            eRt1 = null;
            eRt0 = null;
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        this.commonLockTest(testName, LSE1x1LfJT.class, idLf0, extended, "SELECT c FROM LSE1x1LfJT c WHERE c.firstName LIKE :firstName", "findLSE1x1LfJT" + scope, new LockScopeTestCase.AssertCallback(){

            @Override
            public void findNoLockDbSQL(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*JOIN.*Uni1x1LfJT_Uni1x1RT.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*Uni1x1LfJT_Uni1x1RT.*LSE1x1Rt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*JOIN.*Uni1x1LfJT_Uni1x1RT.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void findPessimisticForcIncDbSQL(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*JOIN.*Uni1x1LfJT_Uni1x1RT.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1LfJT.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}");
                        Test1x1LockScope.this.assertLockTestNoSQLs("SELECT.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    case oracle: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*Uni1x1LfJT_Uni1x1RT.*LSE1x1Rt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*JOIN.*Uni1x1LfJT_Uni1x1RT.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*(JOIN){0}.*LSE1x1LfJT.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1LfJT.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}");
                        Test1x1LockScope.this.assertLockTestNoSQLs("SELECT.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*JOIN.*Uni1x1LfJT_Uni1x1RT.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void queryPessimisticReadDbSQL(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*JOIN.*Uni1x1LfJT_Uni1x1RT.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1LfJT.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}");
                        Test1x1LockScope.this.assertLockTestNoSQLs("SELECT.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    case oracle: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*Uni1x1LfJT_Uni1x1RT.*LSE1x1Rt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*JOIN.*Uni1x1LfJT_Uni1x1RT.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*(JOIN){0}.*LSE1x1LfJT.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1LfJT.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}");
                        Test1x1LockScope.this.assertLockTestNoSQLs("SELECT.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*JOIN.*Uni1x1LfJT_Uni1x1RT.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterQueryPessimisticReadDbSQL(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*JOIN.*Uni1x1LfJT_Uni1x1RT.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*Uni1x1LfJT_Uni1x1RT.*LSE1x1Rt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*JOIN.*Uni1x1LfJT_Uni1x1RT.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void namedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*JOIN.*Uni1x1LfJT_Uni1x1RT.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1LfJT.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}");
                        Test1x1LockScope.this.assertLockTestNoSQLs("SELECT.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    case oracle: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*Uni1x1LfJT_Uni1x1RT.*LSE1x1Rt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){1}");
                        break;
                    }
                    case derby: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*JOIN.*Uni1x1LfJT_Uni1x1RT.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*FROM.*(JOIN){0}.*LSE1x1LfJT.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1LfJT.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}", "SELECT.*version.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){0}");
                        Test1x1LockScope.this.assertLockTestNoSQLs("SELECT.*FROM.*(JOIN){0}.*LSE1x1Rt.*(JOIN){0}.*WHERE.*(FOR UPDATE.*){1}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*JOIN.*Uni1x1LfJT_Uni1x1RT.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterNamedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*JOIN.*Uni1x1LfJT_Uni1x1RT.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    case oracle: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*Uni1x1LfJT_Uni1x1RT.*LSE1x1Rt.*WHERE.*\\(\\+\\).*(FOR UPDATE.*){0}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJT.*JOIN.*Uni1x1LfJT_Uni1x1RT.*JOIN.*LSE1x1Rt.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }
        });
    }

    public void testNormalUni1x1JTLazyLock() {
        this.common1x1JTLazyLock("testNormalUni1x1JTLazyLock", 1112101, false);
    }

    public void testExtendedUni1x1JTLazyLock() {
        this.common1x1JTLazyLock("testExtendedUni1x1JTLazyLock", 1112111, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void common1x1JTLazyLock(String testName, int idLf0, boolean extended) {
        String tableLfName = "LSE1x1LfJTLzy";
        this.getLog().info((Object)("** " + testName + "()"));
        String scope = extended ? "Extended" : "Normal";
        int idRt0 = idLf0 + 10000;
        int idLf1 = idLf0 + 1;
        int idRt1 = idRt0 + 1;
        LSE1x1LfJTLzy eLf0 = new LSE1x1LfJTLzy();
        LSE1x1Rt eRt0 = new LSE1x1Rt();
        eLf0.setId(idLf0);
        eLf0.setFirstName("firstName " + idLf0);
        eLf0.setUniRightJT(eRt0);
        eRt0.setId(idRt0);
        eRt0.setLastName("lastName " + idRt0);
        LSE1x1LfJTLzy eLf1 = new LSE1x1LfJTLzy();
        LSE1x1Rt eRt1 = new LSE1x1Rt();
        eLf1.setId(idLf1);
        eLf1.setFirstName("firstName " + idLf1);
        eLf1.setUniRightJT(eRt1);
        eRt1.setId(idRt1);
        eRt1.setLastName("lasttName " + idRt1);
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)eLf0);
            em.persist((Object)eRt0);
            em.persist((Object)eLf1);
            em.persist((Object)eRt1);
            em.getTransaction().commit();
        }
        finally {
            em = null;
            eLf1 = null;
            eLf0 = null;
            eRt1 = null;
            eRt0 = null;
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        this.commonLockTest(testName, LSE1x1LfJTLzy.class, idLf0, extended, "SELECT c FROM LSE1x1LfJTLzy c WHERE c.firstName LIKE :firstName", "findLSE1x1LfJTLzy" + scope, new LockScopeTestCase.AssertCallback(){

            @Override
            public void findNoLockDbSQL(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJTLzy.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJTLzy.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void findPessimisticForcIncDbSQL(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJTLzy.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJTLzy.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void queryPessimisticReadDbSQL(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJTLzy.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJTLzy.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterQueryPessimisticReadDbSQL(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJTLzy.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJTLzy.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }

            @Override
            public void namedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJTLzy.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){1}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJTLzy.*WHERE.*(FOR UPDATE.*){1}");
                    }
                }
            }

            @Override
            public void findNoLockAfterNamedQueryPessimisticWriteDbSql(EntityManager em) {
                switch (Test1x1LockScope.this.getDBType(em)) {
                    case db2: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJTLzy.*WHERE.*(FOR UPDATE.*|FOR READ ONLY WITH R. USE AND KEEP (UPDATE|EXCLUSIVE) LOCKS){0}");
                        break;
                    }
                    default: {
                        Test1x1LockScope.this.assertLockTestSQLs("SELECT.*FROM.*LSE1x1LfJTLzy.*WHERE.*(FOR UPDATE.*){0}");
                    }
                }
            }
        });
    }
}

