/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.reservedwords;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;

public class ReservedWordsIT
extends AbstractPersistenceTestCase {
    private static OpenJPAEntityManagerFactory _emf;

    public void setUp() throws Exception {
        super.setUp();
        _emf = this.createEMF(new Object[0]);
    }

    @Override
    public void tearDown() throws Exception {
        this.closeEMF((EntityManagerFactory)_emf);
        _emf = null;
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReservedColumnWords() throws Exception {
        ArrayList<String> reservedColumnWords = new ArrayList<String>();
        DBDictionary dict = ((JDBCConfiguration)_emf.getConfiguration()).getDBDictionaryInstance();
        OpenJPAEntityManager em = null;
        for (String word : this.getReservedWords()) {
            try {
                em = _emf.createEntityManager();
                em.getTransaction().begin();
                Query qryCreate = em.createNativeQuery("CREATE TABLE RESERVEDW_TST (" + word + " CHAR(2))");
                qryCreate.executeUpdate();
                em.getTransaction().commit();
                em.getTransaction().begin();
                Query qryDrop = em.createNativeQuery("DROP TABLE RESERVEDW_TST");
                qryDrop.executeUpdate();
                em.getTransaction().commit();
                em.close();
            }
            catch (Exception e) {
                reservedColumnWords.add(word);
                em.getTransaction().rollback();
            }
            finally {
                if (em == null || !em.isOpen()) continue;
                em.close();
            }
        }
        Log log = this.getLog();
        try (OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream("target/reserved_words_" + dict.getClass().getSimpleName() + ".java"));){
            log.info((Object)("FOUND " + reservedColumnWords.size() + " RESERVED WORDS for Dictionary " + dict.getClass().getName()));
            osw.append("// reservedWordSet subset that CANNOT be used as valid column names\n// (i.e., without surrounding them with double-quotes)\n// generated at " + LocalDateTime.now() + " via " + ReservedWordsIT.class.getName() + "\ninvalidColumnWordSet.addAll(Arrays.asList(new String[] {\n");
            StringBuilder sb = new StringBuilder();
            sb.append("    ");
            for (String reservedColumnWord : reservedColumnWords) {
                log.info((Object)reservedColumnWord);
                sb.append('\"').append(reservedColumnWord).append("\", ");
                if (sb.length() <= 110) continue;
                osw.append(sb.toString().trim()).append('\n');
                sb.setLength(0);
            }
            if (sb.length() > 0) {
                osw.append(sb.toString().trim()).append('\n');
            }
            osw.append("}));");
            osw.flush();
        }
        log.info((Object)"******* END RESERVED WORDS *******");
    }

    private List<String> getReservedWords() {
        ArrayList<String> reservedWords = new ArrayList<String>(2000);
        try (InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/openjpa/reservedwords/sql_reserved_words.txt");){
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
                if (line.contains(" ")) {
                    throw new RuntimeException("only one reserved word per line please! got: " + line);
                }
                reservedWords.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return reservedWords;
    }

    private Log getLog() {
        return _emf.getConfiguration().getLog("Tests");
    }
}

