/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.xs;

import java.math.BigDecimal;
import javax.persistence.EntityTransaction;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;
import org.apache.openjpa.persistence.xs.AccountingHierarchy;
import org.apache.openjpa.persistence.xs.AccountingHierarchyRate;

public class TestMergeComplexKey
extends SingleEMFTestCase {
    Object[] props = new Object[]{AccountingHierarchy.class, AccountingHierarchyRate.class, CLEAR_TABLES};

    @Override
    public void setUp() throws Exception {
        this.setUp(this.props);
    }

    public void test() throws Exception {
        this.createDate();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        AccountingHierarchy accountingHierarchy = (AccountingHierarchy)em.find(AccountingHierarchy.class, (Object)"TESTING");
        accountingHierarchy.setShortDesc("NAME:" + System.currentTimeMillis());
        accountingHierarchy = TestMergeComplexKey.roundtrip(accountingHierarchy);
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        try {
            em.merge((Object)accountingHierarchy);
        }
        catch (RuntimeException e) {
            em.getTransaction().setRollbackOnly();
            throw e;
        }
        finally {
            if (em.getTransaction().getRollbackOnly()) {
                em.getTransaction().rollback();
            } else {
                em.getTransaction().commit();
            }
        }
    }

    void createDate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        System.out.println(em.createQuery("select o from AccountingHierarchy o").getResultList().size());
        String code = "TESTING";
        AccountingHierarchy accountingHierarchy = (AccountingHierarchy)em.find(AccountingHierarchy.class, (Object)code);
        if (accountingHierarchy == null) {
            accountingHierarchy = new AccountingHierarchy();
            accountingHierarchy.setCode(code);
            accountingHierarchy.setShortDesc("TESTING");
            AccountingHierarchyRate accountingHierarchyRate = new AccountingHierarchyRate("1", accountingHierarchy, BigDecimal.ONE, BigDecimal.TEN);
            accountingHierarchy.getAccRateList().add(accountingHierarchyRate);
            EntityTransaction tx = em.getTransaction();
            tx.begin();
            try {
                em.persist((Object)accountingHierarchy);
            }
            catch (RuntimeException e) {
                tx.setRollbackOnly();
                throw e;
            }
            finally {
                if (tx.getRollbackOnly()) {
                    tx.rollback();
                } else {
                    tx.commit();
                }
            }
        }
    }
}

