/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.xml;

import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.util.GeneralException;
import org.junit.Test;

public class TestSchemaVersionValidation {
    @Test
    public void test2_0PersistenceXml() {
        this.doCreateEmf("XSDTest", "persistence-2_0.xml", false);
    }

    @Test(expected=Exception.class)
    public void testBad2_0PersistenceXml() {
        this.doCreateEmf(null, "persistence-2_0-no-pu.xml", false);
    }

    @Test
    public void test2_0Persistence1_0OrmXml() {
        this.doCreateEmf("XSDTest", "persistence-2_0-orm-1_0.xml");
    }

    @Test
    public void test2_0Persistence2_0OrmXml() {
        this.doCreateEmf("XSDTest", "persistence-2_0-orm-2_0.xml");
    }

    @Test
    public void test1_0Persistence2_0OrmXml() {
        this.doCreateEmf("XSDTest", "persistence-2_0-orm-1_0.xml");
    }

    @Test(expected=GeneralException.class)
    public void testOffline66_6Persistence2_2OrmXml() {
        this.doCreateEmf("XSDTest", "offline_persistence-66_6-orm-2_2.xml");
    }

    @Test
    public void testOffline2_1Persistence2_2OrmXml() {
        this.doCreateEmf("XSDTest", "offline_persistence-2_1-orm-2_2.xml");
    }

    private void doCreateEmf(String name, String xml) {
        this.doCreateEmf(name, xml, true);
    }

    private void doCreateEmf(String name, String xml, boolean createEm) {
        OpenJPAEntityManagerFactory emf = OpenJPAPersistence.createEntityManagerFactory((String)name, (String)("org/apache/openjpa/persistence/xml/" + xml));
        if (createEm) {
            OpenJPAEntityManager em = emf.createEntityManager();
            em.close();
        }
        emf.close();
    }
}

