/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.test;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import org.apache.openjpa.persistence.PersistenceProviderImpl;
import org.apache.openjpa.persistence.entity.EntityA;
import org.apache.openjpa.persistence.entity.EntityB;
import org.apache.openjpa.persistence.entity.EntityC;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestPersistenceProviderFilteringTestCase
extends SQLListenerTestCase {
    private final String persistenceUnitName = "test";

    @Override
    public void setUp() {
        this.setUp(DROP_TABLES, EntityA.class, EntityB.class, EntityC.class);
    }

    public void testGenerateSchemaNoProvider() {
        PersistenceProviderImpl ppi = new PersistenceProviderImpl();
        HashMap map = new HashMap();
        TestPersistenceProviderFilteringTestCase.assertTrue((boolean)ppi.generateSchema("test", map));
    }

    public void testGenerateSchemaOpenJPAProvider() {
        PersistenceProviderImpl ppi = new PersistenceProviderImpl();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("javax.persistence.provider", PersistenceProviderImpl.class.getName());
        TestPersistenceProviderFilteringTestCase.assertTrue((boolean)ppi.generateSchema("test", map));
    }

    public void testGenerateSchemaEclipseProvider() {
        PersistenceProviderImpl ppi = new PersistenceProviderImpl();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("javax.persistence.provider", "org.eclipse.persistence.jpa.PersistenceProvider");
        TestPersistenceProviderFilteringTestCase.assertFalse((boolean)ppi.generateSchema("test", map));
    }

    public void testGenerateSchemaFakeProviderClass() {
        PersistenceProviderImpl ppi = new PersistenceProviderImpl();
        HashMap<String, Class<FakeProvider>> map = new HashMap<String, Class<FakeProvider>>();
        map.put("javax.persistence.provider", FakeProvider.class);
        TestPersistenceProviderFilteringTestCase.assertFalse((boolean)ppi.generateSchema("test", map));
    }

    public static final class FakeProvider
    implements PersistenceProvider {
        public EntityManagerFactory createEntityManagerFactory(String s, Map map) {
            return null;
        }

        public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo persistenceUnitInfo, Map map) {
            return null;
        }

        public void generateSchema(PersistenceUnitInfo persistenceUnitInfo, Map map) {
        }

        public boolean generateSchema(String s, Map map) {
            return false;
        }

        public ProviderUtil getProviderUtil() {
            return null;
        }
    }
}

