/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.test;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.kernel.AbstractBrokerFactory;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;

public abstract class AbstractCachedEMFTestCase
extends AbstractPersistenceTestCase {
    private static FixedMap<EMFKey, OpenJPAEntityManagerFactorySPI> _emfs = new FixedMap();

    @Override
    protected OpenJPAEntityManagerFactorySPI createNamedEMF(String pu, Object ... props) {
        Map<String, Object> map = this.getPropertiesMap(props);
        EMFKey key = new EMFKey(pu, map);
        OpenJPAEntityManagerFactorySPI oemf = (OpenJPAEntityManagerFactorySPI)_emfs.get(key);
        if (this._fresh || oemf == null || !oemf.isOpen()) {
            oemf = super.createNamedEMF(pu, props);
            if (!this._fresh) {
                _emfs.put(key, oemf);
            }
        }
        this._fresh = false;
        return oemf;
    }

    @Override
    protected OpenJPAEntityManagerFactorySPI createNamedOpenJPAEMF(String pu, String res, Map<String, Object> props) {
        EMFKey key = new EMFKey(pu, props);
        OpenJPAEntityManagerFactorySPI oemf = (OpenJPAEntityManagerFactorySPI)_emfs.get(key);
        if (this._fresh || oemf == null || !oemf.isOpen()) {
            oemf = super.createNamedOpenJPAEMF(pu, res, props);
            if (!this._fresh) {
                _emfs.put(key, oemf);
            }
        }
        this._fresh = false;
        return oemf;
    }

    private static class EMFKey {
        final String unit;
        final Map<String, Object> config;

        EMFKey(String unit, Map<String, Object> config) {
            this.unit = unit;
            this.config = config;
        }

        public int hashCode() {
            return (this.unit != null ? this.unit.hashCode() : 0) + this.config.hashCode();
        }

        public boolean equals(Object other) {
            EMFKey that = (EMFKey)other;
            return (this.unit != null ? this.unit.equals(that.unit) : that.unit == null) && this.config.equals(that.config);
        }
    }

    private static class FixedMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -3153852097468390779L;

        private FixedMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
            OpenJPAEntityManagerFactorySPI oemf = (OpenJPAEntityManagerFactorySPI)entry.getValue();
            if (this.size() > 2) {
                if (oemf != null && oemf.isOpen()) {
                    try {
                        for (Broker b : ((AbstractBrokerFactory)JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)oemf)).getOpenBrokers()) {
                            OpenJPAEntityManager em;
                            if (b == null || b.isClosed() || (em = JPAFacadeHelper.toEntityManager((Broker)b)) == null || !em.isOpen()) continue;
                            if (em.getTransaction().isActive()) {
                                em.getTransaction().rollback();
                            }
                            em.close();
                        }
                        oemf.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return true;
            }
            return false;
        }
    }
}

