/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.temporal;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.temporal.TemporalEntity;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestTemporalTimestamp
extends SQLListenerTestCase {
    private OpenJPAEntityManager em;
    final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    @Override
    public void setUp() {
        this.setSupportedDatabases(DerbyDictionary.class, DB2Dictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        this.setUp(CLEAR_TABLES, TemporalEntity.class, "openjpa.jdbc.DBDictionary", "DateMillisecondBehavior=" + DBDictionary.DateMillisecondBehaviors.DROP, "openjpa.Log", "SQL=TRACE,Tests=TRACE", "openjpa.ConnectionFactoryProperties", "PrintParameters=true");
        TestTemporalTimestamp.assertNotNull((Object)this.emf);
        this.loadDB();
    }

    public void testNoRounding() {
        this.em = this.emf.createEntityManager();
        List<TemporalEntity> temporalEntityList = this.findAll((EntityManager)this.em);
        TestTemporalTimestamp.assertNotNull(temporalEntityList);
        TestTemporalTimestamp.assertNotEquals(temporalEntityList.size(), 0);
        for (TemporalEntity temporalEntity : temporalEntityList) {
            Date testDate = temporalEntity.getTestDate();
            TestTemporalTimestamp.assertEquals((int)testDate.getDay(), (int)5);
            TestTemporalTimestamp.assertEquals((int)testDate.getMonth(), (int)11);
            TestTemporalTimestamp.assertEquals((int)testDate.getDate(), (int)31);
            TestTemporalTimestamp.assertEquals((int)testDate.getHours(), (int)23);
            TestTemporalTimestamp.assertEquals((int)testDate.getMinutes(), (int)59);
            TestTemporalTimestamp.assertEquals((int)testDate.getSeconds(), (int)59);
            TestTemporalTimestamp.assertEquals((int)testDate.getYear(), (int)8099);
            TestTemporalTimestamp.assertTrue((boolean)this.sdf.format(testDate).toString().endsWith(".000"));
        }
        this.em.close();
    }

    public void testNoRoundingNoMillisecondLoss() {
        JDBCConfiguration conf = (JDBCConfiguration)this.emf.getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        dict.setDateMillisecondBehavior(DBDictionary.DateMillisecondBehaviors.RETAIN.toString());
        this.em = this.emf.createEntityManager();
        List<TemporalEntity> temporalEntityList = this.findAll((EntityManager)this.em);
        TestTemporalTimestamp.assertNotNull(temporalEntityList);
        TestTemporalTimestamp.assertNotEquals(temporalEntityList.size(), 0);
        for (TemporalEntity temporalEntity : temporalEntityList) {
            Date testDate = temporalEntity.getTestDate();
            TestTemporalTimestamp.assertEquals((int)testDate.getDay(), (int)5);
            TestTemporalTimestamp.assertEquals((int)testDate.getMonth(), (int)11);
            TestTemporalTimestamp.assertEquals((int)testDate.getDate(), (int)31);
            TestTemporalTimestamp.assertEquals((int)testDate.getHours(), (int)23);
            TestTemporalTimestamp.assertEquals((int)testDate.getMinutes(), (int)59);
            TestTemporalTimestamp.assertEquals((int)testDate.getSeconds(), (int)59);
            TestTemporalTimestamp.assertEquals((int)testDate.getYear(), (int)8099);
            TestTemporalTimestamp.assertTrue((boolean)this.sdf.format(testDate).toString().endsWith(".999"));
            System.out.println("sdf.format(testDate).toString() = " + this.sdf.format(testDate).toString());
        }
        this.em.close();
    }

    public void testRounding() {
        JDBCConfiguration conf = (JDBCConfiguration)this.emf.getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        dict.setDateMillisecondBehavior(DBDictionary.DateMillisecondBehaviors.ROUND.toString());
        this.em = this.emf.createEntityManager();
        List<TemporalEntity> temporalEntityList = this.findAll((EntityManager)this.em);
        TestTemporalTimestamp.assertNotNull(temporalEntityList);
        TestTemporalTimestamp.assertNotEquals(temporalEntityList.size(), 0);
        for (TemporalEntity temporalEntity : temporalEntityList) {
            Date testDate = temporalEntity.getTestDate();
            TestTemporalTimestamp.assertEquals((int)testDate.getDay(), (int)6);
            TestTemporalTimestamp.assertEquals((int)testDate.getMonth(), (int)0);
            TestTemporalTimestamp.assertEquals((int)testDate.getDate(), (int)1);
            TestTemporalTimestamp.assertEquals((int)testDate.getHours(), (int)0);
            TestTemporalTimestamp.assertEquals((int)testDate.getMinutes(), (int)0);
            TestTemporalTimestamp.assertEquals((int)testDate.getSeconds(), (int)0);
            TestTemporalTimestamp.assertEquals((int)testDate.getYear(), (int)8100);
            TestTemporalTimestamp.assertTrue((boolean)this.sdf.format(testDate).toString().endsWith(".000"));
        }
        this.em.close();
    }

    public List<TemporalEntity> findAll(EntityManager em) {
        CriteriaQuery critQuery = em.getCriteriaBuilder().createQuery(TemporalEntity.class);
        critQuery.from(TemporalEntity.class);
        TypedQuery typedQuery = em.createQuery(critQuery);
        return typedQuery.getResultList();
    }

    private void loadDB() {
        this.em = this.emf.createEntityManager();
        this.em.getTransaction().begin();
        String sql = "INSERT INTO TemporalEntity (Id, testDate) VALUES (1, '9999-12-31 23:59:59.9999')";
        this.em.createNativeQuery(sql).executeUpdate();
        sql = "INSERT INTO TemporalEntity (Id, testDate) VALUES (2, '9999-12-31 23:59:59.9996')";
        this.em.createNativeQuery(sql).executeUpdate();
        this.em.getTransaction().commit();
        this.em.close();
    }
}

