/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.strategy.value;

import java.io.Serializable;
import java.security.Principal;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.strats.AbstractValueHandler;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;

public class PrincipalValueStrategyHandler
extends AbstractValueHandler {
    private static final long serialVersionUID = 8371304701543038775L;
    private static final PrincipalValueStrategyHandler _instance = new PrincipalValueStrategyHandler();

    public static PrincipalValueStrategyHandler getInstance() {
        return _instance;
    }

    public Column[] map(ValueMapping arg0, String name, ColumnIO arg2, boolean arg3) {
        Column col = new Column();
        col.setName(name);
        col.setJavaType(9);
        return new Column[]{col};
    }

    public Object toDataStoreValue(ValueMapping vm, Object val, JDBCStore store) {
        if (val instanceof Principal) {
            return ((Principal)val).getName();
        }
        return null;
    }

    public Object toObjectValue(ValueMapping vm, Object val) {
        if (val == null || !(val instanceof String)) {
            return null;
        }
        return new TestPrincipal((String)val);
    }

    public static class TestPrincipal
    implements Principal,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;

        public TestPrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

