/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.simple;

import java.util.HashMap;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;

public class TestMissingMetaData
extends TestCase {
    private OpenJPAEntityManagerFactory emf;

    public void setUp() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.RuntimeUnenhancedClasses", "supported");
        this.emf = OpenJPAPersistence.createEntityManagerFactory((String)"test-missing-metadata", (String)"persistence2.xml", props);
    }

    public void testMissingMetaData() {
        String msg = "No registered metadata for type \"class org.apache.openjpa.persistence.simple.Animal\".";
        try {
            this.emf.createEntityManager();
            TestMissingMetaData.fail((String)("didn't receive expected ArgumentException - " + msg));
        }
        catch (Exception e) {
            TestMissingMetaData.assertEquals(ArgumentException.class, e.getClass());
            TestMissingMetaData.assertTrue((String)("Unexpected Exception : " + e.getMessage()), (boolean)e.getMessage().startsWith(msg));
        }
    }

    public void tearDown() {
        this.emf.close();
        this.emf = null;
    }

    public static void main(String[] args) {
        TestRunner.run(TestMissingMetaData.class);
    }
}

