/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.simple;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.simple.Java8TimeTypes;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestJava8TimeTypes
extends SingleEMFTestCase {
    private static String VAL_LOCAL_DATE = "2019-01-01";
    private static String VAL_LOCAL_TIME = "04:57:15";
    private static String VAL_LOCAL_DATETIME = "2019-01-01T01:00:00";
    private Java8TimeTypes insertedEntity = new Java8TimeTypes();

    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES, Java8TimeTypes.class);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.insertedEntity.setId(1);
        this.insertedEntity.setOldDateField(new Date());
        this.insertedEntity.setLocalTimeField(LocalTime.parse(VAL_LOCAL_TIME));
        this.insertedEntity.setLocalDateField(LocalDate.parse(VAL_LOCAL_DATE));
        this.insertedEntity.setLocalDateTimeField(LocalDateTime.parse(VAL_LOCAL_DATETIME));
        this.insertedEntity.setOffsetTimeField(this.insertedEntity.getLocalTimeField().atOffset(ZoneOffset.ofHours(-9)));
        this.insertedEntity.setOffsetDateTimeField(this.insertedEntity.getLocalDateTimeField().atOffset(ZoneOffset.ofHours(-9)));
        em.persist((Object)this.insertedEntity);
        em.getTransaction().commit();
        em.close();
    }

    public void testReadJava8Types() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Java8TimeTypes eRead = (Java8TimeTypes)em.find(Java8TimeTypes.class, (Object)1);
        TestJava8TimeTypes.assertEquals((Object)LocalTime.parse(VAL_LOCAL_TIME), (Object)eRead.getLocalTimeField());
        TestJava8TimeTypes.assertEquals((Object)LocalDate.parse(VAL_LOCAL_DATE), (Object)eRead.getLocalDateField());
        TestJava8TimeTypes.assertEquals((Object)LocalDateTime.parse(VAL_LOCAL_DATETIME), (Object)eRead.getLocalDateTimeField());
        TestJava8TimeTypes.assertEquals((Object)Instant.from(this.insertedEntity.getOffsetDateTimeField()), (Object)Instant.from(eRead.getOffsetDateTimeField()));
        TestJava8TimeTypes.assertEquals((Object)this.insertedEntity.getOffsetTimeField().withOffsetSameInstant(eRead.getOffsetTimeField().getOffset()), (Object)eRead.getOffsetTimeField());
        em.close();
    }

    public void testReadLocalDate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TypedQuery qry = em.createQuery("select t.localDateField from Java8TimeTypes AS t", LocalDate.class);
        LocalDate date = (LocalDate)qry.getSingleResult();
        TestJava8TimeTypes.assertNotNull((Object)date);
        em.close();
    }

    public void testMaxLocalDate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TypedQuery qry = em.createQuery("select max(t.localDateField) from Java8TimeTypes AS t", LocalDate.class);
        LocalDate max = (LocalDate)qry.getSingleResult();
        TestJava8TimeTypes.assertEquals((Object)LocalDate.parse(VAL_LOCAL_DATE), (Object)max);
        em.close();
    }

    public void testMaxLocalDateTime() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TypedQuery qry = em.createQuery("select max(t.localDateTimeField) from Java8TimeTypes AS t", LocalDateTime.class);
        LocalDateTime max = (LocalDateTime)qry.getSingleResult();
        TestJava8TimeTypes.assertEquals((Object)LocalDateTime.parse(VAL_LOCAL_DATETIME), (Object)max);
        em.close();
    }

    public void testMaxLocalTime() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TypedQuery qry = em.createQuery("select max(t.localTimeField) from Java8TimeTypes AS t", LocalTime.class);
        LocalTime max = (LocalTime)qry.getSingleResult();
        TestJava8TimeTypes.assertEquals((Object)LocalTime.parse(VAL_LOCAL_TIME), (Object)max);
        em.close();
    }

    public void testMaxOffsetTime() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TypedQuery qry = em.createQuery("select max(t.offsetTimeField) from Java8TimeTypes AS t", OffsetTime.class);
        OffsetTime max = (OffsetTime)qry.getSingleResult();
        TestJava8TimeTypes.assertEquals((Object)this.insertedEntity.getOffsetTimeField().withOffsetSameInstant(this.insertedEntity.getOffsetTimeField().getOffset()), (Object)max.withOffsetSameInstant(this.insertedEntity.getOffsetTimeField().getOffset()));
        em.close();
    }

    public void testMaxOffsetDateTime() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TypedQuery qry = em.createQuery("select max(t.offsetDateTimeField) from Java8TimeTypes AS t", OffsetDateTime.class);
        OffsetDateTime max = (OffsetDateTime)qry.getSingleResult();
        TestJava8TimeTypes.assertEquals((Object)Instant.from(this.insertedEntity.getOffsetDateTimeField()), (Object)Instant.from(max));
        em.close();
    }

    public void testMinLocalDate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TypedQuery qry = em.createQuery("select min(t.localDateField) from Java8TimeTypes AS t", LocalDate.class);
        LocalDate min = (LocalDate)qry.getSingleResult();
        TestJava8TimeTypes.assertEquals((Object)LocalDate.parse(VAL_LOCAL_DATE), (Object)min);
    }

    public void testMinLocalDateTime() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TypedQuery qry = em.createQuery("select min(t.localDateTimeField) from Java8TimeTypes AS t", LocalDateTime.class);
        LocalDateTime min = (LocalDateTime)qry.getSingleResult();
        TestJava8TimeTypes.assertEquals((Object)LocalDateTime.parse(VAL_LOCAL_DATETIME), (Object)min);
        em.close();
    }

    public void testMinLocalTime() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TypedQuery qry = em.createQuery("select min(t.localTimeField) from Java8TimeTypes AS t", LocalTime.class);
        LocalTime min = (LocalTime)qry.getSingleResult();
        TestJava8TimeTypes.assertEquals((Object)LocalTime.parse(VAL_LOCAL_TIME), (Object)min);
        em.close();
    }

    public void testMinOffsetTime() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TypedQuery qry = em.createQuery("select min(t.offsetTimeField) from Java8TimeTypes AS t", OffsetTime.class);
        OffsetTime min = (OffsetTime)qry.getSingleResult();
        TestJava8TimeTypes.assertEquals((Object)this.insertedEntity.getOffsetTimeField().withOffsetSameInstant(this.insertedEntity.getOffsetTimeField().getOffset()), (Object)min.withOffsetSameInstant(this.insertedEntity.getOffsetTimeField().getOffset()));
        em.close();
    }

    public void testMinOffsetDateTime() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TypedQuery qry = em.createQuery("select min(t.offsetDateTimeField) from Java8TimeTypes AS t", OffsetDateTime.class);
        OffsetDateTime min = (OffsetDateTime)qry.getSingleResult();
        TestJava8TimeTypes.assertEquals((Object)Instant.from(this.insertedEntity.getOffsetDateTimeField()), (Object)Instant.from(min));
        em.close();
    }

    public void testCurrentDateLocalDate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TypedQuery qry = em.createQuery("select j from Java8TimeTypes AS j where j.localDateField < CURRENT_DATE", Java8TimeTypes.class);
        List times = qry.getResultList();
        TestJava8TimeTypes.assertNotNull((Object)times);
        TestJava8TimeTypes.assertTrue((!times.isEmpty() ? 1 : 0) != 0);
        em.close();
    }

    public void testCurrentDateLocalDateTime() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TypedQuery qry = em.createQuery("select j from Java8TimeTypes AS j where j.localDateTimeField < CURRENT_TIMESTAMP", Java8TimeTypes.class);
        List times = qry.getResultList();
        TestJava8TimeTypes.assertNotNull((Object)times);
        TestJava8TimeTypes.assertTrue((!times.isEmpty() ? 1 : 0) != 0);
        em.close();
    }
}

