/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.simple;

import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.simple.AllFieldTypes;
import org.apache.openjpa.persistence.simple.Person;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

public class TestEntityManagerMerge
extends SingleEMTestCase {
    @Override
    public void setUp() {
        this.setUp(AllFieldTypes.class, Person.class, DROP_TABLES);
    }

    public void testMerge() {
        this.begin();
        AllFieldTypes testObject = new AllFieldTypes();
        testObject.setStringField("new test object");
        this.persist(testObject);
        TestEntityManagerMerge.assertTrue((String)"testObject not found in pc", (boolean)this.em.contains((Object)testObject));
        testObject.setStringField("updated test object");
        AllFieldTypes mergedObject = (AllFieldTypes)this.em.merge((Object)testObject);
        TestEntityManagerMerge.assertTrue((String)"mergedObject and testObject are not equal", (boolean)mergedObject.equals(testObject));
        TestEntityManagerMerge.assertTrue((String)"mergedObject and testObject are not ==", (mergedObject == testObject ? 1 : 0) != 0);
        TestEntityManagerMerge.assertTrue((String)"testObject not found in pc", (boolean)this.em.contains((Object)testObject));
        TestEntityManagerMerge.assertTrue((String)"mergedObject not found in pc", (boolean)this.em.contains((Object)mergedObject));
        testObject.setStringField("yet another update");
        AllFieldTypes mergedObject2 = (AllFieldTypes)this.em.merge((Object)testObject);
        TestEntityManagerMerge.assertTrue((String)"mergedObject2 and testObject are not equal", (boolean)mergedObject2.equals(testObject));
        TestEntityManagerMerge.assertTrue((String)"mergedObject2 and testObject are not ==", (mergedObject2 == testObject ? 1 : 0) != 0);
        TestEntityManagerMerge.assertTrue((String)"testObject not found in pc", (boolean)this.em.contains((Object)testObject));
        TestEntityManagerMerge.assertTrue((String)"mergedObject2 not found in pc", (boolean)this.em.contains((Object)mergedObject2));
        this.rollback();
    }

    public void testMergeExistingEntity() {
        Person p = new Person();
        p.setId(102);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)p);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        p = new Person();
        p.setId(102);
        p.setForename("Jane");
        em.getTransaction().begin();
        em.merge((Object)p);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        p = (Person)em.createQuery("Select p from Person p where p.id = 102").getSingleResult();
        TestEntityManagerMerge.assertNotNull((Object)p);
        TestEntityManagerMerge.assertEquals((String)"Jane", (String)p.getForename());
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestEntityManagerMerge.class);
    }
}

