/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.sequence;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.sequence.GeneratedIdObject;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestSequenceGenerationOnMT
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, GeneratedIdObject.class, "openjpa.Multithreaded", "true");
    }

    public void testIdGenerationInMultithreadedEnvironment() {
        int nThreads = 5;
        ExecutorService threads = Executors.newFixedThreadPool(nThreads);
        ArrayList<Object> tasks = new ArrayList<Object>();
        for (int i = 0; i < nThreads; ++i) {
            Loader loader = new Loader((EntityManager)this.emf.createEntityManager());
            tasks.add(loader);
        }
        try {
            List results = threads.invokeAll(tasks);
            for (Future future : results) {
                TestSequenceGenerationOnMT.assertTrue((boolean)((Boolean)future.get()));
            }
        }
        catch (ExecutionException ee) {
            ee.getCause().printStackTrace();
            TestSequenceGenerationOnMT.fail((String)("Failed " + ee.getCause()));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            TestSequenceGenerationOnMT.fail((String)("Failed " + e));
        }
    }

    public static class Loader
    implements Callable<Boolean> {
        EntityManager em;

        Loader(EntityManager em) {
            this.em = em;
        }

        @Override
        public Boolean call() throws Exception {
            GeneratedIdObject pc = new GeneratedIdObject();
            this.em.getTransaction().begin();
            this.em.persist((Object)pc);
            this.em.getTransaction().commit();
            return true;
        }
    }
}

