/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.results.cls;

import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.results.cls.ResultClsAnnotation;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestResultClsAnnotation
extends SQLListenerTestCase {
    @Override
    public void setUp() {
        this.setUp(ResultClsAnnotation.class, DROP_TABLES);
        TestResultClsAnnotation.assertNotNull((Object)this.emf);
        this.populate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIt() {
        try (OpenJPAEntityManagerSPI em = this.emf.createEntityManager();){
            Query q = this.getQuery((EntityManager)em);
            List result = q.getResultList();
            TestResultClsAnnotation.assertEquals((int)1, (int)result.size());
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                ResultClsAnnotation resultClsAnnotation;
                ResultClsAnnotation obj;
                ResultClsAnnotation ct = obj = (resultClsAnnotation = (ResultClsAnnotation)iterator.next());
                TestResultClsAnnotation.assertEquals((String)"id1", (String)ct.getId());
                TestResultClsAnnotation.assertEquals((String)"description1", (String)ct.getDescription());
            }
        }
    }

    private void populate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ResultClsAnnotation ct = new ResultClsAnnotation();
        ct.setId("id1");
        ct.setDescription("description1");
        em.persist((Object)ct);
        em.getTransaction().commit();
        em.close();
    }

    private Query getQuery(EntityManager em) {
        DBDictionary dict = this.getDBDictionary();
        Query query = null;
        query = dict.getLeadingDelimiter().equals("\"") && dict.getTrailingDelimiter().equals("\"") ? em.createNamedQuery("ResultClsQueryDoubleQuotes") : (dict.getLeadingDelimiter().equals("`") && dict.getTrailingDelimiter().equals("`") ? em.createNamedQuery("ResultClsQueryBackTicks") : (dict.getLeadingDelimiter().equals("[") && dict.getTrailingDelimiter().equals("]") ? em.createNamedQuery("ResultClsQueryBrackets") : em.createNamedQuery("ResultClsQueryDefault")));
        return query;
    }
}

