/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.relations.TargetedIFaceRelationParent;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestTargetedIFaceRelations
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(TargetedIFaceRelationParent.class);
    }

    public void testPersist() {
        TargetedIFaceRelationParent parent = new TargetedIFaceRelationParent();
        parent.setName("parent");
        TargetedIFaceRelationParent child = new TargetedIFaceRelationParent();
        child.setName("child");
        parent.setIFace(child);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)parent);
        em.getTransaction().commit();
        long id = parent.getId();
        TestTargetedIFaceRelations.assertTrue((id != 0L ? 1 : 0) != 0);
        em.close();
        em = this.emf.createEntityManager();
        parent = (TargetedIFaceRelationParent)em.find(TargetedIFaceRelationParent.class, (Object)id);
        TestTargetedIFaceRelations.assertNotNull((Object)parent);
        TestTargetedIFaceRelations.assertEquals((String)"parent", (String)parent.getName());
        TestTargetedIFaceRelations.assertNotNull((Object)parent.getIFace());
        TestTargetedIFaceRelations.assertEquals((String)"child", (String)parent.getIFace().getName());
        TestTargetedIFaceRelations.assertEquals(TargetedIFaceRelationParent.class, parent.getIFace().getClass());
        TestTargetedIFaceRelations.assertNull((Object)((TargetedIFaceRelationParent)parent.getIFace()).getIFace());
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestTargetedIFaceRelations.class);
    }
}

