/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import java.util.Set;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.PersistenceException;
import org.apache.openjpa.persistence.relations.ChildChildClass;
import org.apache.openjpa.persistence.relations.ChildClass;
import org.apache.openjpa.persistence.relations.GrandChildClass;
import org.apache.openjpa.persistence.relations.ParentClass;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestJoinedMultiInheritanceHierarchy
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, ChildChildClass.class, ChildClass.class, GrandChildClass.class, ParentClass.class, "openjpa.BrokerImpl", "EvictFromDataCache=true");
    }

    public void testCacheSqlGeneration() throws PersistenceException {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        GrandChildClass notEmpty = new GrandChildClass();
        notEmpty.setName("Not empty object");
        Set<String> itemSet = notEmpty.getItems();
        for (int i = 0; i < 5; ++i) {
            itemSet.add(notEmpty.getName() + " : item n." + i);
        }
        notEmpty.setItems(itemSet);
        GrandChildClass empty = new GrandChildClass();
        empty.setName("empty object");
        em.persist((Object)notEmpty);
        em.persist((Object)empty);
        em.getTransaction().commit();
        em.evictAll();
        TestJoinedMultiInheritanceHierarchy.assertTrue((boolean)empty.getItems().isEmpty());
    }
}

