/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.textui.TestRunner;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.query.Magazine;
import org.apache.openjpa.persistence.query.Publisher;
import org.apache.openjpa.persistence.relations.Customer;
import org.apache.openjpa.persistence.relations.EntityA1InverseEager;
import org.apache.openjpa.persistence.relations.EntityA2InverseEager;
import org.apache.openjpa.persistence.relations.EntityAInverseEager;
import org.apache.openjpa.persistence.relations.EntityBInverseEager;
import org.apache.openjpa.persistence.relations.EntityCInverseEager;
import org.apache.openjpa.persistence.relations.EntityDInverseEager;
import org.apache.openjpa.persistence.relations.Order;
import org.apache.openjpa.persistence.relations.PPerson;
import org.apache.openjpa.persistence.relations.PPhone;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestInverseEagerSQL
extends SQLListenerTestCase {
    public int numCustomers = 1;
    public int numOrdersPerCustomer = 4;
    public int _nPeople = 3;
    public int _nPhones = 3;

    @Override
    public void setUp() {
        EntityBInverseEager b;
        int i;
        this.setUp(Customer.class, Customer.CustomerKey.class, Order.class, EntityAInverseEager.class, EntityA1InverseEager.class, EntityA2InverseEager.class, EntityBInverseEager.class, EntityCInverseEager.class, EntityDInverseEager.class, Publisher.class, Magazine.class, PPerson.class, PPhone.class, DROP_TABLES);
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Customer.CustomerKey ck = new Customer.CustomerKey("USA", 1);
        Customer c = new Customer();
        c.setCid(ck);
        c.setName("customer1");
        em.persist((Object)c);
        for (int i2 = 0; i2 < this.numOrdersPerCustomer; ++i2) {
            Order order = new Order();
            order.setCustomer(c);
            em.persist((Object)order);
        }
        EntityAInverseEager a = new EntityAInverseEager("a");
        em.persist((Object)a);
        EntityA1InverseEager a1 = new EntityA1InverseEager("a1");
        em.persist((Object)a1);
        EntityA2InverseEager a2 = new EntityA2InverseEager("a2");
        em.persist((Object)a2);
        for (i = 0; i < 4; ++i) {
            b = new EntityBInverseEager("b" + i);
            a.addB(b);
            b.setA(a);
            em.persist((Object)b);
        }
        for (i = 4; i < 8; ++i) {
            b = new EntityBInverseEager("b" + i);
            a1.addB(b);
            b.setA(a1);
            em.persist((Object)b);
        }
        for (i = 8; i < 12; ++i) {
            b = new EntityBInverseEager("b" + i);
            a2.addB(b);
            b.setA(a2);
            em.persist((Object)b);
        }
        for (i = 0; i < 4; ++i) {
            EntityCInverseEager c1 = new EntityCInverseEager("c" + i, i, i);
            em.persist((Object)c1);
            EntityDInverseEager d1 = new EntityDInverseEager("d" + i, "d" + i, i, i);
            em.persist((Object)d1);
            c1.setD(d1);
            d1.setC(c1);
        }
        Publisher p1 = new Publisher();
        p1.setName("publisher1");
        em.persist((Object)p1);
        for (int i3 = 0; i3 < 4; ++i3) {
            Magazine magazine = new Magazine();
            magazine.setIdPublisher(p1);
            magazine.setName("magagine" + i3 + "_" + p1.getName());
            em.persist((Object)magazine);
        }
        Publisher p2 = new Publisher();
        p2.setName("publisher2");
        em.persist((Object)p2);
        for (int i4 = 0; i4 < 4; ++i4) {
            Magazine magazine = new Magazine();
            magazine.setIdPublisher(p2);
            magazine.setName("magagine" + i4 + "_" + p2.getName());
            em.persist((Object)magazine);
        }
        for (int i5 = 0; i5 < this._nPeople; ++i5) {
            PPerson person = new PPerson();
            person.setPhones(new ArrayList<PPhone>());
            em.persist((Object)person);
            for (int j = 0; j < this._nPhones; ++j) {
                PPhone phone = new PPhone();
                phone.setPeople(new ArrayList<PPerson>());
                phone.getPeople().add(person);
                person.getPhones().add(phone);
                em.persist((Object)phone);
            }
        }
        em.flush();
        em.getTransaction().commit();
        em.close();
    }

    public void testOneToManyInverseEagerQuery() {
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAQuery q = em.createQuery("SELECT c FROM Customer c ");
        List res = q.getResultList();
        TestInverseEagerSQL.assertEquals((int)1, (int)res.size());
        Iterator iterator = res.iterator();
        while (iterator.hasNext()) {
            Customer re;
            Customer c = re = (Customer)iterator.next();
            Collection<Order> orders = c.getOrders();
            for (Order order : orders) {
                TestInverseEagerSQL.assertEquals((Object)order.getCustomer(), (Object)c);
            }
        }
        TestInverseEagerSQL.assertEquals((int)2, (int)this.sql.size());
        em.close();
    }

    public void testOneToOneInverseEagerQuery() {
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select c FROM EntityCInverseEager c";
        OpenJPAQuery q = em.createQuery(query);
        List res = q.getResultList();
        TestInverseEagerSQL.assertEquals((int)4, (int)res.size());
        Iterator iterator = res.iterator();
        while (iterator.hasNext()) {
            EntityCInverseEager re;
            EntityCInverseEager c = re = (EntityCInverseEager)iterator.next();
            EntityDInverseEager d = c.getD();
            TestInverseEagerSQL.assertEquals((Object)c, (Object)d.getC());
        }
        TestInverseEagerSQL.assertEquals((int)1, (int)this.sql.size());
        em.close();
    }

    public void testOneToManyInheritanceQuery() {
        EntityAInverseEager a;
        EntityBInverseEager b;
        List<EntityBInverseEager> listB;
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select a FROM EntityA1InverseEager a";
        OpenJPAQuery q = em.createQuery(query);
        List list = q.getResultList();
        TestInverseEagerSQL.assertEquals((int)1, (int)list.size());
        for (Object element : list) {
            EntityA1InverseEager a1 = (EntityA1InverseEager)element;
            listB = a1.getListB();
            TestInverseEagerSQL.assertEquals((int)4, (int)listB.size());
            for (EntityBInverseEager entityBInverseEager : listB) {
                EntityAInverseEager a2 = entityBInverseEager.getA();
                TestInverseEagerSQL.assertEquals((Object)a1, (Object)a2);
            }
        }
        TestInverseEagerSQL.assertEquals((int)3, (int)this.sql.size());
        this.sql.clear();
        query = "select a FROM EntityA2InverseEager a";
        q = em.createQuery(query);
        list = q.getResultList();
        TestInverseEagerSQL.assertEquals((int)1, (int)list.size());
        for (Object item : list) {
            EntityA2InverseEager a2 = (EntityA2InverseEager)item;
            listB = a2.getListB();
            TestInverseEagerSQL.assertEquals((int)4, (int)listB.size());
            for (Object e : listB) {
                b = (EntityBInverseEager)e;
                a = b.getA();
                TestInverseEagerSQL.assertEquals((Object)a2, (Object)a);
            }
        }
        TestInverseEagerSQL.assertEquals((int)3, (int)this.sql.size());
        this.sql.clear();
        query = "select a FROM EntityAInverseEager a";
        q = em.createQuery(query);
        list = q.getResultList();
        TestInverseEagerSQL.assertEquals((int)3, (int)list.size());
        for (Object value : list) {
            EntityAInverseEager a0 = (EntityAInverseEager)value;
            listB = a0.getListB();
            TestInverseEagerSQL.assertEquals((int)4, (int)listB.size());
            for (Object e : listB) {
                b = (EntityBInverseEager)e;
                a = b.getA();
                TestInverseEagerSQL.assertEquals((Object)a0, (Object)a);
            }
        }
        TestInverseEagerSQL.assertEquals((int)2, (int)this.sql.size());
        em.close();
    }

    public void testOneToManyEagerInverseLazyQuery() {
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select p FROM Publisher p";
        OpenJPAQuery q = em.createQuery(query);
        List list = q.getResultList();
        TestInverseEagerSQL.assertEquals((int)2, (int)list.size());
        TestInverseEagerSQL.assertEquals((int)2, (int)this.sql.size());
        this.sql.clear();
        em.clear();
        for (Object o : list) {
            Publisher p = (Publisher)o;
            Set<Magazine> magazines = p.getMagazineCollection();
            TestInverseEagerSQL.assertEquals((int)4, (int)magazines.size());
            for (Magazine m : magazines) {
                Publisher mp = m.getIdPublisher();
                TestInverseEagerSQL.assertEquals((Object)p, (Object)mp);
            }
        }
        TestInverseEagerSQL.assertEquals((int)0, (int)this.sql.size());
        em.close();
    }

    public void testManyToManyEagerEagerInverseLazyQuery() {
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select p FROM PPerson p";
        OpenJPAQuery q = em.createQuery(query);
        List list = q.getResultList();
        TestInverseEagerSQL.assertEquals((int)this._nPeople, (int)list.size());
        TestInverseEagerSQL.assertEquals((int)7, (int)this.sql.size());
        this.sql.clear();
        em.clear();
        for (Object o : list) {
            PPerson p = (PPerson)o;
            Collection<PPhone> phones = p.getPhones();
            TestInverseEagerSQL.assertEquals((int)this._nPhones, (int)phones.size());
            for (PPhone phone : p.getPhones()) {
                TestInverseEagerSQL.assertNotNull(phone.getPeople());
                TestInverseEagerSQL.assertTrue((boolean)phone.getPeople().contains(p));
            }
        }
        TestInverseEagerSQL.assertEquals((int)0, (int)this.sql.size());
        em.close();
    }

    public void testTargetOrphanRemoval() {
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        int count = this.count(Order.class);
        TestInverseEagerSQL.assertEquals((int)(this.numOrdersPerCustomer * this.numCustomers), (int)count);
        Customer.CustomerKey ck = new Customer.CustomerKey("USA", 1);
        Customer c = (Customer)em.find(Customer.class, (Object)ck);
        Collection<Order> orders = c.getOrders();
        TestInverseEagerSQL.assertEquals((int)this.numOrdersPerCustomer, (int)orders.size());
        Iterator<Order> iterator = orders.iterator();
        if (iterator.hasNext()) {
            Order order = iterator.next();
            orders.remove(order);
        }
        em.getTransaction().begin();
        em.persist((Object)c);
        em.flush();
        em.getTransaction().commit();
        em.clear();
        c = (Customer)em.find(Customer.class, (Object)ck);
        orders = c.getOrders();
        TestInverseEagerSQL.assertEquals((int)(this.numOrdersPerCustomer - 1), (int)orders.size());
        count = this.count(Order.class);
        TestInverseEagerSQL.assertEquals((int)(this.numOrdersPerCustomer * this.numCustomers - 1), (int)count);
        em.clear();
        c = (Customer)em.find(Customer.class, (Object)ck);
        c.setOrders(null);
        em.getTransaction().begin();
        em.persist((Object)c);
        em.flush();
        em.getTransaction().commit();
        em.clear();
        count = this.count(Order.class);
        TestInverseEagerSQL.assertEquals((int)(this.numOrdersPerCustomer * (this.numCustomers - 1)), (int)count);
        c = (Customer)em.find(Customer.class, (Object)ck);
        orders = c.getOrders();
        if (orders != null) {
            TestInverseEagerSQL.assertEquals((int)0, (int)orders.size());
        }
        em.close();
    }

    public void testSourceOrphanRemoval() {
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Customer.CustomerKey ck = new Customer.CustomerKey("USA", 1);
        Customer c = (Customer)em.find(Customer.class, (Object)ck);
        em.getTransaction().begin();
        em.remove((Object)c);
        em.flush();
        em.getTransaction().commit();
        em.clear();
        int count = this.count(Order.class);
        TestInverseEagerSQL.assertEquals((int)(this.numOrdersPerCustomer * (this.numCustomers - 1)), (int)count);
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestInverseEagerSQL.class);
    }
}

