/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.relations.entity.IncompleteRelationshipChildEntity;
import org.apache.openjpa.persistence.relations.entity.IncompleteRelationshipParentEntity;
import org.apache.openjpa.persistence.relations.entity.IncompleteRelationshipSubclass;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestIncompleteRelationship
extends SingleEMFTestCase {
    private static final String CLIENT_ID = "00000-00000-00000-00000-00000-00000";
    private static final String[] DISCOUNTS = new String[]{"Five-Finger Discount", "Staff Discount"};

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, IncompleteRelationshipParentEntity.class, IncompleteRelationshipParentEntity.IncompleteRelationshipParentEntityPk.class, IncompleteRelationshipChildEntity.class, IncompleteRelationshipChildEntity.IncompleteRelationshipChildEntityPk.class, IncompleteRelationshipSubclass.class, "openjpa.jdbc.QuerySQLCache", "true");
    }

    public void testIncompleteRelationship() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        IncompleteRelationshipSubclass parent = null;
        IncompleteRelationshipChildEntity child = null;
        em.getTransaction().begin();
        for (String s : DISCOUNTS) {
            child = new IncompleteRelationshipChildEntity(s, CLIENT_ID);
            em.persist((Object)child);
        }
        em.getTransaction().commit();
        for (int i = 1; i < 100; ++i) {
            em.getTransaction().begin();
            parent = new IncompleteRelationshipSubclass(i, CLIENT_ID);
            em.persist((Object)parent);
            em.getTransaction().commit();
            parent = (IncompleteRelationshipSubclass)em.createQuery("SELECT i FROM IncompleteRelationshipSubclass i WHERE   i.pk.id = :id AND     i.pk.clientId = :clientId ").setParameter("id", (Object)i).setParameter("clientId", (Object)CLIENT_ID).getSingleResult();
            TestIncompleteRelationship.assertEquals((int)parent.getPk().getId(), (int)i);
            TestIncompleteRelationship.assertNull((Object)parent.getChild());
        }
    }
}

