/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.relations.IdOrderedOneManyChild;
import org.apache.openjpa.persistence.relations.IdOrderedOneManyParent;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestIdOrderedOneMany
extends SingleEMFTestCase {
    private long id;

    @Override
    public void setUp() {
        this.setUp(IdOrderedOneManyParent.class, IdOrderedOneManyChild.class);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        IdOrderedOneManyParent parent = new IdOrderedOneManyParent();
        parent.setName("parent");
        em.persist((Object)parent);
        for (int i = 0; i < 3; ++i) {
            IdOrderedOneManyChild explicit = new IdOrderedOneManyChild();
            explicit.setId(3 - i);
            explicit.setName("explicit" + explicit.getId());
            explicit.setExplicitParent(parent);
            parent.getExplicitChildren().add(explicit);
            em.persist((Object)explicit);
            IdOrderedOneManyChild implicit = new IdOrderedOneManyChild();
            implicit.setId(100 - i);
            implicit.setName("implicit" + implicit.getId());
            implicit.setImplicitParent(parent);
            parent.getImplicitChildren().add(implicit);
            em.persist((Object)implicit);
        }
        em.getTransaction().commit();
        this.id = parent.getId();
        em.close();
    }

    public void testExplicitOrdering() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        IdOrderedOneManyParent parent = (IdOrderedOneManyParent)em.find(IdOrderedOneManyParent.class, (Object)this.id);
        TestIdOrderedOneMany.assertNotNull((Object)parent);
        TestIdOrderedOneMany.assertEquals((String)"parent", (String)parent.getName());
        TestIdOrderedOneMany.assertEquals((int)3, (int)parent.getExplicitChildren().size());
        for (int i = 0; i < 3; ++i) {
            TestIdOrderedOneMany.assertEquals((long)(i + 1), (long)parent.getExplicitChildren().get(i).getId());
            TestIdOrderedOneMany.assertEquals((String)("explicit" + (i + 1)), (String)parent.getExplicitChildren().get(i).getName());
        }
        em.close();
    }

    public void testImplicitOrdering() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        IdOrderedOneManyParent parent = (IdOrderedOneManyParent)em.find(IdOrderedOneManyParent.class, (Object)this.id);
        TestIdOrderedOneMany.assertNotNull((Object)parent);
        TestIdOrderedOneMany.assertEquals((String)"parent", (String)parent.getName());
        TestIdOrderedOneMany.assertEquals((int)3, (int)parent.getExplicitChildren().size());
        for (int i = 0; i < 3; ++i) {
            TestIdOrderedOneMany.assertEquals((long)(i + 98), (long)parent.getImplicitChildren().get(i).getId());
            TestIdOrderedOneMany.assertEquals((String)("implicit" + (i + 98)), (String)parent.getImplicitChildren().get(i).getName());
        }
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestIdOrderedOneMany.class);
    }
}

