/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import java.util.List;
import javax.persistence.EntityManager;
import junit.textui.TestRunner;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.relations.CascadingOneManyChild;
import org.apache.openjpa.persistence.relations.CascadingOneManyParent;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestCascadingOneManyWithForeignKey
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(CascadingOneManyParent.class, CascadingOneManyChild.class);
    }

    public void testPersist() {
        CascadingOneManyParent parent = new CascadingOneManyParent();
        parent.setName("parent");
        for (int i = 0; i < 2; ++i) {
            CascadingOneManyChild child = new CascadingOneManyChild();
            child.setName("child" + i);
            parent.addChild(child);
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)parent);
        em.getTransaction().commit();
        long id = parent.getId();
        TestCascadingOneManyWithForeignKey.assertEquals((int)2, (int)parent.getChildren().size());
        TestCascadingOneManyWithForeignKey.assertEquals((String)"child0", (String)parent.getChildren().get(0).getName());
        TestCascadingOneManyWithForeignKey.assertEquals((String)"child1", (String)parent.getChildren().get(1).getName());
        em.close();
        em = this.emf.createEntityManager();
        parent = (CascadingOneManyParent)em.find(CascadingOneManyParent.class, (Object)id);
        TestCascadingOneManyWithForeignKey.assertNotNull((Object)parent);
        TestCascadingOneManyWithForeignKey.assertEquals((String)"parent", (String)parent.getName());
        TestCascadingOneManyWithForeignKey.assertEquals((int)2, (int)parent.getChildren().size());
        TestCascadingOneManyWithForeignKey.assertEquals((String)"child0", (String)parent.getChildren().get(0).getName());
        TestCascadingOneManyWithForeignKey.assertEquals((String)"child1", (String)parent.getChildren().get(1).getName());
        em.close();
    }

    public void testDelete() {
        CascadingOneManyParent parent = new CascadingOneManyParent();
        parent.setName("parent");
        for (int i = 0; i < 2; ++i) {
            CascadingOneManyChild child = new CascadingOneManyChild();
            child.setName("child" + i);
            parent.addChild(child);
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)parent);
        em.getTransaction().commit();
        long id = parent.getId();
        em.close();
        em = this.emf.createEntityManager();
        parent = (CascadingOneManyParent)em.find(CascadingOneManyParent.class, (Object)id);
        TestCascadingOneManyWithForeignKey.assertNotNull((Object)parent);
        TestCascadingOneManyWithForeignKey.assertEquals((int)2, (int)parent.getChildren().size());
        em.getTransaction().begin();
        em.remove((Object)parent);
        em.getTransaction().commit();
        this.assertRemoved((EntityManager)em, id);
        em.close();
        em = this.emf.createEntityManager();
        this.assertRemoved((EntityManager)em, id);
        em.close();
    }

    private void assertRemoved(EntityManager em, long id) {
        TestCascadingOneManyWithForeignKey.assertNull((Object)em.find(CascadingOneManyParent.class, (Object)id));
        List res = em.createQuery("select c from CascadingOneManyChild c").getResultList();
        TestCascadingOneManyWithForeignKey.assertEquals((int)0, (int)res.size());
    }

    public void testForeignKey() {
        CascadingOneManyChild child;
        JDBCConfiguration conf = (JDBCConfiguration)this.emf.getConfiguration();
        if (!conf.getDBDictionaryInstance().supportsForeignKeys) {
            return;
        }
        CascadingOneManyParent parent = new CascadingOneManyParent();
        parent.setName("parent");
        for (int i = 0; i < 2; ++i) {
            child = new CascadingOneManyChild();
            child.setName("child" + i);
            parent.addChild(child);
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)parent);
        em.getTransaction().commit();
        long id = parent.getId();
        em.close();
        OpenJPAEntityManagerSPI oem = this.emf.createEntityManager();
        parent = (CascadingOneManyParent)oem.find(CascadingOneManyParent.class, (Object)id);
        TestCascadingOneManyWithForeignKey.assertNotNull((Object)parent);
        TestCascadingOneManyWithForeignKey.assertEquals((int)2, (int)parent.getChildren().size());
        child = parent.getChildren().get(0);
        oem.getTransaction().begin();
        oem.remove((Object)parent);
        TestCascadingOneManyWithForeignKey.assertTrue((boolean)oem.isRemoved((Object)child));
        oem.persist((Object)child);
        TestCascadingOneManyWithForeignKey.assertFalse((boolean)oem.isRemoved((Object)child));
        TestCascadingOneManyWithForeignKey.assertEquals((Object)parent, (Object)child.getParent());
        try {
            oem.getTransaction().commit();
            TestCascadingOneManyWithForeignKey.fail((String)"Commit should have failed due to FK constraint violation.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        oem.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestCascadingOneManyWithForeignKey.class);
    }
}

