/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.recursive;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.recursive.Node;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestRecursiveRelationships
extends SingleEMFTestCase {
    private int _l1Nodes = 3;
    private int _l2Nodes = 3;

    @Override
    public void setUp() {
        this.setUp(DROP_TABLES, Node.class);
    }

    public void testRecursiveNodes() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Node root = new Node();
        for (int i = 0; i < this._l1Nodes; ++i) {
            Node n1 = new Node();
            root.getNodes().add(n1);
            em.persist((Object)n1);
        }
        em.persist((Object)root);
        em.getTransaction().commit();
        em.refresh((Object)root);
        int rootId = root.getId();
        em.clear();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        root = (Node)em.getReference(Node.class, (Object)rootId);
        TestRecursiveRelationships.assertNotNull((Object)root);
        TestRecursiveRelationships.assertNotNull(root.getNodes());
        for (Node n : root.getNodes()) {
            for (int j = 0; j < this._l2Nodes; ++j) {
                Node n2 = new Node();
                n.getNodes().add(n.getNodes().size(), n2);
                em.persist((Object)n2);
            }
        }
        em.getTransaction().commit();
        em.clear();
        em.close();
        em = this.emf.createEntityManager();
        root = (Node)em.getReference(Node.class, (Object)rootId);
        TestRecursiveRelationships.assertNotNull((Object)root);
        TestRecursiveRelationships.assertNotNull(root.getNodes());
        TestRecursiveRelationships.assertEquals((int)this._l1Nodes, (int)root.getNodes().size());
        for (Node n : root.getNodes()) {
            TestRecursiveRelationships.assertEquals((int)this._l2Nodes, (int)n.getNodes().size());
        }
        em.close();
    }
}

