/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.querycache;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.querycache.QCEntity;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestQuerySQLCache
extends SQLListenerTestCase {
    EntityManager em;

    @Override
    public void setUp() {
        super.setUp(DROP_TABLES, "openjpa.jdbc.QuerySQLCache", "true", "openjpa.DataCache", "false", QCEntity.class);
        this.em = this.emf.createEntityManager();
        this.em.getTransaction().begin();
        QCEntity qc1 = new QCEntity("pk1", "description", 1L);
        QCEntity qc2 = new QCEntity("pk2", "description-2", 1L);
        QCEntity qc3 = new QCEntity("pk3", null, null);
        this.em.persist((Object)qc1);
        this.em.persist((Object)qc2);
        this.em.persist((Object)qc3);
        this.em.getTransaction().commit();
        this.em.clear();
    }

    public void testNullParamsWithNumericPosition01() {
        EntityManagerImpl eml = (EntityManagerImpl)this.em;
        TestQuerySQLCache.assertTrue((boolean)eml.getQuerySQLCache());
        Query q = this.em.createQuery("SELECT o from QCEntity o WHERE o.amount=?1");
        this.resetSQL();
        q.setParameter(1, null);
        List resultListNull1A = q.getResultList();
        TestQuerySQLCache.assertTrue((this.getLastSQL(this.sql) != null && this.getLastSQL(this.sql).contains("IS NULL") ? 1 : 0) != 0);
        TestQuerySQLCache.assertNotNull((Object)resultListNull1A);
        TestQuerySQLCache.assertEquals((int)1, (int)resultListNull1A.size());
        this.resetSQL();
        q.setParameter(1, null);
        List resultListNull1B = q.getResultList();
        TestQuerySQLCache.assertTrue((this.getLastSQL(this.sql) != null && this.getLastSQL(this.sql).contains("IS NULL") ? 1 : 0) != 0);
        TestQuerySQLCache.assertNotNull((Object)resultListNull1B);
        TestQuerySQLCache.assertEquals((int)1, (int)resultListNull1B.size());
        this.resetSQL();
        q.setParameter(1, (Object)1L);
        List resultListNotNull = q.getResultList();
        TestQuerySQLCache.assertTrue((this.getLastSQL(this.sql) != null && !this.getLastSQL(this.sql).contains("IS NULL") ? 1 : 0) != 0);
        TestQuerySQLCache.assertNotNull((Object)resultListNotNull);
        TestQuerySQLCache.assertEquals((int)2, (int)resultListNotNull.size());
        this.resetSQL();
        q.setParameter(1, null);
        List resultListNull2 = q.getResultList();
        TestQuerySQLCache.assertTrue((this.getLastSQL(this.sql) != null && this.getLastSQL(this.sql).contains("IS NULL") ? 1 : 0) != 0);
        TestQuerySQLCache.assertNotNull((Object)resultListNull2);
        TestQuerySQLCache.assertEquals((int)1, (int)resultListNull2.size());
    }

    public void testNullParamsWithNumericPosition02() {
        EntityManagerImpl eml = (EntityManagerImpl)this.em;
        TestQuerySQLCache.assertTrue((boolean)eml.getQuerySQLCache());
        this.resetSQL();
        Query q1 = this.em.createQuery("SELECT o from QCEntity o WHERE o.amount=?1");
        q1.setParameter(1, null);
        List resultListNull1A = q1.getResultList();
        TestQuerySQLCache.assertTrue((this.getLastSQL(this.sql) != null && this.getLastSQL(this.sql).contains("IS NULL") ? 1 : 0) != 0);
        TestQuerySQLCache.assertNotNull((Object)resultListNull1A);
        TestQuerySQLCache.assertEquals((int)1, (int)resultListNull1A.size());
        this.resetSQL();
        Query q2 = this.em.createQuery("SELECT o from QCEntity o WHERE o.amount=?1");
        q2.setParameter(1, null);
        List resultListNull1B = q2.getResultList();
        TestQuerySQLCache.assertTrue((this.getLastSQL(this.sql) != null && this.getLastSQL(this.sql).contains("IS NULL") ? 1 : 0) != 0);
        TestQuerySQLCache.assertNotNull((Object)resultListNull1B);
        TestQuerySQLCache.assertEquals((int)1, (int)resultListNull1B.size());
        this.resetSQL();
        Query q3 = this.em.createQuery("SELECT o from QCEntity o WHERE o.amount=?1");
        q3.setParameter(1, (Object)1L);
        List resultListNotNull = q3.getResultList();
        TestQuerySQLCache.assertTrue((this.getLastSQL(this.sql) != null && !this.getLastSQL(this.sql).contains("IS NULL") ? 1 : 0) != 0);
        TestQuerySQLCache.assertNotNull((Object)resultListNotNull);
        TestQuerySQLCache.assertEquals((int)2, (int)resultListNotNull.size());
        this.resetSQL();
        Query q4 = this.em.createQuery("SELECT o from QCEntity o WHERE o.amount=?1");
        q4.setParameter(1, null);
        List resultListNull2 = q4.getResultList();
        TestQuerySQLCache.assertTrue((this.getLastSQL(this.sql) != null && this.getLastSQL(this.sql).contains("IS NULL") ? 1 : 0) != 0);
        TestQuerySQLCache.assertNotNull((Object)resultListNull2);
        TestQuerySQLCache.assertEquals((int)1, (int)resultListNull2.size());
    }

    public void testNullParamsWithNamedQuery01() {
        EntityManagerImpl eml = (EntityManagerImpl)this.em;
        TestQuerySQLCache.assertTrue((boolean)eml.getQuerySQLCache());
        Query q = this.em.createNamedQuery("QCEntity.getByAmount");
        this.resetSQL();
        q.setParameter("amount", null);
        List resultListNull1A = q.getResultList();
        TestQuerySQLCache.assertTrue((this.getLastSQL(this.sql) != null && this.getLastSQL(this.sql).contains("IS NULL") ? 1 : 0) != 0);
        TestQuerySQLCache.assertNotNull((Object)resultListNull1A);
        TestQuerySQLCache.assertEquals((int)1, (int)resultListNull1A.size());
        this.em.clear();
        this.resetSQL();
        q.setParameter("amount", null);
        List resultListNull1B = q.getResultList();
        TestQuerySQLCache.assertTrue((this.getLastSQL(this.sql) != null && this.getLastSQL(this.sql).contains("IS NULL") ? 1 : 0) != 0);
        TestQuerySQLCache.assertNotNull((Object)resultListNull1B);
        TestQuerySQLCache.assertEquals((int)1, (int)resultListNull1B.size());
        this.em.clear();
        this.resetSQL();
        q.setParameter("amount", (Object)1L);
        List resultListNotNull = q.getResultList();
        TestQuerySQLCache.assertTrue((this.getLastSQL(this.sql) != null && !this.getLastSQL(this.sql).contains("IS NULL") ? 1 : 0) != 0);
        TestQuerySQLCache.assertNotNull((Object)resultListNotNull);
        TestQuerySQLCache.assertEquals((int)2, (int)resultListNotNull.size());
        this.em.clear();
        this.resetSQL();
        q.setParameter("amount", null);
        List resultListNull2 = q.getResultList();
        TestQuerySQLCache.assertTrue((this.getLastSQL(this.sql) != null && this.getLastSQL(this.sql).contains("IS NULL") ? 1 : 0) != 0);
        TestQuerySQLCache.assertNotNull((Object)resultListNull2);
        TestQuerySQLCache.assertEquals((int)1, (int)resultListNull2.size());
        this.em.clear();
    }

    public void testNullParamsWithNamedQuery02() {
        EntityManagerImpl eml = (EntityManagerImpl)this.em;
        TestQuerySQLCache.assertTrue((boolean)eml.getQuerySQLCache());
        this.resetSQL();
        Query q1A = this.em.createNamedQuery("QCEntity.getByAmount");
        q1A.setParameter("amount", null);
        List resultListNull1A = q1A.getResultList();
        TestQuerySQLCache.assertTrue((this.getLastSQL(this.sql) != null && this.getLastSQL(this.sql).contains("IS NULL") ? 1 : 0) != 0);
        TestQuerySQLCache.assertNotNull((Object)resultListNull1A);
        TestQuerySQLCache.assertEquals((int)1, (int)resultListNull1A.size());
        this.em.clear();
        this.resetSQL();
        Query q1B = this.em.createNamedQuery("QCEntity.getByAmount");
        q1B.setParameter("amount", null);
        List resultListNull1B = q1B.getResultList();
        TestQuerySQLCache.assertTrue((this.getLastSQL(this.sql) != null && this.getLastSQL(this.sql).contains("IS NULL") ? 1 : 0) != 0);
        TestQuerySQLCache.assertNotNull((Object)resultListNull1B);
        TestQuerySQLCache.assertEquals((int)1, (int)resultListNull1B.size());
        this.em.clear();
        this.resetSQL();
        Query q2 = this.em.createNamedQuery("QCEntity.getByAmount");
        q2.setParameter("amount", (Object)1L);
        List resultListNotNull = q2.getResultList();
        TestQuerySQLCache.assertTrue((this.getLastSQL(this.sql) != null && !this.getLastSQL(this.sql).contains("IS NULL") ? 1 : 0) != 0);
        TestQuerySQLCache.assertNotNull((Object)resultListNotNull);
        TestQuerySQLCache.assertEquals((int)2, (int)resultListNotNull.size());
        this.em.clear();
        this.resetSQL();
        Query q3 = this.em.createNamedQuery("QCEntity.getByAmount");
        q3.setParameter("amount", null);
        List resultListNull2 = q3.getResultList();
        TestQuerySQLCache.assertTrue((this.getLastSQL(this.sql) != null && this.getLastSQL(this.sql).contains("IS NULL") ? 1 : 0) != 0);
        TestQuerySQLCache.assertNotNull((Object)resultListNull2);
        TestQuerySQLCache.assertEquals((int)1, (int)resultListNull2.size());
        this.em.clear();
    }
}

