/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.querycache;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.querycache.QCEntity;
import org.apache.openjpa.persistence.querycache.QCEntityM2O;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestQueryCacheWithDataCache
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        super.setUp(DROP_TABLES, QCEntityM2O.class, QCEntity.class, "openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm", "openjpa.QueryCache", "true");
    }

    public void testWithFetchPlan() {
        this.populate();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.doQueryWithFetchPlan((EntityManager)em);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.doQueryWithFetchPlan((EntityManager)em);
        em.getTransaction().commit();
        em.close();
    }

    public void doQueryWithFetchPlan(EntityManager em) {
        String jpql = "Select e1 from QCEntityM2O e1";
        Query q = em.createQuery(jpql);
        FetchPlan fetchPlan = ((OpenJPAQuery)q.unwrap(OpenJPAQuery.class)).getFetchPlan();
        fetchPlan.addField(QCEntityM2O.class, "qc");
        List results = q.getResultList();
        em.clear();
        TestQueryCacheWithDataCache.assertTrue((String)"No results returned!", (!results.isEmpty() ? 1 : 0) != 0);
        for (QCEntityM2O e1 : results) {
            TestQueryCacheWithDataCache.assertNotNull((String)"A 'QCEntity' should have been returned!", (Object)e1.getQc());
        }
    }

    public void populate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        QCEntityM2O e1 = new QCEntityM2O("aQCEntityM2O");
        QCEntity e2 = new QCEntity("aQCEntityM2O", "test", 2L);
        e1.setQc(e2);
        em.persist((Object)e1);
        em.persist((Object)e2);
        em.getTransaction().commit();
        em.close();
    }
}

