/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query.sqlresultmapping;

import java.sql.Timestamp;
import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.query.sqlresultmapping.CrtOperacaoEntity;
import org.apache.openjpa.persistence.query.sqlresultmapping.CrtRequisicaoChequePersEntity;
import org.apache.openjpa.persistence.query.sqlresultmapping.CrtRequisicaoEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestSQLResultSetMapping
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        super.setUp(DROP_TABLES, CrtOperacaoEntity.class, CrtRequisicaoEntity.class, CrtRequisicaoChequePersEntity.class);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        CrtOperacaoEntity op = new CrtOperacaoEntity();
        op.setId(25384L);
        op.setDataHora(Timestamp.valueOf("2014-12-16 15:24:54.0"));
        em.persist((Object)op);
        CrtOperacaoEntity op2 = new CrtOperacaoEntity();
        op2.setId(23409L);
        op2.setDataHora(Timestamp.valueOf("2014-10-27 16:12:53.0"));
        em.persist((Object)op2);
        CrtRequisicaoChequePersEntity reqCheq = new CrtRequisicaoChequePersEntity();
        reqCheq.setId(500006164L);
        reqCheq.setCrtOperacaoByOperacaoRecepcaoServCent(op);
        reqCheq.setCrtOperacaoByOperacaoRequisicao(op2);
        em.persist((Object)reqCheq);
        em.getTransaction().commit();
        em.close();
    }

    public void testMappingNoException() {
        String sql = "SELECT t0.ID, t2.DATA_HORA as opRecepcaoServCentraisDataHora, t2.ID as opRecepcaoServCentraisId FROM CRT_REQUISICAO_CHEQUE_PERS t0, CRT_OPERACAO t2 WHERE t0.ID = 500006164 and t2.ID = 25384";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query query = em.createNativeQuery(sql, "MyResultMapping");
        List res = query.getResultList();
        TestSQLResultSetMapping.assertEquals((int)res.size(), (int)1);
        TestSQLResultSetMapping.assertEquals((long)500006164L, (long)((CrtRequisicaoChequePersEntity)res.get(0)).getId());
        TestSQLResultSetMapping.assertEquals((long)25384L, (long)((CrtRequisicaoChequePersEntity)res.get(0)).getCrtOperacaoByOperacaoRecepcaoServCent().getId());
        TestSQLResultSetMapping.assertEquals((Object)Timestamp.valueOf("2014-12-16 15:24:54.0"), (Object)((CrtRequisicaoChequePersEntity)res.get(0)).getCrtOperacaoByOperacaoRecepcaoServCent().getDataHora());
        em.close();
    }

    public void testMappingCorrectID() {
        String sql = "SELECT t0.ID, t1.ID as opRecepcaoServCentraisId, t1.DATA_HORA as opRecepcaoServCentraisDataHora, t2.ID, t2.DATA_HORA, t3.ID, t4.ID, t4.OPERACAO_RECEPCAO_SERV_CENT, t4.OPERACAO_REQUISICAO FROM CRT_REQUISICAO_CHEQUE_PERS t0 LEFT OUTER JOIN CRT_OPERACAO t1 ON t0.OPERACAO_RECEPCAO_SERV_CENT = t1.ID LEFT OUTER JOIN CRT_OPERACAO t2 ON t0.OPERACAO_REQUISICAO = t2.ID LEFT OUTER JOIN CRT_REQUISICAO t3 ON t0.ID = t3.ID INNER JOIN CRT_REQUISICAO t5 ON t0.ID = t5.ID LEFT OUTER JOIN CRT_REQUISICAO_CHEQUE_PERS t4 ON t3.ID = t4.ID WHERE t0.ID = 500006164";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query query = em.createNativeQuery(sql, "MyResultMapping");
        List res = query.getResultList();
        TestSQLResultSetMapping.assertEquals((int)res.size(), (int)1);
        TestSQLResultSetMapping.assertEquals((long)500006164L, (long)((CrtRequisicaoChequePersEntity)res.get(0)).getId());
        TestSQLResultSetMapping.assertEquals((long)25384L, (long)((CrtRequisicaoChequePersEntity)res.get(0)).getCrtOperacaoByOperacaoRecepcaoServCent().getId());
        TestSQLResultSetMapping.assertEquals((Object)Timestamp.valueOf("2014-12-16 15:24:54.0"), (Object)((CrtRequisicaoChequePersEntity)res.get(0)).getCrtOperacaoByOperacaoRecepcaoServCent().getDataHora());
        em.close();
    }
}

