/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.persistence.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestWildCardCount
extends SQLListenerTestCase {
    private EntityManager em;

    @Override
    public void setUp() throws Exception {
        super.setUp(RuntimeTest1.class, "openjpa.jdbc.QuerySQLCache", "false");
        this.em = this.emf.createEntityManager();
        this.sql.clear();
    }

    public void testWildCardForCountInSingleProjectTerm() {
        String jpql = "select COUNT(p) from RuntimeTest1 p";
        this.executeAndAssert(jpql);
    }

    public void testWildCardForCountInMultipleProjectTerms() {
        String jpql = "select COUNT(p.intField),SUM(p.intField) from RuntimeTest1 p GROUP BY p.intField";
        this.executeAndAssert(jpql);
    }

    public void testWildCardForCountInMultipleProjectTermsButCountIsNotFirstTerm() {
        String jpql = "select SUM(p.intField),COUNT(p.intField) from RuntimeTest1 p GROUP BY p.intField";
        this.executeAndAssert(jpql);
    }

    void executeAndAssert(String jpql) {
        this.executeAndAssert(true, jpql);
        this.executeAndAssert(false, jpql);
    }

    void executeAndAssert(boolean useWildCard, String jpql) {
        this.setWildCardForCount(useWildCard);
        this.sql.clear();
        this.em.createQuery(jpql).getResultList();
        TestWildCardCount.assertEquals((int)1, (int)this.sql.size());
        TestWildCardCount.assertEquals((boolean)this.getWildCardForCount(), (boolean)this.usesWildCardForCount((String)this.sql.get(0)));
    }

    boolean getWildCardForCount() {
        return ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().useWildCardForCount;
    }

    void setWildCardForCount(boolean flag) {
        ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().useWildCardForCount = flag;
    }

    boolean usesWildCardForCount(String sql) {
        return sql.contains("COUNT(*)");
    }
}

