/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.sql.SQLException;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.LockModeType;
import javax.persistence.LockTimeoutException;
import javax.persistence.PessimisticLockException;
import javax.persistence.Query;
import javax.persistence.QueryTimeoutException;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SolidDBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.exception.PObject;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;
import org.apache.openjpa.util.OpenJPAException;

public class TestTimeoutException
extends SingleEMFTestCase {
    private final Class<?> entityClass = PObject.class;

    @Override
    public void setUp() {
        OpenJPAEntityManagerFactorySPI tempEMF = this.emf;
        if (tempEMF == null) {
            tempEMF = this.createEMF(new Object[0]);
        }
        TestTimeoutException.assertNotNull((Object)tempEMF);
        DBDictionary dict = ((JDBCConfiguration)tempEMF.getConfiguration()).getDBDictionaryInstance();
        TestTimeoutException.assertNotNull((Object)dict);
        if (!dict.supportsSelectForUpdate || !dict.supportsQueryTimeout || dict instanceof SolidDBDictionary) {
            this.setTestsDisabled(true);
        }
        if (this.emf == null) {
            this.closeEMF((EntityManagerFactory)tempEMF);
        }
        if (this.isTestsDisabled()) {
            return;
        }
        super.setUp(this.entityClass, CLEAR_TABLES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryTimeOutExceptionWhileQueryingWithLocksOnAlreadyLockedEntities() {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)"***** Entered TestTimeoutException.testQueryTimeOutExceptionWhileQueryingWithLocksOnAlreadyLockedEntities()");
        }
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        TestTimeoutException.assertNotSame((Object)em1, (Object)em2);
        Object oid = this.createEntity((EntityManager)em1);
        em1.getTransaction().begin();
        Object entity = em1.find(this.entityClass, oid);
        TestTimeoutException.assertNotNull((Object)entity);
        em1.lock(entity, LockModeType.PESSIMISTIC_WRITE);
        em2.getTransaction().begin();
        Query query = em2.createQuery("select p from PObject p");
        query.setLockMode(LockModeType.PESSIMISTIC_WRITE);
        long timeout = 1000L;
        query.setHint("javax.persistence.query.timeout", (Object)timeout);
        try {
            query.getResultList();
            TestTimeoutException.fail((String)("Expected " + QueryTimeoutException.class.getName()));
        }
        catch (Throwable t) {
            this.assertError(t, QueryTimeoutException.class);
            TestTimeoutException.assertTrue((boolean)em2.getTransaction().isActive());
        }
        finally {
            em1.getTransaction().rollback();
            em1.close();
            em2.getTransaction().rollback();
            em2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLockTimeOutExceptionWhileLockingAlreadyLockedEntities() {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)"***** Entered TestTimeoutException.testLockTimeOutExceptionWhileLockingAlreadyLockedEntities()");
        }
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        TestTimeoutException.assertNotSame((Object)em1, (Object)em2);
        Object oid = this.createEntity((EntityManager)em1);
        em1.getTransaction().begin();
        Object entity1 = em1.find(this.entityClass, oid);
        TestTimeoutException.assertNotNull((Object)entity1);
        em1.lock(entity1, LockModeType.PESSIMISTIC_WRITE);
        em2.getTransaction().begin();
        Object entity2 = em2.find(this.entityClass, oid);
        long timeout = 1000L;
        try {
            HashMap<String, Long> hint = new HashMap<String, Long>();
            hint.put("javax.persistence.lock.timeout", 1000L);
            em2.lock(entity2, LockModeType.PESSIMISTIC_WRITE, hint);
            TestTimeoutException.fail((String)("Expected " + PessimisticLockException.class.getName()));
        }
        catch (Throwable t) {
            this.assertError(t, PessimisticLockException.class);
            TestTimeoutException.assertTrue((boolean)em2.getTransaction().isActive());
        }
        finally {
            em1.getTransaction().rollback();
            em1.close();
            em2.getTransaction().rollback();
            em2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryTimeOutExceptionWhileFindWithLocksOnAlreadyLockedEntities() {
        int timeout = 1000;
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)"***** Entered TestTimeoutException.testQueryTimeOutExceptionWhileFindWithLocksOnAlreadyLockedEntities()");
        }
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        TestTimeoutException.assertNotSame((Object)em1, (Object)em2);
        Object oid = this.createEntity((EntityManager)em1);
        em1.getTransaction().begin();
        Object entity = em1.find(this.entityClass, oid);
        TestTimeoutException.assertNotNull((Object)entity);
        em1.lock(entity, LockModeType.PESSIMISTIC_WRITE);
        em2.getTransaction().begin();
        try {
            HashMap<String, Integer> hint = new HashMap<String, Integer>();
            hint.put("javax.persistence.lock.timeout", 1000);
            em2.find(this.entityClass, oid, LockModeType.PESSIMISTIC_WRITE, hint);
            TestTimeoutException.fail((String)("Expected " + LockTimeoutException.class.getName()));
        }
        catch (Throwable t) {
            this.assertError(t, LockTimeoutException.class);
            TestTimeoutException.assertTrue((boolean)em2.getTransaction().isActive());
        }
        finally {
            em1.getTransaction().rollback();
            em1.close();
            em2.getTransaction().rollback();
            em2.close();
        }
    }

    public Object createEntity(EntityManager em) {
        long id = System.nanoTime();
        em.getTransaction().begin();
        PObject pc = new PObject();
        pc.setId(id);
        em.persist((Object)pc);
        em.getTransaction().commit();
        return id;
    }

    void assertError(Throwable actual, Class<? extends Throwable> expected) {
        if (!expected.isAssignableFrom(actual.getClass())) {
            this.getLog().error((Object)"TestTimeoutException.assertError() - unexpected exception type", actual);
            this.print(actual, 0);
            TestTimeoutException.fail((String)(actual.getClass().getName() + " was raised but expected " + expected.getName()));
        }
        Object failed = this.getFailedObject(actual);
        TestTimeoutException.assertNotNull((String)"Failed object is null", (Object)failed);
        TestTimeoutException.assertNotEquals("null", failed);
    }

    Object getFailedObject(Throwable e) {
        if (e == null) {
            this.getLog().error((Object)"TestTimeoutException.getFailedObject() - Object e was null");
            return null;
        }
        if (e instanceof LockTimeoutException) {
            return ((LockTimeoutException)e).getObject();
        }
        if (e instanceof PessimisticLockException) {
            return ((PessimisticLockException)e).getEntity();
        }
        if (e instanceof QueryTimeoutException) {
            return ((QueryTimeoutException)e).getQuery();
        }
        if (e instanceof OpenJPAException) {
            return ((OpenJPAException)e).getFailedObject();
        }
        this.getLog().error((Object)"TestTimeoutException.getFailedObject() - unexpected exception type", e);
        return null;
    }

    void print(Throwable t, int tab) {
        if (t == null) {
            return;
        }
        StringBuilder str = new StringBuilder(80);
        for (int i = 0; i < tab * 4; ++i) {
            str.append(" ");
        }
        String sqlState = t instanceof SQLException ? "(SQLState=" + ((SQLException)t).getSQLState() + ":" + t.getMessage() + ")" : "";
        str.append(t.getClass().getName() + sqlState);
        this.getLog().error((Object)str);
        if (t.getCause() == t) {
            return;
        }
        this.print(t.getCause(), tab + 1);
    }
}

