/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.Collection;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.query.BaseQueryTest;
import org.apache.openjpa.persistence.query.common.apps.RuntimeTest1;

public class TestQuotedNumbersInFilters2
extends BaseQueryTest {
    public TestQuotedNumbersInFilters2(String name) {
        super(name);
    }

    public void setUp() {
        this.deleteAll(RuntimeTest1.class);
        OpenJPAEntityManager pm = this.getEM();
        this.startTx((EntityManager)pm);
        pm.persist((Object)new RuntimeTest1("foo", 3));
        pm.persist((Object)new RuntimeTest1("bar", 15));
        pm.persist((Object)new RuntimeTest1("baz", -8));
        pm.persist((Object)new RuntimeTest1("baz2", 45));
        pm.persist((Object)new RuntimeTest1("3", 52));
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper("intField = -8"));
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper("intField = 15"));
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper("intField = 3"));
        TestQuotedNumbersInFilters2.assertEquals((long)0L, (long)this.helper("intField = 51"));
        TestQuotedNumbersInFilters2.assertEquals((long)0L, (long)this.helper("intField = 4"));
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper("intField = 52"));
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper("stringField = 'foo'"));
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper("stringField = 'bar'"));
    }

    public void testUnquotedNumbersWithExtraPrecision() {
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper("intField = 15"));
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper("intField = -8"));
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper("intField = 3"));
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper("intField = 45"));
    }

    public void testSingleQuotedStrings() {
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper("stringField = 'foo'"));
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper("stringField = '3'"));
    }

    public void testDoubleQuotedStrings() {
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper("stringField = 'foo'"));
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper("stringField = '3'"));
    }

    public void testKodo31SingleQuotedMultipleCharacterBehavior() {
        TestQuotedNumbersInFilters2.assertEquals((long)0L, (long)this.helper31("intField = '15'", true));
        TestQuotedNumbersInFilters2.assertEquals((long)0L, (long)this.helper31("intField = '52'", true));
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper31("intField = '49'", true));
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper31("intField = '-8'", true));
        TestQuotedNumbersInFilters2.assertEquals((long)0L, (long)this.helper31("intField = '15'", false));
        TestQuotedNumbersInFilters2.assertEquals((long)0L, (long)this.helper31("intField = '52'", false));
    }

    public void testKodo31UnquotedInMemBehavior() {
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper31("intField = 3", false));
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper31("intField = -8", false));
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper31("intField = 15", false));
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper31("intField = 45", false));
    }

    public void testKodo31UnquotedDatastoreBehavior() {
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper31("intField = 3", false));
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper31("intField = -8", false));
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper31("intField = 15", false));
        TestQuotedNumbersInFilters2.assertEquals((long)1L, (long)this.helper31("intField = 45", false));
    }

    private long helper(String filter) {
        return this.helper(filter, false);
    }

    private long helper(String filter, boolean shouldFail) {
        OpenJPAEntityManager pm = this.getEM();
        OpenJPAQuery q = pm.createQuery("SELECT r FROM RuntimeTest1 r WHERE r." + filter);
        long datastore = this.getResults((Query)q, shouldFail);
        q.setCandidateCollection((Collection)q.getResultList());
        long inmem = this.getResults((Query)q, shouldFail);
        if (datastore != inmem) {
            TestQuotedNumbersInFilters2.fail((String)("datastore query returned " + datastore + " values; inmem query returned " + inmem));
        }
        this.endEm((EntityManager)pm);
        return datastore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long helper31(String filter, boolean datastore) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.Compatibility", "QuotedNumbersInQueries=true");
        OpenJPAEntityManager pm = this.getEmf(props).createEntityManager();
        try {
            OpenJPAQuery q = pm.createQuery("SELECT r FROM RuntimeTest1 r WHERE r." + filter);
            if (!datastore) {
                q.setCandidateCollection((Collection)q.getResultList());
            }
            long l = this.getResults((Query)q, false);
            return l;
        }
        finally {
            this.endEm((EntityManager)pm);
        }
    }

    private long getResults(Query q, boolean shouldFail) {
        try {
            Integer result = q.getResultList().size();
            if (shouldFail) {
                TestQuotedNumbersInFilters2.fail((String)"should have failed");
            }
            return ((Number)result).longValue();
        }
        catch (IllegalArgumentException e) {
            if (!shouldFail) {
                throw e;
            }
            return -1L;
        }
    }
}

