/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.jdbc.sql.InformixDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.jdbc.sql.SQLServerDictionary;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.OptimisticLockException;
import org.apache.openjpa.persistence.PersistenceException;
import org.apache.openjpa.persistence.QueryTimeoutException;
import org.apache.openjpa.persistence.query.common.apps.QTimeout;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestQueryTimeout
extends SQLListenerTestCase {
    private DBDictionary dict = null;
    private boolean skipTests = false;
    private boolean skipExceptionTests = false;
    private boolean noSelectTimeouts = false;
    private String nativeUpdateStr = new String("UPDATE QTimeout SET stringField = ? WHERE mod(DELAY(2,id),2)=0");

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, QTimeout.class);
        this.getLog().trace((Object)"setUp()");
        this.dict = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance();
        TestQueryTimeout.assertNotNull((Object)this.dict);
        if (this.dict.supportsQueryTimeout) {
            if (this.dict instanceof DerbyDictionary) {
                this.setupCreateEntities();
                this.setupCreateDBFunction();
                this.skipExceptionTests = !this.setupCreateDBTriggers();
            } else if (this.dict instanceof DB2Dictionary) {
                this.setupCreateEntities();
                this.skipTests = true;
                this.skipExceptionTests = true;
            } else if (this.dict instanceof SQLServerDictionary || this.dict instanceof OracleDictionary) {
                this.setupCreateEntities();
                this.skipTests = true;
                this.noSelectTimeouts = true;
                this.skipExceptionTests = !this.setupCreateDBTriggers();
                this.nativeUpdateStr = "UPDATE QTimeout SET stringField = ? WHERE id = 1";
            } else if (this.dict instanceof InformixDictionary) {
                this.setupCreateEntities();
                this.skipExceptionTests = !this.setupCreateDBTriggers();
            } else {
                this.noSelectTimeouts = true;
                this.skipExceptionTests = true;
                this.skipTests = true;
                this.setTestsDisabled(true);
                this.getLog().info((Object)("TestQueryTimeout tests are being skipped, due to " + this.dict.platform + " not supporting Query Timeouts."));
            }
        } else {
            this.getLog().info((Object)("TestQueryTimeout tests are being skipped, due to " + this.dict.platform + " not supporting Query Timeouts."));
            this.skipExceptionTests = true;
            this.skipTests = true;
            this.setTestsDisabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryTimeout1a() {
        if (this.skipTests) {
            this.getLog().trace((Object)("testQueryTimeout1a - test is being skipped for " + this.dict.platform));
            return;
        }
        this.getLog().trace((Object)"testQueryTimeout1a() - No Query timeout");
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            TestQueryTimeout.assertNotNull((Object)em);
            Query q = em.createNamedQuery("NoHintList");
            Map hints = q.getHints();
            TestQueryTimeout.assertFalse((boolean)hints.containsKey("javax.persistence.query.timeout"));
            try {
                long startTime = System.currentTimeMillis();
                List results = q.getResultList();
                long endTime = System.currentTimeMillis();
                long runTime = endTime - startTime;
                this.getLog().trace((Object)("testQueryTimeout1a() - NoHintList runTime msecs=" + runTime));
                TestQueryTimeout.assertTrue((String)("Should have taken 6+ secs, but was msecs=" + runTime), (runTime > 5900L ? 1 : 0) != 0);
                TestQueryTimeout.assertEquals((String)"Verify we found 2 results.", (int)2, (int)results.size());
            }
            catch (Exception e) {
                TestQueryTimeout.fail((String)("Unexpected testQueryTimeout1a() exception = " + e));
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryTimeout1c() {
        if (this.skipTests) {
            this.getLog().trace((Object)("testQueryTimeout1c - test is being skipped for " + this.dict.platform));
            return;
        }
        this.getLog().trace((Object)"testQueryTimeout1c() - No executeUpdate timeout");
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            TestQueryTimeout.assertNotNull((Object)em);
            Query q = em.createQuery("UPDATE QTimeout q SET q.stringField = :strVal WHERE q.id = 1");
            q.setParameter("strVal", (Object)new String("updated"));
            Map hints = q.getHints();
            TestQueryTimeout.assertFalse((boolean)hints.containsKey("javax.persistence.query.timeout"));
            try {
                long startTime = System.currentTimeMillis();
                em.getTransaction().begin();
                int count = q.executeUpdate();
                em.getTransaction().commit();
                long endTime = System.currentTimeMillis();
                long runTime = endTime - startTime;
                this.getLog().trace((Object)("testQueryTimeout1c() - executeUpdate runTime msecs=" + runTime));
                TestQueryTimeout.assertTrue((String)"Verify we received one result.", (count == 1 ? 1 : 0) != 0);
                TestQueryTimeout.assertTrue((String)("Should have taken 2+ secs, but was msecs=" + runTime), (runTime > 1900L ? 1 : 0) != 0);
            }
            catch (Exception e) {
                TestQueryTimeout.fail((String)("Unexpected testQueryTimeout1c() exception = " + e));
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryTimeout21b() {
        if (this.skipTests) {
            this.getLog().trace((Object)("testQueryTimeout21b - test is being skipped for " + this.dict.platform));
            return;
        }
        this.getLog().trace((Object)"testQueryTimeout21b() - Map(timeout=0)");
        OpenJPAEntityManagerFactory emf = null;
        OpenJPAEntityManager em = null;
        Integer setTime = 0;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("javax.persistence.query.timeout", "0");
        try {
            emf = OpenJPAPersistence.createEntityManagerFactory((String)"qtimeout-no-properties", (String)"persistence3.xml", props);
            TestQueryTimeout.assertNotNull((Object)emf);
            OpenJPAConfiguration conf = emf.getConfiguration();
            TestQueryTimeout.assertNotNull((Object)conf);
            TestQueryTimeout.assertEquals((String)"Map provided query timeout", (int)setTime, (int)conf.getQueryTimeout());
            em = emf.createEntityManager();
            TestQueryTimeout.assertNotNull((Object)em);
            OpenJPAQuery q = em.createNamedQuery("NoHintSingle");
            Map hints = q.getHints();
            TestQueryTimeout.assertFalse((boolean)hints.containsKey("javax.persistence.query.timeout"));
            TestQueryTimeout.assertEquals((String)"Map provided query timeout", (int)setTime, (int)q.getFetchPlan().getQueryTimeout());
            try {
                long startTime = System.currentTimeMillis();
                Object result = q.getSingleResult();
                long endTime = System.currentTimeMillis();
                long runTime = endTime - startTime;
                this.getLog().trace((Object)("testQueryTimeout21b() - NoHintSingle runTime msecs=" + runTime));
                TestQueryTimeout.assertTrue((String)("Should have taken 2+ secs, but was msecs=" + runTime), (runTime > 1900L ? 1 : 0) != 0);
                TestQueryTimeout.assertNotNull((String)"Verify we received a result.", (Object)result);
            }
            catch (Exception e) {
                TestQueryTimeout.fail((String)("Unexpected testQueryTimeout21b() exception = " + e));
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryTimeout22a() {
        if (this.skipTests) {
            this.getLog().trace((Object)("testQueryTimeout22a - test is being skipped for " + this.dict.platform));
            return;
        }
        this.getLog().trace((Object)"testQueryTimeout22a() - QueryHint=0");
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            TestQueryTimeout.assertNotNull((Object)em);
            Query q = em.createNamedQuery("Hint0msec");
            Map hints = q.getHints();
            TestQueryTimeout.assertTrue((boolean)hints.containsKey("javax.persistence.query.timeout"));
            Integer timeout = new Integer((String)hints.get("javax.persistence.query.timeout"));
            this.getLog().trace((Object)("testQueryTimeout22a() - Retrieved hint javax.persistence.query.timeout=" + timeout));
            TestQueryTimeout.assertEquals((Object)timeout, (Object)new Integer(0));
            try {
                long startTime = System.currentTimeMillis();
                List results = q.getResultList();
                long endTime = System.currentTimeMillis();
                long runTime = endTime - startTime;
                this.getLog().trace((Object)("testQueryTimeout22a() - Hint0msec runTime msecs=" + runTime));
                TestQueryTimeout.assertTrue((String)("Should have taken 6+ secs, but was msecs=" + runTime), (runTime > 5900L ? 1 : 0) != 0);
                TestQueryTimeout.assertEquals((String)"Verify we found 2 results.", (int)2, (int)results.size());
            }
            catch (Exception e) {
                TestQueryTimeout.fail((String)("Unexpected testQueryTimeout22a() exception = " + e));
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryTimeout23b() {
        if (this.skipTests) {
            this.getLog().trace((Object)("testQueryTimeout23b - test is being skipped for " + this.dict.platform));
            return;
        }
        Integer setTime = 0;
        this.getLog().trace((Object)("testQueryTimeout23b() - setHint(" + setTime + ")"));
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            TestQueryTimeout.assertNotNull((Object)em);
            Query q = em.createNamedQuery("NoHintSingle");
            Map hints = q.getHints();
            TestQueryTimeout.assertFalse((boolean)hints.containsKey("javax.persistence.query.timeout"));
            this.getLog().trace((Object)("testQueryTimeout23b() - Setting hint javax.persistence.query.timeout=" + setTime));
            q.setHint("javax.persistence.query.timeout", (Object)setTime);
            hints = q.getHints();
            TestQueryTimeout.assertTrue((boolean)hints.containsKey("javax.persistence.query.timeout"));
            Integer timeout = (Integer)hints.get("javax.persistence.query.timeout");
            this.getLog().trace((Object)("testQueryTimeout23b() - Retrieved hint javax.persistence.query.timeout=" + timeout));
            TestQueryTimeout.assertEquals((Object)timeout, (Object)setTime);
            try {
                long startTime = System.currentTimeMillis();
                Object result = q.getSingleResult();
                long endTime = System.currentTimeMillis();
                long runTime = endTime - startTime;
                this.getLog().trace((Object)("testQueryTimeout23b() - NoHintSingle runTime msecs=" + runTime));
                TestQueryTimeout.assertTrue((String)("Should have taken 2+ secs, but was msecs=" + runTime), (runTime > 1900L ? 1 : 0) != 0);
                TestQueryTimeout.assertNotNull((String)"Verify we received a result.", (Object)result);
            }
            catch (Exception e) {
                TestQueryTimeout.fail((String)("Unexpected testQueryTimeout23b() exception = " + e));
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryTimeout31c() {
        if (this.skipExceptionTests) {
            this.getLog().trace((Object)("testQueryTimeout31c - test is being skipped for " + this.dict.platform));
            return;
        }
        this.getLog().trace((Object)"testQueryTimeout31c() - PU(timeout=1000), executeUpdate timeout");
        OpenJPAEntityManagerFactory emf = null;
        OpenJPAEntityManager em = null;
        Integer setTime = 1000;
        boolean bRetry = true;
        try {
            emf = OpenJPAPersistence.createEntityManagerFactory((String)"qtimeout-1000msecs", (String)"persistence3.xml");
            TestQueryTimeout.assertNotNull((Object)emf);
            OpenJPAConfiguration conf = emf.getConfiguration();
            TestQueryTimeout.assertNotNull((Object)conf);
            TestQueryTimeout.assertEquals((String)"PU provided query timeout", (int)setTime, (int)conf.getQueryTimeout());
            em = emf.createEntityManager();
            TestQueryTimeout.assertNotNull((Object)em);
            OpenJPAQuery q = em.createNativeQuery(this.nativeUpdateStr);
            q.setParameter(1, (Object)new String("updated"));
            Map hints = q.getHints();
            TestQueryTimeout.assertFalse((boolean)hints.containsKey("javax.persistence.query.timeout"));
            TestQueryTimeout.assertEquals((String)"PU provided query timeout", (int)setTime, (int)q.getFetchPlan().getQueryTimeout());
            em.getTransaction().begin();
            for (int i = 0; i <= 1 && bRetry; ++i) {
                try {
                    long startTime = System.currentTimeMillis();
                    int count = q.executeUpdate();
                    em.getTransaction().commit();
                    long endTime = System.currentTimeMillis();
                    long runTime = endTime - startTime;
                    this.getLog().trace((Object)("testQueryTimeout31c() - executeUpdate runTime msecs=" + runTime));
                    TestQueryTimeout.fail((String)("QueryTimeout for executeUpdate failed to cause an Exception in testQueryTimeout31c(" + setTime + " mscs), runTime msecs=" + runTime));
                    continue;
                }
                catch (Exception e) {
                    bRetry = this.checkException("testQueryTimeout31c()", e);
                    if (!bRetry) continue;
                    this.getLog().trace((Object)"testQueryTimeout31c() - retrying... ");
                }
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryTimeout32a() {
        if (this.skipExceptionTests || this.noSelectTimeouts) {
            this.getLog().trace((Object)("testQueryTimeout32a - test is being skipped for " + this.dict.platform));
            return;
        }
        this.getLog().trace((Object)"testQueryTimeout32a() - PU(1000), Map(0), QueryHint(1000)");
        OpenJPAEntityManagerFactory emf = null;
        OpenJPAEntityManager em = null;
        Integer setTime = 0;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("javax.persistence.query.timeout", "0");
        try {
            emf = OpenJPAPersistence.createEntityManagerFactory((String)"qtimeout-1000msecs", (String)"persistence3.xml", props);
            TestQueryTimeout.assertNotNull((Object)emf);
            OpenJPAConfiguration conf = emf.getConfiguration();
            TestQueryTimeout.assertNotNull((Object)conf);
            TestQueryTimeout.assertEquals((String)"Map provided query timeout", (int)setTime, (int)conf.getQueryTimeout());
            em = emf.createEntityManager();
            TestQueryTimeout.assertNotNull((Object)em);
            OpenJPAQuery q = em.createNamedQuery("Hint1000msec");
            setTime = 1000;
            Map hints = q.getHints();
            TestQueryTimeout.assertTrue((boolean)hints.containsKey("javax.persistence.query.timeout"));
            Integer timeout = new Integer((String)hints.get("javax.persistence.query.timeout"));
            this.getLog().trace((Object)("testQueryTimeout32a() - Found javax.persistence.query.timeout=" + timeout));
            TestQueryTimeout.assertTrue((String)("Expected to find a javax.persistence.query.timeout=" + setTime), (timeout.intValue() == setTime.intValue() ? 1 : 0) != 0);
            TestQueryTimeout.assertEquals((String)"QueryHint provided query timeout", (int)setTime, (int)q.getFetchPlan().getQueryTimeout());
            try {
                long startTime = System.currentTimeMillis();
                List results = q.getResultList();
                long endTime = System.currentTimeMillis();
                long runTime = endTime - startTime;
                this.getLog().trace((Object)("testQueryTimeout32a() - Hint1000msec runTime msecs=" + runTime));
                TestQueryTimeout.fail((String)("QueryTimeout annotation failed to cause an Exception in testQueryTimeout32a(" + setTime + " msecs), runTime msecs=" + runTime));
            }
            catch (Exception e) {
                this.checkException("testQueryTimeout32a()", e);
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryTimeout33b() {
        if (this.skipExceptionTests || this.noSelectTimeouts) {
            this.getLog().trace((Object)("testQueryTimeout33b - test is being skipped for " + this.dict.platform));
            return;
        }
        Integer setTime = 1000;
        this.getLog().trace((Object)("testQueryTimeout33b() - setHint(" + setTime + ")"));
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            TestQueryTimeout.assertNotNull((Object)em);
            Query q = em.createNamedQuery("NoHintSingle");
            Map hints = q.getHints();
            TestQueryTimeout.assertFalse((boolean)hints.containsKey("javax.persistence.query.timeout"));
            this.getLog().trace((Object)("testQueryTimeout33b() - Setting hint javax.persistence.query.timeout=" + setTime));
            q.setHint("javax.persistence.query.timeout", (Object)setTime);
            hints = q.getHints();
            TestQueryTimeout.assertTrue((boolean)hints.containsKey("javax.persistence.query.timeout"));
            Integer timeout = (Integer)hints.get("javax.persistence.query.timeout");
            TestQueryTimeout.assertEquals((Object)timeout, (Object)setTime);
            try {
                long startTime = System.currentTimeMillis();
                Object result = q.getSingleResult();
                long endTime = System.currentTimeMillis();
                long runTime = endTime - startTime;
                this.getLog().trace((Object)("testQueryTimeout33b() - NoHintSingle runTime msecs=" + runTime));
                TestQueryTimeout.fail((String)("QueryTimeout annotation failed to cause an Exception in testQueryTimeout33b(" + setTime + " mscs), runTime msecs=" + runTime));
            }
            catch (Exception e) {
                this.checkException("testQueryTimeout33b()", e);
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryTimeout33c() {
        if (this.skipExceptionTests) {
            this.getLog().trace((Object)("testQueryTimeout33c - test is being skipped for " + this.dict.platform));
            return;
        }
        this.getLog().trace((Object)"testQueryTimeout33c() - PU(timeout=0), setHint(1000), executeUpdate timeout");
        OpenJPAEntityManagerFactory emf = null;
        OpenJPAEntityManager em = null;
        Integer setTime = 0;
        boolean bRetry = true;
        try {
            emf = OpenJPAPersistence.createEntityManagerFactory((String)"qtimeout-0msecs", (String)"persistence3.xml");
            TestQueryTimeout.assertNotNull((Object)emf);
            OpenJPAConfiguration conf = emf.getConfiguration();
            TestQueryTimeout.assertNotNull((Object)conf);
            TestQueryTimeout.assertEquals((String)"PU provided no query timeout", (int)setTime, (int)conf.getQueryTimeout());
            em = emf.createEntityManager();
            TestQueryTimeout.assertNotNull((Object)em);
            OpenJPAQuery q = em.createNativeQuery(this.nativeUpdateStr);
            q.setParameter(1, (Object)new String("updated"));
            Map hints = q.getHints();
            TestQueryTimeout.assertFalse((boolean)hints.containsKey("javax.persistence.query.timeout"));
            setTime = 1000;
            this.getLog().trace((Object)("testQueryTimeout33c() - Setting hint javax.persistence.query.timeout=" + setTime));
            q.setHint("javax.persistence.query.timeout", (Object)setTime);
            hints = q.getHints();
            TestQueryTimeout.assertTrue((boolean)hints.containsKey("javax.persistence.query.timeout"));
            Integer timeout = (Integer)hints.get("javax.persistence.query.timeout");
            TestQueryTimeout.assertEquals((Object)timeout, (Object)setTime);
            TestQueryTimeout.assertEquals((String)"PU provided query timeout", (int)setTime, (int)q.getFetchPlan().getQueryTimeout());
            em.getTransaction().begin();
            for (int i = 0; i <= 1 && bRetry; ++i) {
                try {
                    long startTime = System.currentTimeMillis();
                    int count = q.executeUpdate();
                    em.getTransaction().commit();
                    long endTime = System.currentTimeMillis();
                    long runTime = endTime - startTime;
                    this.getLog().trace((Object)("testQueryTimeout33c() - executeUpdate runTime msecs=" + runTime));
                    TestQueryTimeout.fail((String)("QueryTimeout for executeUpdate failed to cause an Exception in testQueryTimeout33c(" + setTime + " mscs), runTime msecs=" + runTime));
                    continue;
                }
                catch (Exception e) {
                    bRetry = this.checkException("testQueryTimeout33c()", e);
                    if (!bRetry) continue;
                    this.getLog().trace((Object)"testQueryTimeout33c() - retrying... ");
                }
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryTimeout4() {
        if (this.skipTests) {
            this.getLog().trace((Object)("testQueryTimeout4 - test is being skipped for " + this.dict.platform));
            return;
        }
        Integer setTime = -1;
        this.getLog().trace((Object)("testQueryTimeout4() - setHint(" + setTime + ")"));
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            TestQueryTimeout.assertNotNull((Object)em);
            Query q = em.createNamedQuery("NoHintSingle");
            Map hints = q.getHints();
            TestQueryTimeout.assertFalse((boolean)hints.containsKey("javax.persistence.query.timeout"));
            this.getLog().trace((Object)("testQueryTimeout4() - Setting hint javax.persistence.query.timeout=" + setTime));
            q.setHint("javax.persistence.query.timeout", (Object)setTime);
            hints = q.getHints();
            TestQueryTimeout.assertTrue((boolean)hints.containsKey("javax.persistence.query.timeout"));
            Integer timeout = (Integer)hints.get("javax.persistence.query.timeout");
            this.getLog().trace((Object)("testQueryTimeout4() - Retrieved hint javax.persistence.query.timeout=" + timeout));
            TestQueryTimeout.assertEquals((Object)timeout, (Object)setTime);
            try {
                long startTime = System.currentTimeMillis();
                Object result = q.getSingleResult();
                long endTime = System.currentTimeMillis();
                long runTime = endTime - startTime;
                this.getLog().trace((Object)("testQueryTimeout4() - NoHintSingle runTime msecs=" + runTime));
                TestQueryTimeout.assertTrue((String)("Should have taken 2+ secs, but was msecs=" + runTime), (runTime > 1900L ? 1 : 0) != 0);
                TestQueryTimeout.assertNotNull((String)"Verify we received a result.", (Object)result);
            }
            catch (Exception e) {
                TestQueryTimeout.fail((String)("Unexpected testQueryTimeout4() exception = " + e));
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryTimeout5() {
        Integer setTime = -2000;
        this.getLog().trace((Object)("testQueryTimeout5() - setHint(" + setTime + ")"));
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            TestQueryTimeout.assertNotNull((Object)em);
            Query q = em.createNamedQuery("NoHintSingle");
            Map hints = q.getHints();
            TestQueryTimeout.assertFalse((boolean)hints.containsKey("javax.persistence.query.timeout"));
            this.getLog().trace((Object)("testQueryTimeout5() - Setting hint javax.persistence.query.timeout=" + setTime));
            q.setHint("javax.persistence.query.timeout", (Object)setTime);
            TestQueryTimeout.fail((String)"Expected testQueryTimeout5() to throw a IllegalArgumentException");
        }
        catch (Exception e) {
            this.checkException("testQueryTimeout5()", e, IllegalArgumentException.class, null);
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryTimeout6() {
        if (this.skipTests) {
            this.getLog().trace((Object)("testQueryTimeout6 - test is being skipped for " + this.dict.platform));
            return;
        }
        this.getLog().trace((Object)"testQueryTimeout6() - No EM.find() update timeout");
        OpenJPAEntityManagerFactory emf = null;
        OpenJPAEntityManager em = null;
        Integer setTime = 1000;
        try {
            emf = OpenJPAPersistence.createEntityManagerFactory((String)"qtimeout-1000msecs", (String)"persistence3.xml");
            TestQueryTimeout.assertNotNull((Object)emf);
            OpenJPAConfiguration conf = emf.getConfiguration();
            TestQueryTimeout.assertNotNull((Object)conf);
            TestQueryTimeout.assertEquals((String)"PU provided timeout", (int)setTime, (int)conf.getQueryTimeout());
            em = emf.createEntityManager();
            TestQueryTimeout.assertNotNull((Object)em);
            try {
                long startTime = System.currentTimeMillis();
                QTimeout qt = (QTimeout)em.find(QTimeout.class, (Object)1);
                em.getTransaction().begin();
                qt.setStringField("updated");
                em.flush();
                em.getTransaction().commit();
                long endTime = System.currentTimeMillis();
                long runTime = endTime - startTime;
                this.getLog().trace((Object)("testQueryTimeout6() - EM find/update runTime msecs=" + runTime));
                TestQueryTimeout.assertTrue((String)("Should have taken 2+ secs, but was msecs=" + runTime), (runTime > 1900L ? 1 : 0) != 0);
                em.clear();
                qt = (QTimeout)em.find(QTimeout.class, (Object)1);
                TestQueryTimeout.assertEquals((String)"Verify the entity was updated.", (String)qt.getStringField(), (String)"updated");
            }
            catch (Exception e) {
                TestQueryTimeout.fail((String)("Unexpected testQueryTimeout6() exception = " + e));
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupCreateEntities() {
        this.getLog().trace((Object)"setupCreateEntities()");
        String[] _strings = new String[]{"a", "b", "c"};
        QTimeout qt = null;
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            TestQueryTimeout.assertNotNull((Object)em);
            this.getLog().trace((Object)"setupCreateEntities() - creating 3 Qtimeout");
            em.getTransaction().begin();
            for (int i = 0; i < _strings.length; ++i) {
                qt = new QTimeout(i, _strings[i]);
                em.persist((Object)qt);
            }
            em.getTransaction().commit();
        }
        catch (Exception e) {
            TestQueryTimeout.fail((String)("setupCreateEntities() - Unexpected Exception - " + e));
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    private void setupCreateDBFunction() {
        if (this.dict instanceof DerbyDictionary) {
            this.getLog().trace((Object)"setupCreateDBFunction()");
            try {
                this.exec(true, 0, "DROP TRIGGER t1");
                this.exec(true, 0, "DROP FUNCTION DELAY");
                this.exec(false, 0, "CREATE FUNCTION DELAY(SECONDS INTEGER, VALUE INTEGER) RETURNS INTEGER PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME 'org.apache.openjpa.persistence.query.TestQueryTimeout.delay'");
            }
            catch (SQLException sqe) {
                TestQueryTimeout.fail((String)sqe.toString());
            }
        } else {
            this.getLog().trace((Object)"setupCreateDBFunction() - skipping as DB != Derby");
        }
    }

    private boolean setupCreateDBTriggers() {
        boolean brc = false;
        this.getLog().trace((Object)"setupCreateDBTriggers()");
        try {
            if (this.dict instanceof DerbyDictionary || this.dict instanceof DB2Dictionary) {
                this.getLog().trace((Object)"setupCreateDBTriggers() - creating BEFORE TRIGGER for Derby and DB2");
                this.exec(true, 0, "DROP TRIGGER t1");
                this.exec(false, 0, "CREATE TRIGGER t1 NO CASCADE BEFORE UPDATE ON qtimeout FOR EACH ROW MODE DB2SQL values DELAY(2,-1)");
                brc = true;
            } else if (this.dict instanceof SQLServerDictionary) {
                this.getLog().trace((Object)"setupCreateDBTriggers() - creating BEFORE UPDATE TRIGGER for MS SQL Server");
                this.exec(true, 0, "DROP TRIGGER t1");
                this.exec(false, 0, "CREATE TRIGGER t1 ON QTimeout FOR UPDATE AS EXTERNAL NAME Delay.Delay.delay");
                brc = true;
            } else if (this.dict instanceof OracleDictionary) {
                this.getLog().trace((Object)"setupCreateDBTriggers() - creating BEFORE UPDATE TRIGGER for Oracle");
                this.exec(false, 0, "CREATE OR REPLACE TRIGGER \"OPENJPA\".T1 BEFORE UPDATE OF \"ID\", \"STRINGFIELD\", \"VERSIONFIELD\" ON \"OPENJPA\".\"QTIMEOUT\" CALL DELAY");
                brc = true;
            } else if (this.dict instanceof InformixDictionary) {
                this.getLog().trace((Object)"setupCreateDBTriggers() - creating BEFORE UPDATE TRIGGER for Informix");
                this.exec(true, 0, "DROP TRIGGER t1");
                this.exec(false, 0, "CREATE TRIGGER t1 UPDATE of Id, stringField, versionField ON QTimeout BEFORE(EXECUTE PROCEDURE delay5())");
                brc = true;
            } else {
                this.getLog().info((Object)("TestQueryTimeout tests are being skipped as triggers were not created for " + this.dict.platform));
            }
        }
        catch (SQLException sqe) {
            if (this.dict instanceof DerbyDictionary) {
                TestQueryTimeout.fail((String)sqe.toString());
            }
            this.getLog().info((Object)("TestQueryTimeout tests are being skipped, due to DB delay() function missing and/or problems creating the required triggers.  " + this.dict.platform + " requires manual setup steps for these tests."));
            this.getLog().trace((Object)"setupCreateDBTriggers() failed with SQLException = ", (Throwable)sqe);
        }
        return brc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec(boolean ignoreExceptions, int timeoutSecs, String sql) throws SQLException {
        OpenJPAEntityManagerSPI em = null;
        Statement s = null;
        try {
            em = this.emf.createEntityManager();
            TestQueryTimeout.assertNotNull((Object)em);
            Broker broker = JPAFacadeHelper.toBroker((EntityManager)em);
            Connection conn = (Connection)broker.getConnection();
            s = conn.createStatement();
            if (timeoutSecs > 0) {
                s.setQueryTimeout(timeoutSecs);
            }
            this.getLog().trace((Object)("execute(" + sql + ")"));
            s.execute(sql);
        }
        catch (SQLException sqe) {
            if (!ignoreExceptions) {
                throw sqe;
            }
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    private boolean checkException(String test, Exception e) {
        String eStr = new String("query statement timeout");
        boolean bRetry = this.matchesExpectedException(QueryTimeoutException.class, e, eStr);
        boolean bRollback = this.matchesExpectedException(PersistenceException.class, e, eStr);
        boolean bLockFailed = this.matchesExpectedException(OptimisticLockException.class, e, "Unable to obtain an object lock");
        TestQueryTimeout.assertTrue((String)(test + " - UNEXPECTED Exception = " + e), (bRetry || bRollback || bLockFailed ? 1 : 0) != 0);
        this.getLog().trace((Object)(test + " - Caught expected Exception = "), (Throwable)e);
        return bRetry;
    }

    private void checkException(String test, Exception tested, Class<?> expected, String eStr) {
        TestQueryTimeout.assertTrue((String)(test + " - UNEXPECTED Exception = " + tested), (boolean)this.matchesExpectedException(expected, tested, eStr));
        this.getLog().trace((Object)(test + " - Caught expected Exception = "), (Throwable)tested);
    }

    private boolean matchesExpectedException(Class<?> expected, Exception tested, String eStr) {
        Class<?> testExClass;
        TestQueryTimeout.assertNotNull(expected);
        boolean exMatched = false;
        if (tested != null && (exMatched = expected.isAssignableFrom(testExClass = tested.getClass())) && eStr != null) {
            exMatched = tested.getMessage().indexOf(eStr) != -1;
        }
        return exMatched;
    }

    public static int delay(int secs, int value) throws SQLException {
        try {
            Thread.sleep(secs * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value;
    }
}

